/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.beans.ConstructorProperties;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mValueConverter;
import org.eclipse.leshan.server.californium.LeshanServer;
import org.eclipse.leshan.server.californium.LeshanServerBuilder;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MAuthorizer;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MDtlsCertificateVerifier;
import org.thingsboard.server.transport.lwm2m.server.LwM2MNetworkConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2MTransportService;
import org.thingsboard.server.transport.lwm2m.server.LwM2mServerListener;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportCoapResource;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mVersionedModelProvider;
import org.thingsboard.server.transport.lwm2m.server.store.TbSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.DefaultLwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Component
@TbLwM2mTransportComponent
public class DefaultLwM2mTransportService
implements LwM2MTransportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2mTransportService.class);
    public static final CipherSuite[] RPK_OR_X509_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256};
    public static final CipherSuite[] PSK_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256};
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;
    private final OtaPackageDataCache otaPackageDataCache;
    private final DefaultLwM2mUplinkMsgHandler handler;
    private final CaliforniumRegistrationStore registrationStore;
    private final TbSecurityStore securityStore;
    private final TbLwM2MDtlsCertificateVerifier certificateVerifier;
    private final TbLwM2MAuthorizer authorizer;
    private final LwM2mVersionedModelProvider modelProvider;
    private LeshanServer server;

    @AfterStartUp(order=2147482648)
    public void init() {
        this.server = this.getLhServer();
        LwM2mTransportCoapResource otaCoapResource = new LwM2mTransportCoapResource(this.otaPackageDataCache, "tbfw");
        this.server.coap().getServer().add(new Resource[]{otaCoapResource});
        this.context.setServer(this.server);
        this.startLhServer();
    }

    private void startLhServer() {
        log.info("Starting LwM2M transport server...");
        this.server.start();
        LwM2mServerListener lhServerCertListener = new LwM2mServerListener(this.handler);
        this.server.getRegistrationService().addListener(lhServerCertListener.registrationListener);
        this.server.getPresenceService().addListener(lhServerCertListener.presenceListener);
        this.server.getObservationService().addListener(lhServerCertListener.observationListener);
        this.server.getSendService().addListener(lhServerCertListener.sendListener);
        log.info("Started LwM2M transport server.");
    }

    @PreDestroy
    public void shutdown() {
        try {
            log.info("Stopping LwM2M transport server!");
            this.server.destroy();
            log.info("LwM2M transport server stopped!");
        }
        catch (Exception e) {
            log.error("Failed to gracefully stop the LwM2M transport server!", (Throwable)e);
        }
    }

    private LeshanServer getLhServer() {
        LeshanServerBuilder builder = new LeshanServerBuilder();
        builder.setLocalAddress(this.config.getHost(), this.config.getPort().intValue());
        builder.setLocalSecureAddress(this.config.getSecureHost(), this.config.getSecurePort().intValue());
        builder.setDecoder((LwM2mDecoder)new DefaultLwM2mDecoder());
        builder.setEncoder((LwM2mEncoder)new DefaultLwM2mEncoder((LwM2mValueConverter)LwM2mValueConverterImpl.getInstance()));
        builder.setCoapConfig(LwM2MNetworkConfig.getCoapConfig(this.config.getPort(), this.config.getSecurePort(), this.config));
        builder.setObjectModelProvider((LwM2mModelProvider)this.modelProvider);
        builder.setSecurityStore((SecurityStore)this.securityStore);
        builder.setRegistrationStore(this.registrationStore);
        DtlsConnectorConfig.Builder dtlsConfig = new DtlsConnectorConfig.Builder(LwM2MNetworkConfig.getCoapConfig(this.config.getPort(), this.config.getSecurePort(), this.config));
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CURVES_ONLY, (Object)this.config.isRecommendedSupportedGroups());
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)this.config.isRecommendedCiphers());
        dtlsConfig.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, this.config.getDtlsRetransmissionTimeout(), TimeUnit.MILLISECONDS);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        this.setServerWithCredentials(builder, dtlsConfig);
        builder.setDtlsConfig(dtlsConfig);
        return builder.build();
    }

    private void setServerWithCredentials(LeshanServerBuilder builder, DtlsConnectorConfig.Builder dtlsConfig) {
        if (this.config.getSslCredentials() != null) {
            SslCredentials sslCredentials = this.config.getSslCredentials();
            builder.setPublicKey(sslCredentials.getPublicKey());
            builder.setPrivateKey(sslCredentials.getPrivateKey());
            builder.setCertificateChain(sslCredentials.getCertificateChain());
            dtlsConfig.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)this.certificateVerifier);
            builder.setAuthorizer((Authorizer)this.authorizer);
            dtlsConfig.setAsList((BasicListDefinition)DtlsConfig.DTLS_CIPHER_SUITES, (Object[])RPK_OR_X509_CIPHER_SUITES);
        } else {
            builder.setTrustedCertificates((Certificate[])new X509Certificate[0]);
            log.info("Unable to load X509 files for LWM2MServer");
            dtlsConfig.setAsList((BasicListDefinition)DtlsConfig.DTLS_CIPHER_SUITES, (Object[])PSK_CIPHER_SUITES);
        }
    }

    public String getName() {
        return "LWM2M";
    }

    @ConstructorProperties(value={"context", "config", "otaPackageDataCache", "handler", "registrationStore", "securityStore", "certificateVerifier", "authorizer", "modelProvider"})
    public DefaultLwM2mTransportService(LwM2mTransportContext context, LwM2MTransportServerConfig config, OtaPackageDataCache otaPackageDataCache, DefaultLwM2mUplinkMsgHandler handler, CaliforniumRegistrationStore registrationStore, TbSecurityStore securityStore, TbLwM2MDtlsCertificateVerifier certificateVerifier, TbLwM2MAuthorizer authorizer, LwM2mVersionedModelProvider modelProvider) {
        this.context = context;
        this.config = config;
        this.otaPackageDataCache = otaPackageDataCache;
        this.handler = handler;
        this.registrationStore = registrationStore;
        this.securityStore = securityStore;
        this.certificateVerifier = certificateVerifier;
        this.authorizer = authorizer;
        this.modelProvider = modelProvider;
    }
}

