/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.secure;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MSecurityMode;
import org.thingsboard.server.common.data.device.credentials.lwm2m.X509ClientCredential;
import org.thingsboard.server.common.msg.EncryptionUtil;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.common.transport.util.SslUtil;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.secure.TbX509DtlsSessionInfo;
import org.thingsboard.server.transport.lwm2m.secure.credentials.LwM2MClientCredentials;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbMainSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

@Component
@TbLwM2mTransportComponent
public class TbLwM2MDtlsCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MDtlsCertificateVerifier.class);
    private final TbLwM2MDtlsSessionStore sessionStorage;
    private final LwM2MTransportServerConfig config;
    private final LwM2mCredentialsSecurityInfoValidator securityInfoValidator;
    private final TbMainSecurityStore securityStore;
    private StaticNewAdvancedCertificateVerifier staticCertificateVerifier;
    @Value(value="${transport.lwm2m.server.security.skip_validity_check_for_client_cert:false}")
    private boolean skipValidityCheckForClientCert;

    public List<CertificateType> getSupportedCertificateTypes() {
        return Arrays.asList(CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY);
    }

    @PostConstruct
    public void init() {
        try {
            if (this.config.getTrustSslCredentials() != null) {
                X509Certificate[] trustedCertificates = this.config.getTrustSslCredentials().getTrustedCertificates();
                this.staticCertificateVerifier = new StaticNewAdvancedCertificateVerifier(trustedCertificates, new RawPublicKeyIdentity[0], null);
            }
        }
        catch (Exception e) {
            log.warn("Failed to initialize the LwM2M certificate verifier", (Throwable)e);
        }
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
        CertPath certChain = message.getCertificateChain();
        if (certChain == null) {
            PublicKey publicKey = message.getPublicKey();
            return new CertificateVerificationResult(cid, publicKey, null);
        }
        try {
            X509Certificate[] chain;
            boolean x509CredentialsFound = false;
            for (X509Certificate cert : chain = certChain.getCertificates().toArray(new X509Certificate[0])) {
                try {
                    LwM2MClientCredentials credentials;
                    ValidateDeviceCredentialsResponse msg;
                    if (!this.skipValidityCheckForClientCert) {
                        cert.checkValidity();
                    }
                    TbLwM2MSecurityInfo securityInfo = null;
                    if (this.staticCertificateVerifier != null) {
                        HandshakeException exception = this.staticCertificateVerifier.verifyCertificate(cid, serverName, remotePeer, clientUsage, verifySubject, truncateCertificatePath, message).getException();
                        if (exception == null) {
                            try {
                                String endpoint = this.config.getTrustSslCredentials().getValueFromSubjectNameByKey(cert.getSubjectX500Principal().getName(), "CN");
                                if (StringUtils.isNotEmpty((String)endpoint)) {
                                    securityInfo = this.securityInfoValidator.getEndpointSecurityInfoByCredentialsId(endpoint, LwM2mTypeServer.CLIENT);
                                }
                            }
                            catch (LwM2MAuthException e) {
                                log.trace("Certificate trust validation failed.", (Throwable)e);
                            }
                        } else {
                            log.trace("Certificate trust validation failed.", (Throwable)exception);
                        }
                    }
                    String strCert = SslUtil.getCertificateString((Certificate)cert);
                    String sha3Hash = EncryptionUtil.getSha3Hash((String)strCert);
                    if (securityInfo == null || securityInfo.getMsg() == null) {
                        try {
                            securityInfo = this.securityInfoValidator.getEndpointSecurityInfoByCredentialsId(sha3Hash, LwM2mTypeServer.CLIENT);
                        }
                        catch (LwM2MAuthException e) {
                            log.trace("Failed find security info: {}", (Object)sha3Hash, (Object)e);
                        }
                    }
                    ValidateDeviceCredentialsResponse validateDeviceCredentialsResponse = msg = securityInfo != null ? securityInfo.getMsg() : null;
                    if (msg == null || !StringUtils.isNotEmpty((String)msg.getCredentials()) || !(credentials = (LwM2MClientCredentials)JacksonUtil.fromString((String)msg.getCredentials(), LwM2MClientCredentials.class)).getClient().getSecurityConfigClientMode().equals((Object)LwM2MSecurityMode.X509)) continue;
                    X509ClientCredential config = (X509ClientCredential)credentials.getClient();
                    String certBody = config.getCert();
                    String endpoint = config.getEndpoint();
                    if (StringUtils.isBlank((String)certBody) || strCert.equals(certBody)) {
                        x509CredentialsFound = true;
                        DeviceProfile deviceProfile = msg.getDeviceProfile();
                        if (!msg.hasDeviceInfo() || deviceProfile == null) continue;
                        this.sessionStorage.put(endpoint, new TbX509DtlsSessionInfo(cert.getSubjectX500Principal().getName(), msg));
                        try {
                            this.securityStore.putX509(securityInfo);
                        }
                        catch (NonUniqueSecurityInfoException e) {
                            log.trace("Failed to add security info: {}", (Object)securityInfo, (Object)e);
                        }
                        break;
                    }
                    log.trace("[{}][{}] Certificate mismatch. Expected: {}, Actual: {}", new Object[]{endpoint, sha3Hash, strCert, certBody});
                }
                catch (CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (!x509CredentialsFound) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                throw new HandshakeException("x509 verification not enabled!", alert);
            }
            return new CertificateVerificationResult(cid, certChain, null);
        }
        catch (HandshakeException e) {
            log.trace("Certificate validation failed!", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    public List<X500Principal> getAcceptedIssuers() {
        return CertPathUtil.toSubjects(null);
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    @ConstructorProperties(value={"sessionStorage", "config", "securityInfoValidator", "securityStore"})
    public TbLwM2MDtlsCertificateVerifier(TbLwM2MDtlsSessionStore sessionStorage, LwM2MTransportServerConfig config, LwM2mCredentialsSecurityInfoValidator securityInfoValidator, TbMainSecurityStore securityStore) {
        this.sessionStorage = sessionStorage;
        this.config = config;
        this.securityInfoValidator = securityInfoValidator;
        this.securityStore = securityStore;
    }
}

