/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.secure;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.DecoderException;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.util.SecurityUtil;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.PSKClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.RPKClientCredential;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.secure.credentials.LwM2MClientCredentials;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

@Component
@TbLwM2mTransportComponent
public class LwM2mCredentialsSecurityInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(LwM2mCredentialsSecurityInfoValidator.class);
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;

    public TbLwM2MSecurityInfo getEndpointSecurityInfoByCredentialsId(final String credentialsId, final LwM2mTypeServer keyValue) {
        final CountDownLatch latch = new CountDownLatch(1);
        final TbLwM2MSecurityInfo[] resultSecurityStore = new TbLwM2MSecurityInfo[1];
        log.trace("Validating credentials [{}]", (Object)credentialsId);
        this.context.getTransportService().process(TransportProtos.ValidateDeviceLwM2MCredentialsRequestMsg.newBuilder().setCredentialsId(credentialsId).build(), (TransportServiceCallback)new TransportServiceCallback<ValidateDeviceCredentialsResponse>(){

            public void onSuccess(ValidateDeviceCredentialsResponse msg) {
                log.trace("Validated credentials: [{}] [{}]", (Object)credentialsId, (Object)msg);
                resultSecurityStore[0] = LwM2mCredentialsSecurityInfoValidator.this.createSecurityInfo(credentialsId, msg, keyValue);
                latch.countDown();
            }

            public void onError(Throwable e) {
                log.trace("[{}] [{}] Failed to process credentials ", (Object)credentialsId, (Object)e);
                TbLwM2MSecurityInfo result = new TbLwM2MSecurityInfo();
                result.setEndpoint(credentialsId);
                resultSecurityStore[0] = result;
                latch.countDown();
            }
        });
        try {
            latch.await(this.config.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("Failed to await credentials!", (Throwable)e);
        }
        TbLwM2MSecurityInfo securityInfo = resultSecurityStore[0];
        if (securityInfo.getSecurityMode() == null) {
            throw new LwM2MAuthException();
        }
        return securityInfo;
    }

    private TbLwM2MSecurityInfo createSecurityInfo(String endpoint, ValidateDeviceCredentialsResponse msg, LwM2mTypeServer keyValue) {
        TbLwM2MSecurityInfo result = new TbLwM2MSecurityInfo();
        LwM2MClientCredentials credentials = (LwM2MClientCredentials)JacksonUtil.fromString((String)msg.getCredentials(), LwM2MClientCredentials.class);
        if (credentials != null) {
            result.setMsg(msg);
            result.setDeviceProfile(msg.getDeviceProfile());
            result.setEndpoint(credentials.getClient().getEndpoint());
            switch (credentials.getClient().getSecurityConfigClientMode()) {
                case NO_SEC: {
                    this.createClientSecurityInfoNoSec(result);
                    break;
                }
                case PSK: {
                    this.createClientSecurityInfoPSK(result, endpoint, credentials.getClient());
                    break;
                }
                case RPK: {
                    this.createClientSecurityInfoRPK(result, endpoint, credentials.getClient());
                    break;
                }
                case X509: {
                    this.createClientSecurityInfoX509(result, endpoint);
                    break;
                }
            }
            if (keyValue.equals((Object)LwM2mTypeServer.BOOTSTRAP)) {
                LwM2MBootstrapConfig bootstrapCredentialConfig = new LwM2MBootstrapConfig(((Lwm2mDeviceProfileTransportConfiguration)msg.getDeviceProfile().getProfileData().getTransportConfiguration()).getBootstrap(), credentials.getBootstrap().getBootstrapServer(), credentials.getBootstrap().getLwm2mServer());
                result.setBootstrapCredentialConfig(bootstrapCredentialConfig);
            }
        }
        return result;
    }

    private void createClientSecurityInfoNoSec(TbLwM2MSecurityInfo result) {
        result.setSecurityInfo(null);
        result.setSecurityMode(SecurityMode.NO_SEC);
    }

    private void createClientSecurityInfoPSK(TbLwM2MSecurityInfo result, String endpoint, LwM2MClientCredential clientCredentialsConfig) {
        block5: {
            PSKClientCredential pskConfig = (PSKClientCredential)clientCredentialsConfig;
            if (StringUtils.isNotEmpty((String)pskConfig.getIdentity())) {
                try {
                    if (pskConfig.getDecoded() == null || pskConfig.getDecoded().length <= 0) break block5;
                    String string = endpoint = StringUtils.isNotEmpty((String)pskConfig.getEndpoint()) ? pskConfig.getEndpoint() : endpoint;
                    if (endpoint != null && !endpoint.isEmpty()) {
                        result.setSecurityInfo(SecurityInfo.newPreSharedKeyInfo((String)endpoint, (String)pskConfig.getIdentity(), (byte[])pskConfig.getDecoded()));
                        result.setSecurityMode(SecurityMode.PSK);
                    }
                }
                catch (IllegalArgumentException | DecoderException e) {
                    log.error("Missing PSK key: " + e.getMessage());
                }
            } else {
                log.error("Missing PSK identity");
            }
        }
    }

    private void createClientSecurityInfoRPK(TbLwM2MSecurityInfo result, String endpoint, LwM2MClientCredential clientCredentialsConfig) {
        RPKClientCredential rpkConfig = (RPKClientCredential)clientCredentialsConfig;
        try {
            if (rpkConfig.getDecoded() != null) {
                PublicKey key = (PublicKey)SecurityUtil.publicKey.decode(rpkConfig.getDecoded());
                result.setSecurityInfo(SecurityInfo.newRawPublicKeyInfo((String)endpoint, (PublicKey)key));
                result.setSecurityMode(SecurityMode.RPK);
            } else {
                log.error("Missing RPK key");
            }
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException | DecoderException e) {
            log.error("RPK: Invalid security info content: " + e.getMessage());
        }
    }

    private void createClientSecurityInfoX509(TbLwM2MSecurityInfo result, String endpoint) {
        result.setSecurityInfo(SecurityInfo.newX509CertInfo((String)endpoint));
        result.setSecurityMode(SecurityMode.X509);
    }

    @ConstructorProperties(value={"context", "config"})
    public LwM2mCredentialsSecurityInfoValidator(LwM2mTransportContext context, LwM2MTransportServerConfig config) {
        this.context = context;
        this.config = config;
    }
}

