/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.request.ContentFormat;

public enum TbLwM2mVersion {
    VERSION_1_0(0, LwM2m.LwM2mVersion.V1_0, ContentFormat.TLV, false),
    VERSION_1_1(1, LwM2m.LwM2mVersion.V1_1, ContentFormat.TEXT, true);

    private final int code;
    private final LwM2m.LwM2mVersion version;
    private final ContentFormat contentFormat;
    private final boolean composite;

    private TbLwM2mVersion(int code, LwM2m.LwM2mVersion version, ContentFormat contentFormat, boolean composite) {
        this.code = code;
        this.version = version;
        this.contentFormat = contentFormat;
        this.composite = composite;
    }

    public static TbLwM2mVersion fromVersion(LwM2m.LwM2mVersion version) {
        for (TbLwM2mVersion to : TbLwM2mVersion.values()) {
            if (!to.version.equals((Object)version)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported typeLwM2mVersion type : %s", version));
    }

    public static TbLwM2mVersion fromVersionStr(String versionStr) {
        for (TbLwM2mVersion to : TbLwM2mVersion.values()) {
            if (!to.version.toString().equals(versionStr)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported contentFormatLwM2mVersion version : %s", versionStr));
    }

    public static TbLwM2mVersion fromCode(int code) {
        for (TbLwM2mVersion to : TbLwM2mVersion.values()) {
            if (to.code != code) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported codeLwM2mVersion code : %d", code));
    }

    public int getCode() {
        return this.code;
    }

    public LwM2m.LwM2mVersion getVersion() {
        return this.version;
    }

    public ContentFormat getContentFormat() {
        return this.contentFormat;
    }

    public boolean isComposite() {
        return this.composite;
    }
}

