/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.TbProperty;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MSecureServerConfig;

@Component
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' || '${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core')  && '${transport.lwm2m.enabled:false}'=='true'")
@ConfigurationProperties(prefix="transport.lwm2m")
public class LwM2MTransportServerConfig
implements LwM2MSecureServerConfig {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportServerConfig.class);
    @Value(value="${transport.lwm2m.dtls.retransmission_timeout:9000}")
    private int dtlsRetransmissionTimeout;
    @Value(value="${transport.lwm2m.timeout:}")
    private Long timeout;
    @Value(value="${transport.sessions.report_timeout}")
    private long sessionReportTimeout;
    @Value(value="${transport.lwm2m.security.recommended_ciphers:}")
    private boolean recommendedCiphers;
    @Value(value="${transport.lwm2m.security.recommended_supported_groups:}")
    private boolean recommendedSupportedGroups;
    @Value(value="${transport.lwm2m.downlink_pool_size:}")
    private int downlinkPoolSize;
    @Value(value="${transport.lwm2m.uplink_pool_size:}")
    private int uplinkPoolSize;
    @Value(value="${transport.lwm2m.ota_pool_size:}")
    private int otaPoolSize;
    @Value(value="${transport.lwm2m.clean_period_in_sec:}")
    private int cleanPeriodInSec;
    @Value(value="${transport.lwm2m.server.id:}")
    private Integer id;
    @Value(value="${transport.lwm2m.server.bind_address:}")
    private String host;
    @Value(value="${transport.lwm2m.server.bind_port:}")
    private Integer port;
    @Value(value="${transport.lwm2m.server.security.bind_address:}")
    private String secureHost;
    @Value(value="${transport.lwm2m.server.security.bind_port:}")
    private Integer securePort;
    @Value(value="${transport.lwm2m.psm_activity_timer:10000}")
    private long psmActivityTimer;
    @Value(value="${transport.lwm2m.paging_transmission_window:10000}")
    private long pagingTransmissionWindow;
    private List<TbProperty> networkConfig;
    @Autowired
    @Qualifier(value="lwm2mServerCredentials")
    private SslCredentialsConfig credentialsConfig;
    @Autowired
    @Qualifier(value="lwm2mTrustCredentials")
    private SslCredentialsConfig trustCredentialsConfig;

    @Bean
    @ConfigurationProperties(prefix="transport.lwm2m.server.security.credentials")
    public SslCredentialsConfig lwm2mServerCredentials() {
        return new SslCredentialsConfig("LWM2M Server DTLS Credentials", false);
    }

    @Bean
    @ConfigurationProperties(prefix="transport.lwm2m.security.trust-credentials")
    public SslCredentialsConfig lwm2mTrustCredentials() {
        return new SslCredentialsConfig("LWM2M Trust Credentials", true);
    }

    @Override
    public SslCredentials getSslCredentials() {
        return this.credentialsConfig.getCredentials();
    }

    public SslCredentials getTrustSslCredentials() {
        return this.trustCredentialsConfig.getCredentials();
    }

    public int getDtlsRetransmissionTimeout() {
        return this.dtlsRetransmissionTimeout;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public long getSessionReportTimeout() {
        return this.sessionReportTimeout;
    }

    public boolean isRecommendedCiphers() {
        return this.recommendedCiphers;
    }

    public boolean isRecommendedSupportedGroups() {
        return this.recommendedSupportedGroups;
    }

    public int getDownlinkPoolSize() {
        return this.downlinkPoolSize;
    }

    public int getUplinkPoolSize() {
        return this.uplinkPoolSize;
    }

    public int getOtaPoolSize() {
        return this.otaPoolSize;
    }

    public int getCleanPeriodInSec() {
        return this.cleanPeriodInSec;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getSecureHost() {
        return this.secureHost;
    }

    @Override
    public Integer getSecurePort() {
        return this.securePort;
    }

    public long getPsmActivityTimer() {
        return this.psmActivityTimer;
    }

    public long getPagingTransmissionWindow() {
        return this.pagingTransmissionWindow;
    }

    public List<TbProperty> getNetworkConfig() {
        return this.networkConfig;
    }

    public void setNetworkConfig(List<TbProperty> networkConfig) {
        this.networkConfig = networkConfig;
    }
}

