/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MSecureServerConfig;

@Component
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' || '${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core')  && '${transport.lwm2m.enabled:false}'=='true' && '${transport.lwm2m.bootstrap.enabled:false}'=='true'")
public class LwM2MTransportBootstrapConfig
implements LwM2MSecureServerConfig {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportBootstrapConfig.class);
    @Value(value="${transport.lwm2m.bootstrap.id:}")
    private Integer id;
    @Value(value="${transport.lwm2m.bootstrap.bind_address:}")
    private String host;
    @Value(value="${transport.lwm2m.bootstrap.bind_port:}")
    private Integer port;
    @Value(value="${transport.lwm2m.bootstrap.security.bind_address:}")
    private String secureHost;
    @Value(value="${transport.lwm2m.bootstrap.security.bind_port:}")
    private Integer securePort;
    @Autowired
    @Qualifier(value="lwm2mBootstrapCredentials")
    private SslCredentialsConfig credentialsConfig;

    @Bean
    @ConfigurationProperties(prefix="transport.lwm2m.bootstrap.security.credentials")
    public SslCredentialsConfig lwm2mBootstrapCredentials() {
        return new SslCredentialsConfig("LWM2M Bootstrap DTLS Credentials", false);
    }

    @Override
    public SslCredentials getSslCredentials() {
        return this.credentialsConfig.getCredentials();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getSecureHost() {
        return this.secureHost;
    }

    @Override
    public Integer getSecurePort() {
        return this.securePort;
    }
}

