/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.store;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.ConfigurationChecker;
import org.eclipse.leshan.server.bootstrap.InMemoryBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.util.TbLwM2mBootstrapTransportComponent;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MConfigurationChecker;

@Component(value="LwM2MInMemoryBootstrapConfigStore")
@TbLwM2mBootstrapTransportComponent
public class LwM2MInMemoryBootstrapConfigStore
extends InMemoryBootstrapConfigStore {
    private static final Logger log = LoggerFactory.getLogger(LwM2MInMemoryBootstrapConfigStore.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    protected final ConfigurationChecker configChecker = new LwM2MConfigurationChecker();

    public BootstrapConfig get(String endpoint, Identity deviceIdentity, BootstrapSession session) {
        return (BootstrapConfig)this.bootstrapByEndpoint.get(endpoint);
    }

    public Map<String, BootstrapConfig> getAll() {
        this.readLock.lock();
        try {
            Map map = super.getAll();
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void add(String endpoint, BootstrapConfig config) throws InvalidConfigurationException {
        this.writeLock.lock();
        try {
            this.addToStore(endpoint, config);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public BootstrapConfig remove(String endpoint) {
        this.writeLock.lock();
        try {
            BootstrapConfig bootstrapConfig = super.remove(endpoint);
            return bootstrapConfig;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToStore(String endpoint, BootstrapConfig config) throws InvalidConfigurationException {
        BootstrapConfig previousConfig;
        BootstrapConfig existingConfig;
        this.configChecker.verify(config);
        InMemoryBootstrapConfigStore.PskByServer pskToAdd = this.getBootstrapPskIdentity(config);
        if (pskToAdd != null && (existingConfig = (BootstrapConfig)this.bootstrapByPskId.get(pskToAdd)) != null && (previousConfig = (BootstrapConfig)this.bootstrapByEndpoint.get(endpoint)) != existingConfig) {
            throw new InvalidConfigurationException("Psk identity [%s] already used for this bootstrap server [%s]", new Object[]{pskToAdd.identity, pskToAdd.serverUrl});
        }
        this.bootstrapByEndpoint.put(endpoint, config);
        if (pskToAdd != null) {
            this.bootstrapByPskId.put(pskToAdd, config);
        }
    }
}

