/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.store;

import java.util.Map;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.ConfigurationChecker;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;

public class LwM2MConfigurationChecker
extends ConfigurationChecker {
    public void verify(BootstrapConfig config) throws InvalidConfigurationException {
        for (Map.Entry e : config.security.entrySet()) {
            BootstrapConfig.ServerSecurity sec = (BootstrapConfig.ServerSecurity)e.getValue();
            switch (sec.securityMode) {
                case NO_SEC: {
                    this.checkNoSec(sec);
                    break;
                }
                case PSK: {
                    this.checkPSK(sec);
                    break;
                }
                case RPK: {
                    this.checkRPK(sec);
                    break;
                }
                case X509: {
                    this.checkX509(sec);
                    break;
                }
                case EST: {
                    throw new InvalidConfigurationException("EST is not currently supported.", new Object[]{e});
                }
            }
            this.validateMandatoryField(sec);
        }
        this.validateOneSecurityByServer(config);
    }

    protected void validateOneSecurityByServer(BootstrapConfig config) throws InvalidConfigurationException {
        for (Map.Entry e : config.servers.entrySet()) {
            BootstrapConfig.ServerConfig srvCfg = (BootstrapConfig.ServerConfig)e.getValue();
            if (srvCfg.shortId == 0) {
                throw new InvalidConfigurationException("short ID must not be 0");
            }
            BootstrapConfig.ServerSecurity security = LwM2MConfigurationChecker.getSecurityEntry(config, srvCfg.shortId);
            if (security != null) continue;
            throw new InvalidConfigurationException("no security entry for server instance: " + e.getKey());
        }
    }

    protected static BootstrapConfig.ServerSecurity getSecurityEntry(BootstrapConfig config, int shortId) {
        for (Map.Entry es : config.security.entrySet()) {
            if (((BootstrapConfig.ServerSecurity)es.getValue()).serverId != shortId) continue;
            return (BootstrapConfig.ServerSecurity)es.getValue();
        }
        return null;
    }
}

