/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.store;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.EditableBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MSecurityMode;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.AbstractLwM2MBootstrapServerCredential;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mBootstrapTransportComponent;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.LwM2mSessionMsgListener;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

@Service(value="LwM2MBootstrapSecurityStore")
@TbLwM2mBootstrapTransportComponent
public class LwM2MBootstrapSecurityStore
implements BootstrapSecurityStore {
    private static final Logger log = LoggerFactory.getLogger(LwM2MBootstrapSecurityStore.class);
    private final EditableBootstrapConfigStore bootstrapConfigStore;
    private final LwM2mCredentialsSecurityInfoValidator lwM2MCredentialsSecurityInfoValidator;
    private final LwM2mTransportContext context;
    private final LwM2mTransportServerHelper helper;
    private final Map<String, TransportProtos.SessionInfoProto> bsSessions = new ConcurrentHashMap<String, TransportProtos.SessionInfoProto>();

    public LwM2MBootstrapSecurityStore(EditableBootstrapConfigStore bootstrapConfigStore, LwM2mCredentialsSecurityInfoValidator lwM2MCredentialsSecurityInfoValidator, LwM2mTransportContext context, LwM2mTransportServerHelper helper) {
        this.bootstrapConfigStore = bootstrapConfigStore;
        this.lwM2MCredentialsSecurityInfoValidator = lwM2MCredentialsSecurityInfoValidator;
        this.context = context;
        this.helper = helper;
    }

    public Iterator<SecurityInfo> getAllByEndpoint(String endpoint) {
        TbLwM2MSecurityInfo store = this.lwM2MCredentialsSecurityInfoValidator.getEndpointSecurityInfoByCredentialsId(endpoint, LwM2mTypeServer.BOOTSTRAP);
        SecurityInfo securityInfo = this.addValueToStore(store, endpoint);
        return securityInfo == null ? null : Collections.singletonList(store.getSecurityInfo()).iterator();
    }

    public SecurityInfo getByIdentity(String identity) {
        try {
            TbLwM2MSecurityInfo store = this.lwM2MCredentialsSecurityInfoValidator.getEndpointSecurityInfoByCredentialsId(identity, LwM2mTypeServer.BOOTSTRAP);
            if (store.getBootstrapCredentialConfig() != null && store.getSecurityMode() != null) {
                this.setBootstrapConfigSecurityInfo(store);
                BootstrapConfig bsConfig = store.getBootstrapConfig();
                if (bsConfig.security != null) {
                    try {
                        this.bootstrapConfigStore.add(store.getEndpoint(), bsConfig);
                    }
                    catch (InvalidConfigurationException e) {
                        log.trace("Invalid Bootstrap Configuration", (Throwable)e);
                        return null;
                    }
                }
            }
            return store.getSecurityInfo();
        }
        catch (LwM2MAuthException e) {
            log.trace("Bootstrap Registration failed: No pre-shared key found for [identity: {}]", (Object)identity);
            return null;
        }
    }

    public TbLwM2MSecurityInfo getX509ByEndpoint(String endPoint) {
        TbLwM2MSecurityInfo store = this.lwM2MCredentialsSecurityInfoValidator.getEndpointSecurityInfoByCredentialsId(endPoint, LwM2mTypeServer.BOOTSTRAP);
        this.addValueToStore(store, store.getEndpoint());
        return store;
    }

    private void setBootstrapConfigSecurityInfo(TbLwM2MSecurityInfo store) {
        LwM2MBootstrapConfig lwM2MBootstrapConfig = this.getParametersBootstrap(store);
        if (lwM2MBootstrapConfig != null) {
            BootstrapConfig bootstrapConfig = lwM2MBootstrapConfig.getLwM2MBootstrapConfig();
            store.setBootstrapConfig(bootstrapConfig);
        }
    }

    private LwM2MBootstrapConfig getParametersBootstrap(TbLwM2MSecurityInfo store) {
        LwM2MBootstrapConfig lwM2MBootstrapConfig = store.getBootstrapCredentialConfig();
        if (lwM2MBootstrapConfig != null) {
            UUID sessionUUiD = UUID.randomUUID();
            TransportProtos.SessionInfoProto sessionInfo = this.helper.getValidateSessionInfo(store.getMsg(), sessionUUiD.getMostSignificantBits(), sessionUUiD.getLeastSignificantBits());
            this.bsSessions.put(store.getEndpoint(), sessionInfo);
            this.context.getTransportService().registerAsyncSession(sessionInfo, (SessionMsgListener)new LwM2mSessionMsgListener(null, null, null, sessionInfo, this.context.getTransportService()));
            if (this.getValidatedSecurityMode(lwM2MBootstrapConfig)) {
                return lwM2MBootstrapConfig;
            }
            log.error(" [{}] Different values SecurityMode between of client and profile.", (Object)store.getEndpoint());
            log.error("{} getParametersBootstrap: [{}] Different values SecurityMode between of client and profile.", (Object)"error", (Object)store.getEndpoint());
            String logMsg = String.format("%s: Different values SecurityMode between of client and profile.", "error");
            this.helper.sendParametersOnThingsboardTelemetry(this.helper.getKvStringtoThingsboard("transportLog", logMsg), sessionInfo);
            return null;
        }
        log.error("Unable to decode Json or Certificate for [{}]", (Object)store.getEndpoint());
        return null;
    }

    private boolean getValidatedSecurityMode(LwM2MBootstrapConfig lwM2MBootstrapConfig) {
        LwM2MSecurityMode bootstrapServerSecurityMode = lwM2MBootstrapConfig.getBootstrapServer().getSecurityMode();
        LwM2MSecurityMode lwm2mServerSecurityMode = lwM2MBootstrapConfig.getLwm2mServer().getSecurityMode();
        AtomicBoolean validBs = new AtomicBoolean(true);
        AtomicBoolean validLw = new AtomicBoolean(true);
        lwM2MBootstrapConfig.getServerConfiguration().forEach(serverCredential -> {
            if (((AbstractLwM2MBootstrapServerCredential)serverCredential).isBootstrapServerIs()) {
                if (!bootstrapServerSecurityMode.equals((Object)serverCredential.getSecurityMode())) {
                    validBs.set(false);
                }
            } else if (!lwm2mServerSecurityMode.equals((Object)serverCredential.getSecurityMode())) {
                validLw.set(false);
            }
        });
        return validBs.get() && validLw.get();
    }

    public TransportProtos.SessionInfoProto getSessionByEndpoint(String endpoint) {
        return this.bsSessions.get(endpoint);
    }

    public TransportProtos.SessionInfoProto removeSessionByEndpoint(String endpoint) {
        return this.bsSessions.remove(endpoint);
    }

    public BootstrapConfig getBootstrapConfigByEndpoint(String endpoint) {
        return (BootstrapConfig)this.bootstrapConfigStore.getAll().get(endpoint);
    }

    public SecurityInfo addValueToStore(TbLwM2MSecurityInfo store, String endpoint) {
        SecurityInfo securityInfo = null;
        if (store != null && store.getBootstrapCredentialConfig() != null && store.getSecurityMode() != null) {
            securityInfo = store.getSecurityInfo();
            this.setBootstrapConfigSecurityInfo(store);
            BootstrapConfig bsConfigNew = store.getBootstrapConfig();
            if (bsConfigNew != null) {
                try {
                    Optional<Map.Entry> securities;
                    boolean bootstrapServerUpdateEnable = ((Lwm2mDeviceProfileTransportConfiguration)store.getDeviceProfile().getProfileData().getTransportConfiguration()).isBootstrapServerUpdateEnable();
                    if (!bootstrapServerUpdateEnable && (securities = bsConfigNew.security.entrySet().stream().filter(sec -> ((BootstrapConfig.ServerSecurity)sec.getValue()).bootstrapServer).findAny()).isPresent()) {
                        bsConfigNew.security.entrySet().remove(securities.get());
                        int serverSortId = ((BootstrapConfig.ServerSecurity)securities.get().getValue()).serverId;
                        Optional<Map.Entry> serverConfigs = bsConfigNew.servers.entrySet().stream().filter(serv -> ((BootstrapConfig.ServerConfig)serv.getValue()).shortId == serverSortId).findAny();
                        if (serverConfigs.isPresent()) {
                            bsConfigNew.servers.entrySet().remove(serverConfigs.get());
                        }
                    }
                    for (String config : this.bootstrapConfigStore.getAll().keySet()) {
                        if (!config.equals(endpoint)) continue;
                        this.bootstrapConfigStore.remove(config);
                    }
                    this.bootstrapConfigStore.add(endpoint, bsConfigNew);
                }
                catch (InvalidConfigurationException e) {
                    if (e.getMessage().contains("Psk identity") && e.getMessage().contains("already used for this bootstrap server")) {
                        log.trace("Invalid Bootstrap Configuration", (Throwable)e);
                    }
                    log.error("Invalid Bootstrap Configuration", (Throwable)e);
                }
            }
        }
        return securityInfo;
    }
}

