/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.store;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.LinkParamValue;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapDownlinkRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.BootstrapTaskProvider;
import org.eclipse.leshan.server.bootstrap.BootstrapUtil;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapClientInstanceIds;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapTaskProvider;

public class LwM2MBootstrapConfigStoreTaskProvider
implements LwM2MBootstrapTaskProvider {
    private static final Logger log = LoggerFactory.getLogger(LwM2MBootstrapConfigStoreTaskProvider.class);
    protected final ReadWriteLock readWriteLock;
    protected final Lock writeLock;
    private BootstrapConfigStore store;
    private Map<Integer, String> supportedObjects;
    protected Map<String, LwM2MBootstrapClientInstanceIds> lwM2MBootstrapSessionClients;

    public LwM2MBootstrapConfigStoreTaskProvider(BootstrapConfigStore store) {
        this.store = store;
        this.lwM2MBootstrapSessionClients = new ConcurrentHashMap<String, LwM2MBootstrapClientInstanceIds>();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.writeLock = this.readWriteLock.writeLock();
    }

    public BootstrapTaskProvider.Tasks getTasks(BootstrapSession session, List<LwM2mResponse> previousResponse) {
        BootstrapConfig config = this.store.get(session.getEndpoint(), session.getIdentity(), session);
        if (config == null) {
            return null;
        }
        if (previousResponse == null && this.shouldStartWithDiscover(config)) {
            BootstrapTaskProvider.Tasks tasks = new BootstrapTaskProvider.Tasks();
            tasks.requestsToSend = new ArrayList(1);
            tasks.requestsToSend.add(new BootstrapDiscoverRequest());
            tasks.last = false;
            return tasks;
        }
        BootstrapTaskProvider.Tasks tasks = new BootstrapTaskProvider.Tasks();
        if (this.supportedObjects == null) {
            this.initSupportedObjectsDefault();
        }
        tasks.supportedObjects = this.supportedObjects;
        if (previousResponse != null) {
            if (previousResponse.get(0) instanceof BootstrapDiscoverResponse) {
                BootstrapDiscoverResponse discoverResponse = (BootstrapDiscoverResponse)previousResponse.get(0);
                if (discoverResponse.isSuccess()) {
                    this.initAfterBootstrapDiscover(discoverResponse);
                    this.findSecurityInstanceId(discoverResponse.getObjectLinks(), session.getEndpoint());
                } else {
                    log.warn("Bootstrap Discover return error {} : to continue bootstrap session without autoIdForSecurityObject mode. {}", (Object)discoverResponse, (Object)session);
                }
                if (this.lwM2MBootstrapSessionClients.get(session.getEndpoint()).getSecurityInstances().get(0) == null) {
                    log.error("Unable to find bootstrap server instance in Security Object (0) in response {}: unable to continue bootstrap session with autoIdForSecurityObject mode. {}", (Object)discoverResponse, (Object)session);
                    return null;
                }
                tasks.requestsToSend = new ArrayList(1);
                tasks.requestsToSend.add(new BootstrapReadRequest("/1"));
                tasks.last = false;
                return tasks;
            }
            BootstrapReadResponse readResponse = (BootstrapReadResponse)previousResponse.get(0);
            Integer bootstrapServerIdOld = null;
            if (readResponse.isSuccess()) {
                this.findServerInstanceId(readResponse, session.getEndpoint());
                if (this.lwM2MBootstrapSessionClients.get(session.getEndpoint()).getSecurityInstances().size() > 0 && this.lwM2MBootstrapSessionClients.get(session.getEndpoint()).getServerInstances().size() > 0) {
                    bootstrapServerIdOld = this.findBootstrapServerId(session.getEndpoint());
                }
            } else {
                log.warn("Bootstrap ReadResponse return error {} : to continue bootstrap session without find Server Instance Id. {}", (Object)readResponse, (Object)session);
            }
            tasks.requestsToSend = this.toRequests(config, config.contentFormat != null ? config.contentFormat : session.getContentFormat(), bootstrapServerIdOld, session.getEndpoint());
        } else {
            tasks.requestsToSend = BootstrapUtil.toRequests((BootstrapConfig)config, (ContentFormat)(config.contentFormat != null ? config.contentFormat : session.getContentFormat()));
        }
        return tasks;
    }

    protected boolean shouldStartWithDiscover(BootstrapConfig config) {
        return config.autoIdForSecurityObject;
    }

    protected void findSecurityInstanceId(Link[] objectLinks, String endpoint) {
        log.info("Object after discover: [{}]", (Object[])objectLinks);
        for (Link link : objectLinks) {
            if (!link.getUriReference().startsWith("/0/")) continue;
            try {
                LwM2mPath path = new LwM2mPath(link.getUriReference());
                if (!path.isObjectInstance()) continue;
                if (link.getLinkParams().containsKey("ssid")) {
                    int serverId = Integer.parseInt(((LinkParamValue)link.getLinkParams().get("ssid")).getUnquoted());
                    if (!this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().containsKey(serverId)) {
                        this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().put(serverId, path.getObjectInstanceId());
                    } else {
                        log.error("Invalid lwm2mSecurityInstance by [{}]", (Object)path.getObjectInstanceId());
                    }
                    this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().put(Integer.valueOf(((LinkParamValue)link.getLinkParams().get("ssid")).getUnquoted()), path.getObjectInstanceId());
                    continue;
                }
                if (!this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().containsKey(0)) {
                    this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().put(0, path.getObjectInstanceId());
                    continue;
                }
                log.error("Invalid bootstrapSecurityInstance by [{}]", (Object)path.getObjectInstanceId());
            }
            catch (Exception e) {
                log.error("Invalid LwM2MPath starting by \"/0/\"");
            }
        }
    }

    protected void findServerInstanceId(BootstrapReadResponse readResponse, String endpoint) {
        try {
            ((LwM2mObject)readResponse.getContent()).getInstances().values().forEach(instance -> {
                Object shId = ResourceModel.Type.OPAQUE.equals((Object)instance.getResource(0).getType()) ? Integer.valueOf(new BigInteger((byte[])instance.getResource(0).getValue()).intValue()) : instance.getResource(0).getValue();
                int shortId = shId instanceof Long ? ((Long)shId).intValue() : ((Integer)shId).intValue();
                this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().put(shortId, instance.getId());
            });
        }
        catch (Exception e) {
            log.error("Failed find Server Instance Id. ", (Throwable)e);
        }
    }

    protected Integer findBootstrapServerId(String endpoint) {
        Integer bootstrapServerIdOld = null;
        Map<Integer, Integer> filteredMap = this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().entrySet().stream().filter(x -> !this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().containsKey(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filteredMap.size() > 0) {
            bootstrapServerIdOld = (Integer)filteredMap.keySet().stream().findFirst().get();
        }
        return bootstrapServerIdOld;
    }

    public BootstrapConfigStore getStore() {
        return this.store;
    }

    private void initAfterBootstrapDiscover(BootstrapDiscoverResponse response) {
        Link[] links = response.getObjectLinks();
        Arrays.stream(links).forEach(link -> {
            LwM2mPath path = new LwM2mPath(link.getUriReference());
            if (!path.isRoot() && path.getObjectId() < 3 && path.isObject()) {
                String ver = link.getLinkParams().get("ver") != null ? ((LinkParamValue)link.getLinkParams().get("ver")).getUnquoted() : "1.0";
                this.supportedObjects.put(path.getObjectId(), ver);
            }
        });
    }

    public List<BootstrapDownlinkRequest<? extends LwM2mResponse>> toRequests(BootstrapConfig bootstrapConfig, ContentFormat contentFormat, Integer bootstrapServerIdOld, String endpoint) {
        ArrayList<BootstrapDownlinkRequest<? extends LwM2mResponse>> requests = new ArrayList<BootstrapDownlinkRequest<? extends LwM2mResponse>>();
        HashSet<CallSite> pathsDelete = new HashSet<CallSite>();
        ArrayList<BootstrapWriteRequest> requestsWrite = new ArrayList<BootstrapWriteRequest>();
        boolean isBsServer = false;
        boolean isLwServer = false;
        HashMap<Integer, Integer> instances = new HashMap<Integer, Integer>();
        Integer bootstrapServerIdNew = null;
        int lwm2mSecurityInstanceId = 0;
        int bootstrapSecurityInstanceId = this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().get(0);
        for (BootstrapConfig.ServerSecurity serverSecurity : new TreeMap(bootstrapConfig.security).values()) {
            if (serverSecurity.bootstrapServer) {
                requestsWrite.add(BootstrapUtil.toWriteRequest((int)bootstrapSecurityInstanceId, (BootstrapConfig.ServerSecurity)serverSecurity, (ContentFormat)contentFormat));
                isBsServer = true;
                bootstrapServerIdNew = serverSecurity.serverId;
                instances.put(serverSecurity.serverId, bootstrapSecurityInstanceId);
                continue;
            }
            if (lwm2mSecurityInstanceId == bootstrapSecurityInstanceId) {
                ++lwm2mSecurityInstanceId;
            }
            requestsWrite.add(BootstrapUtil.toWriteRequest((int)lwm2mSecurityInstanceId, (BootstrapConfig.ServerSecurity)serverSecurity, (ContentFormat)contentFormat));
            instances.put(serverSecurity.serverId, lwm2mSecurityInstanceId);
            isLwServer = true;
            if (!isBsServer && this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().containsKey(serverSecurity.serverId) && lwm2mSecurityInstanceId != this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().get(serverSecurity.serverId)) {
                pathsDelete.add((CallSite)((Object)("/0/" + this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().get(serverSecurity.serverId))));
            }
            Integer serverIdOld = null;
            for (Map.Entry<Integer, Integer> entry : this.lwM2MBootstrapSessionClients.get(endpoint).getSecurityInstances().entrySet()) {
                if (!entry.getValue().equals(lwm2mSecurityInstanceId)) continue;
                serverIdOld = entry.getKey();
            }
            if (!isBsServer && serverIdOld != null && this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().containsKey(serverIdOld)) {
                pathsDelete.add((CallSite)((Object)("/1/" + this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().get(serverIdOld))));
            }
            ++lwm2mSecurityInstanceId;
        }
        for (Map.Entry entry : bootstrapConfig.servers.entrySet()) {
            int securityInstanceId = (Integer)instances.get(((BootstrapConfig.ServerConfig)entry.getValue()).shortId);
            requestsWrite.add(BootstrapUtil.toWriteRequest((int)securityInstanceId, (BootstrapConfig.ServerConfig)((BootstrapConfig.ServerConfig)entry.getValue()), (ContentFormat)contentFormat));
            if (isBsServer) continue;
            if (bootstrapServerIdNew != null && ((BootstrapConfig.ServerConfig)entry.getValue()).shortId == bootstrapServerIdNew && (bootstrapServerIdNew != bootstrapServerIdOld || securityInstanceId != this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().get(bootstrapServerIdOld))) {
                pathsDelete.add((CallSite)((Object)("/1/" + this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().get(bootstrapServerIdOld))));
                continue;
            }
            if (!this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().containsKey(((BootstrapConfig.ServerConfig)entry.getValue()).shortId) || securityInstanceId == this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().get(((BootstrapConfig.ServerConfig)entry.getValue()).shortId)) continue;
            pathsDelete.add((CallSite)((Object)("/1/" + this.lwM2MBootstrapSessionClients.get(endpoint).getServerInstances().get(((BootstrapConfig.ServerConfig)entry.getValue()).shortId))));
        }
        for (Map.Entry entry : bootstrapConfig.acls.entrySet()) {
            requestsWrite.add(BootstrapUtil.toWriteRequest((int)((Integer)entry.getKey()), (BootstrapConfig.ACLConfig)((BootstrapConfig.ACLConfig)entry.getValue()), (ContentFormat)contentFormat));
        }
        if (isBsServer && isLwServer) {
            requests.add((BootstrapDownlinkRequest<? extends LwM2mResponse>)new BootstrapDeleteRequest("/0"));
            requests.add((BootstrapDownlinkRequest<? extends LwM2mResponse>)new BootstrapDeleteRequest("/1"));
        } else {
            pathsDelete.forEach(pathDelete -> requests.add((BootstrapDownlinkRequest<? extends LwM2mResponse>)new BootstrapDeleteRequest(pathDelete)));
        }
        if (requestsWrite.size() > 0) {
            requests.addAll(requestsWrite);
        }
        return requests;
    }

    private void initSupportedObjectsDefault() {
        this.supportedObjects = new HashMap<Integer, String>();
        this.supportedObjects.put(0, "1.1");
        this.supportedObjects.put(1, "1.1");
        this.supportedObjects.put(2, "1.0");
    }

    @Override
    public void remove(String endpoint) {
        this.writeLock.lock();
        try {
            this.lwM2MBootstrapSessionClients.remove(endpoint);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void put(String endpoint) throws InvalidConfigurationException {
        this.writeLock.lock();
        try {
            this.lwM2MBootstrapSessionClients.put(endpoint, new LwM2MBootstrapClientInstanceIds());
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

