/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.EncryptionUtil;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.common.transport.util.SslUtil;
import org.thingsboard.server.queue.util.TbLwM2mBootstrapTransportComponent;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapSecurityStore;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;

@Component
@TbLwM2mBootstrapTransportComponent
public class TbLwM2MDtlsBootstrapCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MDtlsBootstrapCertificateVerifier.class);
    private final LwM2MTransportServerConfig config;
    private final LwM2MBootstrapSecurityStore bsSecurityStore;
    private StaticNewAdvancedCertificateVerifier staticCertificateVerifier;
    @Value(value="${transport.lwm2m.server.security.skip_validity_check_for_client_cert:false}")
    private boolean skipValidityCheckForClientCert;

    public List<CertificateType> getSupportedCertificateTypes() {
        return Arrays.asList(CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY);
    }

    @PostConstruct
    public void init() {
        try {
            if (this.config.getTrustSslCredentials() != null) {
                X509Certificate[] trustedCertificates = this.config.getTrustSslCredentials().getTrustedCertificates();
                this.staticCertificateVerifier = new StaticNewAdvancedCertificateVerifier(trustedCertificates, new RawPublicKeyIdentity[0], null);
            }
        }
        catch (Exception e) {
            log.warn("ailed to initialize the LwM2M certificate verifier", (Throwable)e);
        }
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
        CertPath certChain = message.getCertificateChain();
        if (certChain == null) {
            PublicKey publicKey = message.getPublicKey();
            return new CertificateVerificationResult(cid, publicKey, null);
        }
        try {
            X509Certificate[] chain;
            boolean x509CredentialsFound = false;
            for (X509Certificate cert : chain = certChain.getCertificates().toArray(new X509Certificate[0])) {
                try {
                    ValidateDeviceCredentialsResponse msg;
                    if (!this.skipValidityCheckForClientCert) {
                        cert.checkValidity();
                    }
                    TbLwM2MSecurityInfo securityInfo = null;
                    if (this.staticCertificateVerifier != null) {
                        HandshakeException exception = this.staticCertificateVerifier.verifyCertificate(cid, serverName, remotePeer, clientUsage, verifySubject, truncateCertificatePath, message).getException();
                        if (exception == null) {
                            String endpoint = this.config.getTrustSslCredentials().getValueFromSubjectNameByKey(cert.getSubjectX500Principal().getName(), "CN");
                            if (StringUtils.isNotEmpty((String)endpoint)) {
                                securityInfo = this.bsSecurityStore.getX509ByEndpoint(endpoint);
                            }
                        } else {
                            log.trace("Certificate validation failed.", (Throwable)exception);
                        }
                    }
                    if (securityInfo == null || securityInfo.getMsg() == null) {
                        String strCert = SslUtil.getCertificateString((Certificate)cert);
                        String sha3Hash = EncryptionUtil.getSha3Hash((String)strCert);
                        try {
                            securityInfo = this.bsSecurityStore.getX509ByEndpoint(sha3Hash);
                        }
                        catch (LwM2MAuthException e) {
                            log.trace("Failed to find security info: [{}]", (Object)sha3Hash, (Object)e);
                        }
                    }
                    ValidateDeviceCredentialsResponse validateDeviceCredentialsResponse = msg = securityInfo != null ? securityInfo.getMsg() : null;
                    if (msg == null || !StringUtils.isNotEmpty((String)msg.getCredentials())) continue;
                    x509CredentialsFound = true;
                    break;
                }
                catch (CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException e) {
                    log.trace("Failed to find security info: [{}]", (Object)cert.getSubjectX500Principal().getName(), (Object)e);
                }
            }
            if (!x509CredentialsFound) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                throw new HandshakeException("x509 verification not enabled!", alert);
            }
            return new CertificateVerificationResult(cid, certChain, null);
        }
        catch (HandshakeException e) {
            log.trace("Certificate validation failed!", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    public List<X500Principal> getAcceptedIssuers() {
        return CertPathUtil.toSubjects(null);
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    @ConstructorProperties(value={"config", "bsSecurityStore"})
    public TbLwM2MDtlsBootstrapCertificateVerifier(LwM2MTransportServerConfig config, LwM2MBootstrapSecurityStore bsSecurityStore) {
        this.config = config;
        this.bsSecurityStore = bsSecurityStore;
    }
}

