/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.leshan.core.request.BootstrapDownlinkRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapFailureCause;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.BootstrapTaskProvider;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSession;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.eclipse.leshan.server.model.LwM2mBootstrapModelProvider;
import org.eclipse.leshan.server.model.StandardBootstrapModelProvider;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityChecker;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapConfigStoreTaskProvider;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapSecurityStore;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapTaskProvider;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;

public class LwM2mDefaultBootstrapSessionManager
extends DefaultBootstrapSessionManager {
    private static final Logger log = LoggerFactory.getLogger(LwM2mDefaultBootstrapSessionManager.class);
    private final BootstrapSecurityStore bsSecurityStore;
    private final SecurityChecker securityChecker;
    private final LwM2MBootstrapTaskProvider tasksProvider;
    private final LwM2mBootstrapModelProvider modelProvider;
    private TransportService transportService;

    public LwM2mDefaultBootstrapSessionManager(BootstrapSecurityStore bsSecurityStore, BootstrapConfigStore configStore, TransportService transportService) {
        this(bsSecurityStore, new SecurityChecker(), new LwM2MBootstrapConfigStoreTaskProvider(configStore), (LwM2mBootstrapModelProvider)new StandardBootstrapModelProvider());
        this.transportService = transportService;
    }

    public LwM2mDefaultBootstrapSessionManager(BootstrapSecurityStore bsSecurityStore, SecurityChecker securityChecker, LwM2MBootstrapTaskProvider tasksProvider, LwM2mBootstrapModelProvider modelProvider) {
        super(bsSecurityStore, securityChecker, (BootstrapTaskProvider)tasksProvider, modelProvider);
        this.bsSecurityStore = bsSecurityStore;
        this.securityChecker = securityChecker;
        this.tasksProvider = tasksProvider;
        this.modelProvider = modelProvider;
    }

    public BootstrapSession begin(BootstrapRequest request, Identity clientIdentity) {
        boolean authorized = true;
        Iterator<SecurityInfo> securityInfos = null;
        try {
            if (this.bsSecurityStore != null && this.securityChecker != null) {
                if (clientIdentity.isPSK()) {
                    SecurityInfo securityInfo = this.bsSecurityStore.getByIdentity(clientIdentity.getPskIdentity());
                    securityInfos = Collections.singletonList(securityInfo).iterator();
                } else if (!clientIdentity.isX509()) {
                    securityInfos = this.bsSecurityStore.getAllByEndpoint(request.getEndpointName());
                }
                authorized = this.checkSecurityInfo(request.getEndpointName(), clientIdentity, securityInfos);
            }
        }
        catch (LwM2MAuthException e) {
            authorized = false;
        }
        DefaultBootstrapSession session = new DefaultBootstrapSession(request, clientIdentity, authorized);
        if (authorized) {
            try {
                this.tasksProvider.put(session.getEndpoint());
            }
            catch (InvalidConfigurationException e) {
                log.error("Failed put to lwM2MBootstrapSessionClients by endpoint [{}]", (Object)request.getEndpointName(), (Object)e);
            }
            this.sendLogs(request.getEndpointName(), String.format("%s: Bootstrap session started...", "info", request.getEndpointName()));
        }
        return session;
    }

    public boolean hasConfigFor(BootstrapSession session) {
        BootstrapTaskProvider.Tasks firstTasks = this.tasksProvider.getTasks(session, null);
        if (firstTasks == null) {
            return false;
        }
        this.initTasks(session, firstTasks);
        return true;
    }

    protected void initTasks(BootstrapSession bssession, BootstrapTaskProvider.Tasks tasks) {
        DefaultBootstrapSession session = (DefaultBootstrapSession)bssession;
        if (tasks.supportedObjects != null) {
            session.setModel(this.modelProvider.getObjectModel((BootstrapSession)session, tasks.supportedObjects));
        }
        log.info("tasks.requestsToSend = [{}]", (Object)tasks.requestsToSend);
        session.setRequests(tasks.requestsToSend);
        session.setResponses(new ArrayList(tasks.requestsToSend.size()));
        session.setMoreTasks(!tasks.last);
    }

    public BootstrapDownlinkRequest<? extends LwM2mResponse> getFirstRequest(BootstrapSession bsSession) {
        return this.nextRequest(bsSession);
    }

    protected BootstrapDownlinkRequest<? extends LwM2mResponse> nextRequest(BootstrapSession bsSession) {
        DefaultBootstrapSession session = (DefaultBootstrapSession)bsSession;
        List requestsToSend = session.getRequests();
        if (!requestsToSend.isEmpty()) {
            return (BootstrapDownlinkRequest)requestsToSend.remove(0);
        }
        if (session.hasMoreTasks()) {
            BootstrapTaskProvider.Tasks nextTasks = this.tasksProvider.getTasks((BootstrapSession)session, session.getResponses());
            if (nextTasks == null) {
                session.setMoreTasks(false);
                return new BootstrapFinishRequest();
            }
            this.initTasks((BootstrapSession)session, nextTasks);
            return this.nextRequest(bsSession);
        }
        return new BootstrapFinishRequest();
    }

    public BootstrapSessionManager.BootstrapPolicy onResponseSuccess(BootstrapSession bsSession, BootstrapDownlinkRequest<? extends LwM2mResponse> request, LwM2mResponse response) {
        if (!(request instanceof BootstrapFinishRequest)) {
            DefaultBootstrapSession session = (DefaultBootstrapSession)bsSession;
            session.getResponses().add(response);
            String msg = String.format("%s: receives success response for:  %s  %s %s", "info", request.getClass().getSimpleName(), request.getPath().toString(), response.toString());
            this.sendLogs(bsSession.getEndpoint(), msg);
            return BootstrapSessionManager.BootstrapPolicy.continueWith(this.nextRequest(bsSession));
        }
        this.sendLogs(bsSession.getEndpoint(), String.format("%s: receives success response for bootstrap finish.", "info"));
        this.tasksProvider.remove(bsSession.getEndpoint());
        return BootstrapSessionManager.BootstrapPolicy.finished();
    }

    public BootstrapSessionManager.BootstrapPolicy onResponseError(BootstrapSession bsSession, BootstrapDownlinkRequest<? extends LwM2mResponse> request, LwM2mResponse response) {
        if (!(request instanceof BootstrapFinishRequest)) {
            DefaultBootstrapSession session = (DefaultBootstrapSession)bsSession;
            session.getResponses().add(response);
            this.sendLogs(bsSession.getEndpoint(), String.format("%s: %s %s receives error response %s ", "info", request.getClass().getSimpleName(), request.getPath().toString(), response.toString()));
            return BootstrapSessionManager.BootstrapPolicy.continueWith(this.nextRequest(bsSession));
        }
        this.sendLogs(bsSession.getEndpoint(), String.format("%s: error response for request bootstrap finish. Stop the session: %s", "error", bsSession.toString()));
        this.tasksProvider.remove(bsSession.getEndpoint());
        return BootstrapSessionManager.BootstrapPolicy.failed();
    }

    public BootstrapSessionManager.BootstrapPolicy onRequestFailure(BootstrapSession bsSession, BootstrapDownlinkRequest<? extends LwM2mResponse> request, Throwable cause) {
        this.sendLogs(bsSession.getEndpoint(), String.format("%s: %s %s failed because of %s", "error", request.getClass().getSimpleName(), request.getPath().toString(), cause.toString()));
        return BootstrapSessionManager.BootstrapPolicy.failed();
    }

    public void end(BootstrapSession bsSession) {
        this.sendLogs(bsSession.getEndpoint(), String.format("%s: Bootstrap session finished.", "info"));
        this.tasksProvider.remove(bsSession.getEndpoint());
    }

    public void failed(BootstrapSession bsSession, BootstrapFailureCause cause) {
        this.sendLogs(bsSession.getEndpoint(), String.format("%s: Bootstrap session failed because of %s", "error", cause.toString()));
        this.tasksProvider.remove(bsSession.getEndpoint());
    }

    private void sendLogs(String endpointName, String logMsg) {
        log.info("Endpoint: [{}] [{}]", (Object)endpointName, (Object)logMsg);
        this.transportService.log(((LwM2MBootstrapSecurityStore)this.bsSecurityStore).getSessionByEndpoint(endpointName), logMsg);
    }

    private boolean checkSecurityInfo(String endpoint, Identity clientIdentity, Iterator<SecurityInfo> securityInfos) {
        if (clientIdentity.isX509()) {
            return clientIdentity.getX509CommonName().equals(endpoint) & ((LwM2MBootstrapSecurityStore)this.bsSecurityStore).getBootstrapConfigByEndpoint(endpoint) != null;
        }
        return this.securityChecker.checkSecurityInfos(endpoint, clientIdentity, securityInfos);
    }
}

