/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.device.credentials.lwm2m.AbstractLwM2MBootstrapClientCredentialWithKeys;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MBootstrapClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MSecurityMode;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.AbstractLwM2MBootstrapServerCredential;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.LwM2MBootstrapServerCredential;

public class LwM2MBootstrapConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(LwM2MBootstrapConfig.class);
    private static final long serialVersionUID = -4729088085817468640L;
    List<LwM2MBootstrapServerCredential> serverConfiguration;
    private LwM2MBootstrapClientCredential bootstrapServer;
    private LwM2MBootstrapClientCredential lwm2mServer;

    public LwM2MBootstrapConfig() {
    }

    public LwM2MBootstrapConfig(List<LwM2MBootstrapServerCredential> serverConfiguration, LwM2MBootstrapClientCredential bootstrapClientServer, LwM2MBootstrapClientCredential lwm2mClientServer) {
        this.serverConfiguration = serverConfiguration;
        this.bootstrapServer = bootstrapClientServer;
        this.lwm2mServer = lwm2mClientServer;
    }

    @JsonIgnore
    public BootstrapConfig getLwM2MBootstrapConfig() {
        BootstrapConfig configBs = new BootstrapConfig();
        configBs.autoIdForSecurityObject = true;
        int id = 0;
        for (LwM2MBootstrapServerCredential serverCredential : this.serverConfiguration) {
            BootstrapConfig.ServerConfig serverConfig = this.setServerConfig((AbstractLwM2MBootstrapServerCredential)serverCredential);
            configBs.servers.put(id, serverConfig);
            BootstrapConfig.ServerSecurity serverSecurity = this.setServerSecurity((AbstractLwM2MBootstrapServerCredential)serverCredential, serverCredential.getSecurityMode());
            configBs.security.put(id, serverSecurity);
            ++id;
        }
        return configBs;
    }

    private BootstrapConfig.ServerSecurity setServerSecurity(AbstractLwM2MBootstrapServerCredential serverCredential, LwM2MSecurityMode securityMode) {
        BootstrapConfig.ServerSecurity serverSecurity = new BootstrapConfig.ServerSecurity();
        Object serverUri = "coap://";
        byte[] publicKeyOrId = new byte[]{};
        byte[] secretKey = new byte[]{};
        byte[] serverPublicKey = new byte[]{};
        serverSecurity.serverId = serverCredential.getShortServerId();
        serverSecurity.securityMode = SecurityMode.valueOf((String)securityMode.name());
        serverSecurity.bootstrapServer = serverCredential.isBootstrapServerIs();
        if (!LwM2MSecurityMode.NO_SEC.equals((Object)securityMode)) {
            AbstractLwM2MBootstrapClientCredentialWithKeys server = serverSecurity.bootstrapServer ? (AbstractLwM2MBootstrapClientCredentialWithKeys)this.bootstrapServer : (AbstractLwM2MBootstrapClientCredentialWithKeys)this.lwm2mServer;
            serverUri = "coaps://";
            if (LwM2MSecurityMode.PSK.equals((Object)securityMode)) {
                publicKeyOrId = server.getClientPublicKeyOrId().getBytes();
                secretKey = Hex.decodeHex((char[])server.getClientSecretKey().toCharArray());
            } else {
                publicKeyOrId = server.getDecodedClientPublicKeyOrId();
                secretKey = server.getDecodedClientSecretKey();
            }
            serverPublicKey = serverCredential.getDecodedCServerPublicKey();
        }
        serverSecurity.uri = serverUri = (String)serverUri + (serverCredential.getHost().equals("0.0.0.0") ? "localhost" : serverCredential.getHost()) + ":" + serverCredential.getPort();
        serverSecurity.publicKeyOrId = publicKeyOrId;
        serverSecurity.secretKey = secretKey;
        serverSecurity.serverPublicKey = serverPublicKey;
        return serverSecurity;
    }

    private BootstrapConfig.ServerConfig setServerConfig(AbstractLwM2MBootstrapServerCredential serverCredential) {
        BootstrapConfig.ServerConfig serverConfig = new BootstrapConfig.ServerConfig();
        serverConfig.shortId = serverCredential.getShortServerId();
        serverConfig.lifetime = serverCredential.getLifetime();
        serverConfig.defaultMinPeriod = serverCredential.getDefaultMinPeriod();
        serverConfig.notifIfDisabled = serverCredential.isNotifIfDisabled();
        serverConfig.binding = BindingMode.parse((String)serverCredential.getBinding());
        return serverConfig;
    }

    public List<LwM2MBootstrapServerCredential> getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setServerConfiguration(List<LwM2MBootstrapServerCredential> serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MBootstrapConfig)) {
            return false;
        }
        LwM2MBootstrapConfig other = (LwM2MBootstrapConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LwM2MBootstrapServerCredential> this$serverConfiguration = this.getServerConfiguration();
        List<LwM2MBootstrapServerCredential> other$serverConfiguration = other.getServerConfiguration();
        if (this$serverConfiguration == null ? other$serverConfiguration != null : !((Object)this$serverConfiguration).equals(other$serverConfiguration)) {
            return false;
        }
        LwM2MBootstrapClientCredential this$bootstrapServer = this.getBootstrapServer();
        LwM2MBootstrapClientCredential other$bootstrapServer = other.getBootstrapServer();
        if (this$bootstrapServer == null ? other$bootstrapServer != null : !this$bootstrapServer.equals(other$bootstrapServer)) {
            return false;
        }
        LwM2MBootstrapClientCredential this$lwm2mServer = this.getLwm2mServer();
        LwM2MBootstrapClientCredential other$lwm2mServer = other.getLwm2mServer();
        return !(this$lwm2mServer == null ? other$lwm2mServer != null : !this$lwm2mServer.equals(other$lwm2mServer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MBootstrapConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LwM2MBootstrapServerCredential> $serverConfiguration = this.getServerConfiguration();
        result = result * 59 + ($serverConfiguration == null ? 43 : ((Object)$serverConfiguration).hashCode());
        LwM2MBootstrapClientCredential $bootstrapServer = this.getBootstrapServer();
        result = result * 59 + ($bootstrapServer == null ? 43 : $bootstrapServer.hashCode());
        LwM2MBootstrapClientCredential $lwm2mServer = this.getLwm2mServer();
        result = result * 59 + ($lwm2mServer == null ? 43 : $lwm2mServer.hashCode());
        return result;
    }

    public String toString() {
        return "LwM2MBootstrapConfig(serverConfiguration=" + this.getServerConfiguration() + ", bootstrapServer=" + this.getBootstrapServer() + ", lwm2mServer=" + this.getLwm2mServer() + ")";
    }

    public LwM2MBootstrapClientCredential getBootstrapServer() {
        return this.bootstrapServer;
    }

    public void setBootstrapServer(LwM2MBootstrapClientCredential bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    public LwM2MBootstrapClientCredential getLwm2mServer() {
        return this.lwm2mServer;
    }

    public void setLwm2mServer(LwM2MBootstrapClientCredential lwm2mServer) {
        this.lwm2mServer = lwm2mServer;
    }
}

