/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap;

import java.beans.ConstructorProperties;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServerBuilder;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.queue.util.TbLwM2mBootstrapTransportComponent;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2mDefaultBootstrapSessionManager;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.TbLwM2MDtlsBootstrapCertificateVerifier;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MBootstrapSecurityStore;
import org.thingsboard.server.transport.lwm2m.bootstrap.store.LwM2MInMemoryBootstrapConfigStore;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.DefaultLwM2mTransportService;
import org.thingsboard.server.transport.lwm2m.server.LwM2MNetworkConfig;

@Component
@TbLwM2mBootstrapTransportComponent
public class LwM2MTransportBootstrapService {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportBootstrapService.class);
    private final LwM2MTransportServerConfig serverConfig;
    private final LwM2MTransportBootstrapConfig bootstrapConfig;
    private final LwM2MBootstrapSecurityStore lwM2MBootstrapSecurityStore;
    private final LwM2MInMemoryBootstrapConfigStore lwM2MInMemoryBootstrapConfigStore;
    private final TransportService transportService;
    private final TbLwM2MDtlsBootstrapCertificateVerifier certificateVerifier;
    private LeshanBootstrapServer server;

    @PostConstruct
    public void init() {
        log.info("Starting LwM2M transport bootstrap server...");
        this.server = this.getLhBootstrapServer();
        this.server.start();
        log.info("Started LwM2M transport bootstrap server.");
    }

    @PreDestroy
    public void shutdown() {
        try {
            log.info("Stopping LwM2M transport bootstrap server!");
            this.server.destroy();
            log.info("LwM2M transport bootstrap server stopped!");
        }
        catch (Exception e) {
            log.error("Failed to gracefully stop the LwM2M transport bootstrap server!", (Throwable)e);
        }
    }

    public LeshanBootstrapServer getLhBootstrapServer() {
        LeshanBootstrapServerBuilder builder = new LeshanBootstrapServerBuilder();
        builder.setLocalAddress(this.bootstrapConfig.getHost(), this.bootstrapConfig.getPort().intValue());
        builder.setLocalSecureAddress(this.bootstrapConfig.getSecureHost(), this.bootstrapConfig.getSecurePort().intValue());
        builder.setCoapConfig(LwM2MNetworkConfig.getCoapConfig(this.bootstrapConfig.getPort(), this.bootstrapConfig.getSecurePort(), this.serverConfig));
        DtlsConnectorConfig.Builder dtlsConfig = new DtlsConnectorConfig.Builder(LwM2MNetworkConfig.getCoapConfig(this.bootstrapConfig.getPort(), this.bootstrapConfig.getSecurePort(), this.serverConfig));
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CURVES_ONLY, (Object)this.serverConfig.isRecommendedSupportedGroups());
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)this.serverConfig.isRecommendedCiphers());
        dtlsConfig.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, this.serverConfig.getDtlsRetransmissionTimeout(), TimeUnit.MILLISECONDS);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        this.setServerWithCredentials(builder, dtlsConfig);
        builder.setDtlsConfig(dtlsConfig);
        builder.setConfigStore((BootstrapConfigStore)this.lwM2MInMemoryBootstrapConfigStore);
        builder.setSecurityStore((BootstrapSecurityStore)this.lwM2MBootstrapSecurityStore);
        LwM2mDefaultBootstrapSessionManager sessionManager = new LwM2mDefaultBootstrapSessionManager(this.lwM2MBootstrapSecurityStore, (BootstrapConfigStore)this.lwM2MInMemoryBootstrapConfigStore, this.transportService);
        builder.setSessionManager((BootstrapSessionManager)sessionManager);
        return builder.build();
    }

    private void setServerWithCredentials(LeshanBootstrapServerBuilder builder, DtlsConnectorConfig.Builder dtlsConfig) {
        if (this.bootstrapConfig.getSslCredentials() != null) {
            SslCredentials sslCredentials = this.bootstrapConfig.getSslCredentials();
            builder.setPublicKey(sslCredentials.getPublicKey());
            builder.setPrivateKey(sslCredentials.getPrivateKey());
            builder.setCertificateChain(sslCredentials.getCertificateChain());
            dtlsConfig.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)this.certificateVerifier);
            dtlsConfig.setAsList((BasicListDefinition)DtlsConfig.DTLS_CIPHER_SUITES, (Object[])DefaultLwM2mTransportService.RPK_OR_X509_CIPHER_SUITES);
        } else {
            builder.setTrustedCertificates((Certificate[])new X509Certificate[0]);
            log.info("Unable to load X509 files for BootStrap Server");
            dtlsConfig.setAsList((BasicListDefinition)DtlsConfig.DTLS_CIPHER_SUITES, (Object[])DefaultLwM2mTransportService.PSK_CIPHER_SUITES);
        }
    }

    @ConstructorProperties(value={"serverConfig", "bootstrapConfig", "lwM2MBootstrapSecurityStore", "lwM2MInMemoryBootstrapConfigStore", "transportService", "certificateVerifier"})
    public LwM2MTransportBootstrapService(LwM2MTransportServerConfig serverConfig, LwM2MTransportBootstrapConfig bootstrapConfig, LwM2MBootstrapSecurityStore lwM2MBootstrapSecurityStore, LwM2MInMemoryBootstrapConfigStore lwM2MInMemoryBootstrapConfigStore, TransportService transportService, TbLwM2MDtlsBootstrapCertificateVerifier certificateVerifier) {
        this.serverConfig = serverConfig;
        this.bootstrapConfig = bootstrapConfig;
        this.lwM2MBootstrapSecurityStore = lwM2MBootstrapSecurityStore;
        this.lwM2MInMemoryBootstrapConfigStore = lwM2MInMemoryBootstrapConfigStore;
        this.transportService = transportService;
        this.certificateVerifier = certificateVerifier;
    }
}

