/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientState;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientStore;

public class TbRedisLwM2MClientStore
implements TbLwM2MClientStore {
    private static final Logger log = LoggerFactory.getLogger(TbRedisLwM2MClientStore.class);
    private static final String CLIENT_EP = "CLIENT#EP#";
    private final RedisConnectionFactory connectionFactory;
    private final FSTConfiguration serializer;

    public TbRedisLwM2MClientStore(RedisConnectionFactory redisConnectionFactory) {
        this.connectionFactory = redisConnectionFactory;
        this.serializer = FSTConfiguration.createDefaultConfiguration();
    }

    @Override
    public LwM2mClient get(String endpoint) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            byte[] data = connection.get(this.getKey(endpoint));
            if (data == null) {
                LwM2mClient lwM2mClient = null;
                return lwM2mClient;
            }
            LwM2mClient lwM2mClient = (LwM2mClient)this.serializer.asObject(data);
            return lwM2mClient;
        }
    }

    @Override
    public Set<LwM2mClient> getAll() {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            HashSet<LwM2mClient> clients = new HashSet<LwM2mClient>();
            ScanOptions scanOptions = ScanOptions.scanOptions().count(100L).match("CLIENT#EP#*").build();
            ArrayList<Cursor> scans = new ArrayList<Cursor>();
            if (connection instanceof RedisClusterConnection) {
                ((RedisClusterConnection)connection).clusterGetNodes().forEach(node -> scans.add(((RedisClusterConnection)connection).scan(node, scanOptions)));
            } else {
                scans.add(connection.scan(scanOptions));
            }
            scans.forEach(scan -> scan.forEachRemaining(key -> {
                byte[] element = connection.get(key);
                clients.add((LwM2mClient)this.serializer.asObject(element));
            }));
            HashSet<LwM2mClient> hashSet = clients;
            return hashSet;
        }
    }

    @Override
    public void put(LwM2mClient client) {
        if (client.getState().equals((Object)LwM2MClientState.UNREGISTERED)) {
            log.error("[{}] Client is in invalid state: {}!", new Object[]{client.getEndpoint(), client.getState(), new Exception()});
        } else {
            byte[] clientSerialized = this.serializer.asByteArray((Object)client);
            try (RedisConnection connection = this.connectionFactory.getConnection();){
                connection.getSet(this.getKey(client.getEndpoint()), clientSerialized);
            }
        }
    }

    @Override
    public void remove(String endpoint) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.del((byte[][])new byte[][]{this.getKey(endpoint)});
        }
    }

    private byte[] getKey(String endpoint) {
        return (CLIENT_EP + endpoint).getBytes();
    }
}

