/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.util.Optional;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.californium.registration.InMemoryRegistrationStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.server.store.TbDummyLwM2MClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbDummyLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbInMemorySecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbL2M2MDtlsSessionInMemoryStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionRedisStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisRegistrationStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbMainSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbRedisLwM2MClientStore;

@Component
@TbLwM2mTransportComponent
public class TbLwM2mStoreFactory {
    @Autowired(required=false)
    private Optional<TBRedisCacheConfiguration> redisConfiguration;
    @Autowired
    private LwM2MTransportServerConfig config;
    @Autowired
    private LwM2mCredentialsSecurityInfoValidator validator;
    @Value(value="${transport.lwm2m.redis.enabled:false}")
    private boolean useRedis;

    @Bean
    private CaliforniumRegistrationStore registrationStore() {
        return this.isRedis() ? new TbLwM2mRedisRegistrationStore(this.getConnectionFactory()) : new InMemoryRegistrationStore((long)this.config.getCleanPeriodInSec());
    }

    @Bean
    private TbMainSecurityStore securityStore() {
        return new TbLwM2mSecurityStore(this.isRedis() ? new TbLwM2mRedisSecurityStore(this.getConnectionFactory()) : new TbInMemorySecurityStore(), this.validator);
    }

    @Bean
    private TbLwM2MClientStore clientStore() {
        return this.isRedis() ? new TbRedisLwM2MClientStore(this.getConnectionFactory()) : new TbDummyLwM2MClientStore();
    }

    @Bean
    private TbLwM2MClientOtaInfoStore otaStore() {
        return this.isRedis() ? new TbLwM2mRedisClientOtaInfoStore(this.getConnectionFactory()) : new TbDummyLwM2MClientOtaInfoStore();
    }

    @Bean
    private TbLwM2MDtlsSessionStore sessionStore() {
        return this.isRedis() ? new TbLwM2MDtlsSessionRedisStore(this.getConnectionFactory()) : new TbL2M2MDtlsSessionInMemoryStore();
    }

    private RedisConnectionFactory getConnectionFactory() {
        return this.redisConfiguration.get().redisConnectionFactory();
    }

    private boolean isRedis() {
        return this.redisConfiguration.isPresent() && this.useRedis;
    }
}

