/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.store.TbEditableSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbMainSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

public class TbLwM2mSecurityStore
implements TbMainSecurityStore {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2mSecurityStore.class);
    private final TbEditableSecurityStore securityStore;
    private final LwM2mCredentialsSecurityInfoValidator validator;
    private final ConcurrentMap<String, Set<String>> endpointRegistrations = new ConcurrentHashMap<String, Set<String>>();

    public TbLwM2mSecurityStore(TbEditableSecurityStore securityStore, LwM2mCredentialsSecurityInfoValidator validator) {
        this.securityStore = securityStore;
        this.validator = validator;
    }

    @Override
    public TbLwM2MSecurityInfo getTbLwM2MSecurityInfoByEndpoint(String endpoint) {
        return this.securityStore.getTbLwM2MSecurityInfoByEndpoint(endpoint);
    }

    public SecurityInfo getByEndpoint(String endpoint) {
        SecurityInfo securityInfo = this.securityStore.getByEndpoint(endpoint);
        if (securityInfo == null) {
            securityInfo = this.fetchAndPutSecurityInfo(endpoint);
        }
        return securityInfo;
    }

    public SecurityInfo getByIdentity(String pskIdentity) {
        SecurityInfo securityInfo = this.securityStore.getByIdentity(pskIdentity);
        if (securityInfo == null) {
            securityInfo = this.fetchAndPutSecurityInfo(pskIdentity);
        }
        return securityInfo;
    }

    @Nullable
    public SecurityInfo fetchAndPutSecurityInfo(String credentialsId) {
        TbLwM2MSecurityInfo securityInfo = this.validator.getEndpointSecurityInfoByCredentialsId(credentialsId, LwM2mTypeServer.CLIENT);
        this.doPut(securityInfo);
        return securityInfo != null ? securityInfo.getSecurityInfo() : null;
    }

    private void doPut(TbLwM2MSecurityInfo securityInfo) {
        if (securityInfo != null) {
            try {
                this.securityStore.put(securityInfo);
            }
            catch (NonUniqueSecurityInfoException e) {
                log.trace("Failed to add security info: {}", (Object)securityInfo, (Object)e);
            }
        }
    }

    @Override
    public void putX509(TbLwM2MSecurityInfo securityInfo) throws NonUniqueSecurityInfoException {
        this.securityStore.put(securityInfo);
    }

    @Override
    public void registerX509(String endpoint, String registrationId) {
        this.endpointRegistrations.computeIfAbsent(endpoint, ep -> new HashSet()).add(registrationId);
    }

    @Override
    public void remove(String endpoint, String registrationId) {
        boolean shouldRemove;
        Set epRegistrationIds = (Set)this.endpointRegistrations.get(endpoint);
        if (epRegistrationIds == null) {
            shouldRemove = true;
        } else {
            epRegistrationIds.remove(registrationId);
            shouldRemove = epRegistrationIds.isEmpty();
        }
        if (shouldRemove) {
            this.securityStore.remove(endpoint);
        }
    }
}

