/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.util.concurrent.locks.Lock;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.store.TbEditableSecurityStore;

public class TbLwM2mRedisSecurityStore
implements TbEditableSecurityStore {
    private static final String SEC_EP = "SEC#EP#";
    private static final String LOCK_EP = "LOCK#EP#";
    private static final String PSKID_SEC = "PSKID#SEC";
    private final RedisConnectionFactory connectionFactory;
    private final FSTConfiguration serializer;
    private final RedisLockRegistry redisLock;

    public TbLwM2mRedisSecurityStore(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.redisLock = new RedisLockRegistry(connectionFactory, "Security");
        this.serializer = FSTConfiguration.createDefaultConfiguration();
    }

    public SecurityInfo getByEndpoint(String endpoint) {
        Lock lock = null;
        try {
            SecurityInfo securityInfo;
            block14: {
                byte[] data;
                RedisConnection connection;
                block12: {
                    SecurityInfo securityInfo2;
                    block13: {
                        connection = this.connectionFactory.getConnection();
                        try {
                            lock = this.redisLock.obtain((Object)this.toLockKey(endpoint));
                            lock.lock();
                            data = connection.get((SEC_EP + endpoint).getBytes());
                            if (data != null && data.length != 0) break block12;
                            securityInfo2 = null;
                            if (connection == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        connection.close();
                    }
                    return securityInfo2;
                }
                securityInfo = ((TbLwM2MSecurityInfo)this.serializer.asObject(data)).getSecurityInfo();
                if (connection == null) break block14;
                connection.close();
            }
            return securityInfo;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public SecurityInfo getByIdentity(String identity) {
        Lock lock = null;
        try {
            SecurityInfo securityInfo;
            block18: {
                byte[] data;
                RedisConnection connection;
                block16: {
                    SecurityInfo securityInfo2;
                    block17: {
                        byte[] ep;
                        block14: {
                            SecurityInfo securityInfo3;
                            block15: {
                                connection = this.connectionFactory.getConnection();
                                try {
                                    lock = this.redisLock.obtain((Object)this.toLockKey(identity));
                                    lock.lock();
                                    ep = connection.hGet(PSKID_SEC.getBytes(), identity.getBytes());
                                    if (ep != null) break block14;
                                    securityInfo3 = null;
                                    if (connection == null) break block15;
                                }
                                catch (Throwable throwable) {
                                    if (connection != null) {
                                        try {
                                            connection.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                connection.close();
                            }
                            return securityInfo3;
                        }
                        data = connection.get((SEC_EP + new String(ep)).getBytes());
                        if (data != null && data.length != 0) break block16;
                        securityInfo2 = null;
                        if (connection == null) break block17;
                        connection.close();
                    }
                    return securityInfo2;
                }
                securityInfo = ((TbLwM2MSecurityInfo)this.serializer.asObject(data)).getSecurityInfo();
                if (connection == null) break block18;
                connection.close();
            }
            return securityInfo;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TbLwM2MSecurityInfo tbSecurityInfo) throws NonUniqueSecurityInfoException {
        SecurityInfo info = tbSecurityInfo.getSecurityInfo();
        byte[] tbSecurityInfoSerialized = this.serializer.asByteArray((Object)tbSecurityInfo);
        Lock lock = null;
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            String previousIdentity;
            byte[] previousData;
            byte[] oldEndpointBytes;
            lock = this.redisLock.obtain((Object)tbSecurityInfo.getEndpoint());
            lock.lock();
            if (info != null && info.getIdentity() != null && (oldEndpointBytes = connection.hGet(PSKID_SEC.getBytes(), info.getIdentity().getBytes())) != null) {
                String oldEndpoint = new String(oldEndpointBytes);
                if (!oldEndpoint.equals(info.getEndpoint())) {
                    throw new NonUniqueSecurityInfoException("PSK Identity " + info.getIdentity() + " is already used");
                }
                connection.hSet(PSKID_SEC.getBytes(), info.getIdentity().getBytes(), info.getEndpoint().getBytes());
            }
            if ((previousData = connection.getSet((SEC_EP + tbSecurityInfo.getEndpoint()).getBytes(), tbSecurityInfoSerialized)) != null && info != null && (previousIdentity = ((TbLwM2MSecurityInfo)this.serializer.asObject(previousData)).getSecurityInfo().getIdentity()) != null && !previousIdentity.equals(info.getIdentity())) {
                connection.hDel(PSKID_SEC.getBytes(), (byte[][])new byte[][]{previousIdentity.getBytes()});
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public TbLwM2MSecurityInfo getTbLwM2MSecurityInfoByEndpoint(String endpoint) {
        Lock lock = null;
        try {
            TbLwM2MSecurityInfo tbLwM2MSecurityInfo;
            block14: {
                RedisConnection connection;
                block12: {
                    TbLwM2MSecurityInfo tbLwM2MSecurityInfo2;
                    block13: {
                        connection = this.connectionFactory.getConnection();
                        try {
                            lock = this.redisLock.obtain((Object)endpoint);
                            lock.lock();
                            byte[] data = connection.get((SEC_EP + endpoint).getBytes());
                            if (data == null || data.length <= 0) break block12;
                            tbLwM2MSecurityInfo2 = (TbLwM2MSecurityInfo)this.serializer.asObject(data);
                            if (connection == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        connection.close();
                    }
                    return tbLwM2MSecurityInfo2;
                }
                tbLwM2MSecurityInfo = null;
                if (connection == null) break block14;
                connection.close();
            }
            return tbLwM2MSecurityInfo;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String endpoint) {
        Lock lock = null;
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            lock = this.redisLock.obtain((Object)endpoint);
            lock.lock();
            byte[] data = connection.get((SEC_EP + endpoint).getBytes());
            if (data != null && data.length > 0) {
                SecurityInfo info = ((TbLwM2MSecurityInfo)this.serializer.asObject(data)).getSecurityInfo();
                if (info != null && info.getIdentity() != null) {
                    connection.hDel(PSKID_SEC.getBytes(), (byte[][])new byte[][]{info.getIdentity().getBytes()});
                }
                connection.del((byte[][])new byte[][]{(SEC_EP + endpoint).getBytes()});
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private String toLockKey(String endpoint) {
        return LOCK_EP + endpoint;
    }
}

