/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import org.nustaq.serialization.FSTConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.thingsboard.server.transport.lwm2m.secure.TbX509DtlsSessionInfo;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;

public class TbLwM2MDtlsSessionRedisStore
implements TbLwM2MDtlsSessionStore {
    private static final String SESSION_EP = "SESSION#EP#";
    private final RedisConnectionFactory connectionFactory;
    private final FSTConfiguration serializer;

    public TbLwM2MDtlsSessionRedisStore(RedisConnectionFactory redisConnectionFactory) {
        this.connectionFactory = redisConnectionFactory;
        this.serializer = FSTConfiguration.createDefaultConfiguration();
    }

    @Override
    public void put(String endpoint, TbX509DtlsSessionInfo msg) {
        block7: {
            try (RedisConnection c = this.connectionFactory.getConnection();){
                byte[] serializedMsg = this.serializer.asByteArray((Object)msg);
                if (serializedMsg != null) {
                    c.set(this.getKey(endpoint), serializedMsg);
                    break block7;
                }
                throw new RuntimeException("Problem with serialization of message: " + msg);
            }
        }
    }

    @Override
    public TbX509DtlsSessionInfo get(String endpoint) {
        try (RedisConnection c = this.connectionFactory.getConnection();){
            byte[] data = c.get(this.getKey(endpoint));
            if (data != null) {
                TbX509DtlsSessionInfo tbX509DtlsSessionInfo = (TbX509DtlsSessionInfo)this.serializer.asObject(data);
                return tbX509DtlsSessionInfo;
            }
            TbX509DtlsSessionInfo tbX509DtlsSessionInfo = null;
            return tbX509DtlsSessionInfo;
        }
    }

    @Override
    public void remove(String endpoint) {
        try (RedisConnection c = this.connectionFactory.getConnection();){
            c.del((byte[][])new byte[][]{this.getKey(endpoint)});
        }
    }

    private byte[] getKey(String endpoint) {
        return (SESSION_EP + endpoint).getBytes();
    }
}

