/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.store.TbEditableSecurityStore;

public class TbInMemorySecurityStore
implements TbEditableSecurityStore {
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected Map<String, TbLwM2MSecurityInfo> securityByEp = new HashMap<String, TbLwM2MSecurityInfo>();
    protected Map<String, TbLwM2MSecurityInfo> securityByIdentity = new HashMap<String, TbLwM2MSecurityInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityInfo getByEndpoint(String endpoint) {
        this.readLock.lock();
        try {
            TbLwM2MSecurityInfo securityInfo = this.securityByEp.get(endpoint);
            if (securityInfo != null) {
                SecurityInfo securityInfo2 = securityInfo.getSecurityInfo();
                return securityInfo2;
            }
            SecurityInfo securityInfo3 = null;
            return securityInfo3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityInfo getByIdentity(String identity) {
        this.readLock.lock();
        try {
            TbLwM2MSecurityInfo securityInfo = this.securityByIdentity.get(identity);
            if (securityInfo != null) {
                SecurityInfo securityInfo2 = securityInfo.getSecurityInfo();
                return securityInfo2;
            }
            SecurityInfo securityInfo3 = null;
            return securityInfo3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TbLwM2MSecurityInfo tbSecurityInfo) throws NonUniqueSecurityInfoException {
        this.writeLock.lock();
        try {
            String previousIdentity;
            TbLwM2MSecurityInfo previous;
            String identity = null;
            if (tbSecurityInfo.getSecurityInfo() != null && (identity = tbSecurityInfo.getSecurityInfo().getIdentity()) != null) {
                TbLwM2MSecurityInfo infoByIdentity = this.securityByIdentity.get(identity);
                if (infoByIdentity != null && !tbSecurityInfo.getSecurityInfo().getEndpoint().equals(infoByIdentity.getEndpoint())) {
                    throw new NonUniqueSecurityInfoException("PSK Identity " + identity + " is already used");
                }
                this.securityByIdentity.put(tbSecurityInfo.getSecurityInfo().getIdentity(), tbSecurityInfo);
            }
            if ((previous = this.securityByEp.put(tbSecurityInfo.getEndpoint(), tbSecurityInfo)) != null && previous.getSecurityInfo() != null && (previousIdentity = previous.getSecurityInfo().getIdentity()) != null && !previousIdentity.equals(identity)) {
                this.securityByIdentity.remove(previousIdentity);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(String endpoint) {
        this.writeLock.lock();
        try {
            TbLwM2MSecurityInfo securityInfo = this.securityByEp.remove(endpoint);
            if (securityInfo != null && securityInfo.getSecurityInfo() != null && securityInfo.getSecurityInfo().getIdentity() != null) {
                this.securityByIdentity.remove(securityInfo.getSecurityInfo().getIdentity());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public TbLwM2MSecurityInfo getTbLwM2MSecurityInfoByEndpoint(String endpoint) {
        this.readLock.lock();
        try {
            TbLwM2MSecurityInfo tbLwM2MSecurityInfo = this.securityByEp.get(endpoint);
            return tbLwM2MSecurityInfo;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

