/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota;

import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.request.ContentFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.data.lwm2m.OtherConfiguration;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.ota.OtaPackageKey;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.ota.OtaPackageUpdateStatus;
import org.thingsboard.server.common.data.ota.OtaPackageUtil;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.attributes.LwM2MAttributesService;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.common.LwM2MExecutorAwareService;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MClientOtaInfo;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareDeliveryMethod;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateResult;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateState;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.LwM2MClientFwOtaInfo;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.LwM2MFirmwareUpdateStrategy;
import org.thingsboard.server.transport.lwm2m.server.ota.software.LwM2MClientSwOtaInfo;
import org.thingsboard.server.transport.lwm2m.server.ota.software.LwM2MSoftwareUpdateStrategy;
import org.thingsboard.server.transport.lwm2m.server.ota.software.SoftwareUpdateResult;
import org.thingsboard.server.transport.lwm2m.server.ota.software.SoftwareUpdateState;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MOtaUpdateService
extends LwM2MExecutorAwareService
implements LwM2MOtaUpdateService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MOtaUpdateService.class);
    public static final String FIRMWARE_VERSION = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.FIRMWARE, (OtaPackageKey)OtaPackageKey.VERSION);
    public static final String FIRMWARE_TITLE = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.FIRMWARE, (OtaPackageKey)OtaPackageKey.TITLE);
    public static final String FIRMWARE_TAG = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.FIRMWARE, (OtaPackageKey)OtaPackageKey.TAG);
    public static final String FIRMWARE_URL = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.FIRMWARE, (OtaPackageKey)OtaPackageKey.URL);
    public static final String SOFTWARE_VERSION = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.SOFTWARE, (OtaPackageKey)OtaPackageKey.VERSION);
    public static final String SOFTWARE_TITLE = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.SOFTWARE, (OtaPackageKey)OtaPackageKey.TITLE);
    public static final String SOFTWARE_TAG = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.SOFTWARE, (OtaPackageKey)OtaPackageKey.TAG);
    public static final String SOFTWARE_URL = OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.SOFTWARE, (OtaPackageKey)OtaPackageKey.URL);
    public static final String FIRMWARE_UPDATE_COAP_RESOURCE = "tbfw";
    public static final String SOFTWARE_UPDATE_COAP_RESOURCE = "tbsw";
    private static final String FW_PACKAGE_5_ID = "/5/0/0";
    private static final String FW_PACKAGE_19_ID = "/19/0/0";
    private static final String FW_URL_ID = "/5/0/1";
    private static final String FW_EXECUTE_ID = "/5/0/2";
    public static final String FW_STATE_ID = "/5/0/3";
    public static final String FW_RESULT_ID = "/5/0/5";
    public static final String FW_NAME_ID = "/5/0/6";
    public static final String FW_VER_ID = "/5/0/7";
    public static final String FW_3_VER_ID = "/3/0/3";
    public static final String FW_DELIVERY_METHOD = "/5/0/9";
    public static final String SW_3_VER_ID = "/3/0/19";
    public static final String SW_NAME_ID = "/9/0/0";
    public static final String SW_VER_ID = "/9/0/1";
    public static final String SW_PACKAGE_ID = "/9/0/2";
    public static final String SW_PACKAGE_URI_ID = "/9/0/3";
    public static final String SW_INSTALL_ID = "/9/0/4";
    public static final String SW_STATE_ID = "/9/0/7";
    public static final String SW_RESULT_ID = "/9/0/9";
    public static final String SW_UN_INSTALL_ID = "/9/0/6";
    private final Map<String, LwM2MClientFwOtaInfo> fwStates = new ConcurrentHashMap<String, LwM2MClientFwOtaInfo>();
    private final Map<String, LwM2MClientSwOtaInfo> swStates = new ConcurrentHashMap<String, LwM2MClientSwOtaInfo>();
    private final TransportService transportService;
    private final LwM2mClientContext clientContext;
    private final LwM2MTransportServerConfig config;
    private final LwM2mUplinkMsgHandler uplinkHandler;
    private final LwM2mDownlinkMsgHandler downlinkHandler;
    private final OtaPackageDataCache otaPackageDataCache;
    private final LwM2MTelemetryLogService logService;
    private final LwM2mTransportServerHelper helper;
    private final TbLwM2MClientOtaInfoStore otaInfoStore;
    @Autowired
    @Lazy
    private LwM2MAttributesService attributesService;

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    @Override
    protected int getExecutorSize() {
        return this.config.getOtaPoolSize();
    }

    @Override
    protected String getExecutorName() {
        return "LwM2M OTA";
    }

    @Override
    public void init(LwM2mClient client) {
        LwM2MClientSwOtaInfo swInfo;
        ArrayList<String> attributesToFetch = new ArrayList<String>();
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        if (fwInfo.isSupported()) {
            attributesToFetch.add(FIRMWARE_TITLE);
            attributesToFetch.add(FIRMWARE_VERSION);
            attributesToFetch.add(FIRMWARE_TAG);
            attributesToFetch.add(FIRMWARE_URL);
        }
        if ((swInfo = this.getOrInitSwInfo(client)).isSupported()) {
            attributesToFetch.add(SOFTWARE_TITLE);
            attributesToFetch.add(SOFTWARE_VERSION);
            attributesToFetch.add(SOFTWARE_TAG);
            attributesToFetch.add(SOFTWARE_URL);
        }
        OtherConfiguration clientSettings = this.clientContext.getProfile(client.getProfileId()).getClientLwM2mSettings();
        this.onFirmwareStrategyUpdate(client, clientSettings);
        this.onCurrentSoftwareStrategyUpdate(client, clientSettings);
        if (!attributesToFetch.isEmpty()) {
            ListenableFuture<List<TransportProtos.TsKvProto>> future = this.attributesService.getSharedAttributes(client, attributesToFetch);
            DonAsynchron.withCallback(future, attrs -> {
                if (fwInfo.isSupported()) {
                    Optional<String> newFwTitle = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, FIRMWARE_TITLE);
                    Optional<String> newFwVersion = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, FIRMWARE_VERSION);
                    Optional<String> newFwTag = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, FIRMWARE_TAG);
                    Optional<String> newFwUrl = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, FIRMWARE_URL);
                    if (newFwTitle.isPresent() && newFwVersion.isPresent()) {
                        this.onTargetFirmwareUpdate(client, newFwTitle.get(), newFwVersion.get(), newFwUrl, newFwTag);
                    }
                }
                if (swInfo.isSupported()) {
                    Optional<String> newSwTitle = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, SOFTWARE_TITLE);
                    Optional<String> newSwVersion = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, SOFTWARE_VERSION);
                    Optional<String> newSwTag = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, SOFTWARE_TAG);
                    Optional<String> newSwUrl = this.getAttributeValue((List<TransportProtos.TsKvProto>)attrs, SOFTWARE_URL);
                    if (newSwTitle.isPresent() && newSwVersion.isPresent()) {
                        this.onTargetSoftwareUpdate(client, newSwTitle.get(), newSwVersion.get(), newSwUrl, newSwTag);
                    }
                }
            }, throwable -> {
                if (fwInfo.isSupported()) {
                    this.update(fwInfo);
                }
            }, (Executor)this.executor);
        }
    }

    @Override
    public void forceFirmwareUpdate(LwM2mClient client) {
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.setRetryAttempts(0);
        fwInfo.setFailedPackageId(null);
        this.startFirmwareUpdateIfNeeded(client, fwInfo);
    }

    @Override
    public void onTargetFirmwareUpdate(LwM2mClient client, String newFirmwareTitle, String newFirmwareVersion, Optional<String> newFirmwareUrl, Optional<String> newFirmwareTag) {
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.updateTarget(newFirmwareTitle, newFirmwareVersion, newFirmwareUrl, newFirmwareTag);
        this.update(fwInfo);
        this.startFirmwareUpdateIfNeeded(client, fwInfo);
    }

    @Override
    public void onCurrentFirmwareNameUpdate(LwM2mClient client, String name) {
        log.debug("[{}] Current fw name: {}", (Object)client.getEndpoint(), (Object)name);
        this.getOrInitFwInfo(client).setCurrentName(name);
    }

    @Override
    public void onCurrentSoftwareNameUpdate(LwM2mClient client, String name) {
        log.debug("[{}] Current sw name: {}", (Object)client.getEndpoint(), (Object)name);
        this.getOrInitSwInfo(client).setCurrentName(name);
    }

    @Override
    public void onFirmwareStrategyUpdate(LwM2mClient client, OtherConfiguration configuration) {
        log.debug("[{}] Current fw strategy: {}", (Object)client.getEndpoint(), (Object)configuration.getFwUpdateStrategy());
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.setStrategy(LwM2MFirmwareUpdateStrategy.fromStrategyFwByCode(configuration.getFwUpdateStrategy()));
        fwInfo.setBaseUrl(configuration.getFwUpdateResource());
        this.startFirmwareUpdateIfNeeded(client, fwInfo);
    }

    @Override
    public void onCurrentSoftwareStrategyUpdate(LwM2mClient client, OtherConfiguration configuration) {
        log.debug("[{}] Current sw strategy: {}", (Object)client.getEndpoint(), (Object)configuration.getSwUpdateStrategy());
        LwM2MClientSwOtaInfo swInfo = this.getOrInitSwInfo(client);
        swInfo.setStrategy(LwM2MSoftwareUpdateStrategy.fromStrategySwByCode(configuration.getSwUpdateStrategy()));
        swInfo.setBaseUrl(configuration.getSwUpdateResource());
        this.startSoftwareUpdateIfNeeded(client, swInfo);
    }

    @Override
    public void onCurrentFirmwareVersion3Update(LwM2mClient client, String version) {
        log.debug("[{}] Current fw version(3): {}", (Object)client.getEndpoint(), (Object)version);
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.setCurrentVersion3(version);
    }

    @Override
    public void onCurrentFirmwareVersionUpdate(LwM2mClient client, String version) {
        log.debug("[{}] Current fw version(5): {}", (Object)client.getEndpoint(), (Object)version);
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.setCurrentVersion(version);
    }

    @Override
    public void onCurrentFirmwareStateUpdate(LwM2mClient client, Long stateCode) {
        log.debug("[{}] Current fw state: {}", (Object)client.getEndpoint(), (Object)stateCode);
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        FirmwareUpdateState state = FirmwareUpdateState.fromStateFwByCode(stateCode.intValue());
        if (FirmwareUpdateState.DOWNLOADED.equals((Object)state)) {
            this.executeFwUpdate(client);
        }
        fwInfo.setUpdateState(state);
        Optional<OtaPackageUpdateStatus> status = DefaultLwM2MOtaUpdateService.toOtaPackageUpdateStatus(state);
        if (FirmwareUpdateState.IDLE.equals((Object)state) && OtaPackageUpdateStatus.DOWNLOADING.equals((Object)fwInfo.getStatus())) {
            fwInfo.setFailedPackageId(fwInfo.getTargetPackageId());
            status = Optional.of(OtaPackageUpdateStatus.FAILED);
        }
        status.ifPresent(otaStatus -> {
            fwInfo.setStatus((OtaPackageUpdateStatus)otaStatus);
            this.sendStateUpdateToTelemetry(client, fwInfo, (OtaPackageUpdateStatus)otaStatus, "Firmware Update State: " + state.name());
        });
        this.update(fwInfo);
    }

    @Override
    public void onCurrentFirmwareResultUpdate(LwM2mClient client, Long code) {
        log.debug("[{}] Current fw result: {}", (Object)client.getEndpoint(), (Object)code);
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        FirmwareUpdateResult result = FirmwareUpdateResult.fromUpdateResultFwByCode(code.intValue());
        Optional<OtaPackageUpdateStatus> status = DefaultLwM2MOtaUpdateService.toOtaPackageUpdateStatus(result);
        if (FirmwareUpdateResult.INITIAL.equals((Object)result) && OtaPackageUpdateStatus.UPDATING.equals((Object)fwInfo.getStatus())) {
            status = Optional.of(OtaPackageUpdateStatus.UPDATED);
            fwInfo.setRetryAttempts(0);
        }
        status.ifPresent(otaStatus -> {
            fwInfo.setStatus((OtaPackageUpdateStatus)otaStatus);
            this.sendStateUpdateToTelemetry(client, fwInfo, (OtaPackageUpdateStatus)otaStatus, "Firmware Update Result: " + result.name());
        });
        if (result.isAgain() && fwInfo.getRetryAttempts() <= 2) {
            fwInfo.setRetryAttempts(fwInfo.getRetryAttempts() + 1);
            this.startFirmwareUpdateIfNeeded(client, fwInfo);
        } else {
            fwInfo.update(result);
        }
        this.update(fwInfo);
    }

    @Override
    public void onCurrentFirmwareDeliveryMethodUpdate(LwM2mClient client, Long value) {
        log.debug("[{}] Current fw delivery method: {}", (Object)client.getEndpoint(), (Object)value);
        LwM2MClientFwOtaInfo fwInfo = this.getOrInitFwInfo(client);
        fwInfo.setDeliveryMethod(value.intValue());
    }

    @Override
    public void onCurrentSoftwareVersion3Update(LwM2mClient client, String version) {
        log.debug("[{}] Current sw version(3): {}", (Object)client.getEndpoint(), (Object)version);
        this.getOrInitSwInfo(client).setCurrentVersion3(version);
    }

    @Override
    public void onCurrentSoftwareVersionUpdate(LwM2mClient client, String version) {
        log.debug("[{}] Current sw version(9): {}", (Object)client.getEndpoint(), (Object)version);
        this.getOrInitSwInfo(client).setCurrentVersion(version);
    }

    @Override
    public void onCurrentSoftwareStateUpdate(LwM2mClient client, Long stateCode) {
        log.debug("[{}] Current sw state: {}", (Object)client.getEndpoint(), (Object)stateCode);
        LwM2MClientSwOtaInfo swInfo = this.getOrInitSwInfo(client);
        SoftwareUpdateState state = SoftwareUpdateState.fromUpdateStateSwByCode(stateCode.intValue());
        if (SoftwareUpdateState.INITIAL.equals((Object)state)) {
            this.startSoftwareUpdateIfNeeded(client, swInfo);
        } else if (SoftwareUpdateState.DELIVERED.equals((Object)state)) {
            this.executeSwInstall(client);
        }
        swInfo.setUpdateState(state);
        Optional<OtaPackageUpdateStatus> status = DefaultLwM2MOtaUpdateService.toOtaPackageUpdateStatus(state);
        status.ifPresent(otaStatus -> this.sendStateUpdateToTelemetry(client, swInfo, (OtaPackageUpdateStatus)otaStatus, "Firmware Update State: " + state.name()));
        this.update(swInfo);
    }

    @Override
    public void onCurrentSoftwareResultUpdate(LwM2mClient client, Long code) {
        log.debug("[{}] Current sw result: {}", (Object)client.getEndpoint(), (Object)code);
        LwM2MClientSwOtaInfo swInfo = this.getOrInitSwInfo(client);
        SoftwareUpdateResult result = SoftwareUpdateResult.fromUpdateResultSwByCode(code.intValue());
        Optional<OtaPackageUpdateStatus> status = DefaultLwM2MOtaUpdateService.toOtaPackageUpdateStatus(result);
        status.ifPresent(otaStatus -> this.sendStateUpdateToTelemetry(client, swInfo, (OtaPackageUpdateStatus)otaStatus, "Software Update Result: " + result.name()));
        if (result.isAgain() && swInfo.getRetryAttempts() <= 2) {
            swInfo.setRetryAttempts(swInfo.getRetryAttempts() + 1);
            this.startSoftwareUpdateIfNeeded(client, swInfo);
        } else {
            swInfo.update(result);
        }
        this.update(swInfo);
    }

    @Override
    public void onTargetSoftwareUpdate(LwM2mClient client, String newSoftwareTitle, String newSoftwareVersion, Optional<String> newSoftwareUrl, Optional<String> newSoftwareTag) {
        LwM2MClientSwOtaInfo fwInfo = this.getOrInitSwInfo(client);
        fwInfo.updateTarget(newSoftwareTitle, newSoftwareVersion, newSoftwareUrl, newSoftwareTag);
        this.update(fwInfo);
        this.startSoftwareUpdateIfNeeded(client, fwInfo);
    }

    private void startFirmwareUpdateIfNeeded(LwM2mClient client, LwM2MClientFwOtaInfo fwInfo) {
        try {
            if (!fwInfo.isSupported() && fwInfo.isAssigned()) {
                log.debug("[{}] Fw update is not supported: {}", (Object)client.getEndpoint(), (Object)fwInfo);
                this.sendStateUpdateToTelemetry(client, fwInfo, OtaPackageUpdateStatus.FAILED, "Client does not support firmware update or profile misconfiguration!");
            } else if (fwInfo.isUpdateRequired()) {
                if (StringUtils.isNotEmpty((String)fwInfo.getTargetUrl())) {
                    log.debug("[{}] Starting update to [{}{}][] using URL: {}", new Object[]{client.getEndpoint(), fwInfo.getTargetName(), fwInfo.getTargetVersion(), fwInfo.getTargetUrl()});
                    this.startUpdateUsingUrl(client, FW_URL_ID, fwInfo.getTargetUrl());
                } else {
                    log.debug("[{}] Starting update to [{}{}] using binary", new Object[]{client.getEndpoint(), fwInfo.getTargetName(), fwInfo.getTargetVersion()});
                    this.startUpdateUsingBinary(client, fwInfo);
                }
            }
        }
        catch (Exception e) {
            log.info("[{}] failed to update client: {}", new Object[]{client.getEndpoint(), fwInfo, e});
            this.sendStateUpdateToTelemetry(client, fwInfo, OtaPackageUpdateStatus.FAILED, "Internal server error: " + e.getMessage());
        }
    }

    private void startSoftwareUpdateIfNeeded(LwM2mClient client, LwM2MClientSwOtaInfo swInfo) {
        try {
            if (!swInfo.isSupported() && swInfo.isAssigned()) {
                log.debug("[{}] Sw update is not supported: {}", (Object)client.getEndpoint(), (Object)swInfo);
                this.sendStateUpdateToTelemetry(client, swInfo, OtaPackageUpdateStatus.FAILED, "Client does not support software update or profile misconfiguration!");
            } else if (swInfo.isUpdateRequired()) {
                if (SoftwareUpdateState.INSTALLED.equals(swInfo.getUpdateState())) {
                    log.debug("[{}] Attempt to restore the update state: {}", (Object)client.getEndpoint(), swInfo.getUpdateState());
                    this.executeSwUninstallForUpdate(client);
                } else if (StringUtils.isNotEmpty((String)swInfo.getTargetUrl())) {
                    log.debug("[{}] Starting update to [{}{}] using URL: {}", new Object[]{client.getEndpoint(), swInfo.getTargetName(), swInfo.getTargetVersion(), swInfo.getTargetUrl()});
                    this.startUpdateUsingUrl(client, SW_PACKAGE_URI_ID, swInfo.getTargetUrl());
                } else {
                    log.debug("[{}] Starting update to [{}{}] using binary", new Object[]{client.getEndpoint(), swInfo.getTargetName(), swInfo.getTargetVersion()});
                    this.startUpdateUsingBinary(client, swInfo);
                }
            }
        }
        catch (Exception e) {
            log.info("[{}] failed to update client: {}", new Object[]{client.getEndpoint(), swInfo, e});
            this.sendStateUpdateToTelemetry(client, swInfo, OtaPackageUpdateStatus.FAILED, "Internal server error: " + e.getMessage());
        }
    }

    public void startUpdateUsingBinary(final LwM2mClient client, final LwM2MClientSwOtaInfo swInfo) {
        this.transportService.process(client.getSession(), this.createOtaPackageRequestMsg(client.getSession(), swInfo.getType().name()), (TransportServiceCallback)new TransportServiceCallback<TransportProtos.GetOtaPackageResponseMsg>(){

            public void onSuccess(TransportProtos.GetOtaPackageResponseMsg response) {
                DefaultLwM2MOtaUpdateService.this.executor.submit(() -> DefaultLwM2MOtaUpdateService.this.doUpdateSoftwareUsingBinary(response, swInfo, client));
            }

            public void onError(Throwable e) {
                DefaultLwM2MOtaUpdateService.this.logService.log(client, "Failed to process software update: " + e.getMessage());
            }
        });
    }

    private void startUpdateUsingUrl(LwM2mClient client, String id, String url) {
        String targetIdVer = LwM2mTransportUtil.convertObjectIdToVersionedId(id, client.getRegistration());
        TbLwM2MWriteReplaceRequest request = TbLwM2MWriteReplaceRequest.builder().versionedId(targetIdVer).value(url).timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendWriteReplaceRequest(client, request, new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, client, targetIdVer));
    }

    public void startUpdateUsingBinary(final LwM2mClient client, final LwM2MClientFwOtaInfo fwInfo) {
        this.transportService.process(client.getSession(), this.createOtaPackageRequestMsg(client.getSession(), fwInfo.getType().name()), (TransportServiceCallback)new TransportServiceCallback<TransportProtos.GetOtaPackageResponseMsg>(){

            public void onSuccess(TransportProtos.GetOtaPackageResponseMsg response) {
                DefaultLwM2MOtaUpdateService.this.executor.submit(() -> DefaultLwM2MOtaUpdateService.this.doUpdateFirmwareUsingBinary(response, fwInfo, client));
            }

            public void onError(Throwable e) {
                DefaultLwM2MOtaUpdateService.this.logService.log(client, "Failed to process firmware update: " + e.getMessage());
            }
        });
    }

    private void doUpdateFirmwareUsingBinary(TransportProtos.GetOtaPackageResponseMsg response, LwM2MClientFwOtaInfo info, LwM2mClient client) {
        if (TransportProtos.ResponseStatus.SUCCESS.equals((Object)response.getResponseStatus())) {
            UUID otaPackageId = new UUID(response.getOtaPackageIdMSB(), response.getOtaPackageIdLSB());
            LwM2MFirmwareUpdateStrategy strategy = info.getDeliveryMethod() == null || info.getDeliveryMethod() == FirmwareDeliveryMethod.BOTH.code ? (LwM2MFirmwareUpdateStrategy)((Object)info.getStrategy()) : (info.getDeliveryMethod() == FirmwareDeliveryMethod.PULL.code ? LwM2MFirmwareUpdateStrategy.OBJ_5_TEMP_URL : LwM2MFirmwareUpdateStrategy.OBJ_5_BINARY);
            switch (strategy) {
                case OBJ_5_BINARY: {
                    this.startUpdateUsingBinary(client, LwM2mTransportUtil.convertObjectIdToVersionedId(FW_PACKAGE_5_ID, client.getRegistration()), otaPackageId);
                    break;
                }
                case OBJ_19_BINARY: {
                    this.startUpdateUsingBinary(client, LwM2mTransportUtil.convertObjectIdToVersionedId(FW_PACKAGE_19_ID, client.getRegistration()), otaPackageId);
                    break;
                }
                case OBJ_5_TEMP_URL: {
                    this.startUpdateUsingUrl(client, FW_URL_ID, info.getBaseUrl() + "/tbfw/" + otaPackageId.toString());
                    break;
                }
                default: {
                    this.sendStateUpdateToTelemetry(client, info, OtaPackageUpdateStatus.FAILED, "Unsupported strategy: " + strategy.name());
                    break;
                }
            }
        } else {
            this.sendStateUpdateToTelemetry(client, info, OtaPackageUpdateStatus.FAILED, "Failed to fetch OTA package: " + response.getResponseStatus());
        }
    }

    private void doUpdateSoftwareUsingBinary(TransportProtos.GetOtaPackageResponseMsg response, LwM2MClientSwOtaInfo info, LwM2mClient client) {
        if (TransportProtos.ResponseStatus.SUCCESS.equals((Object)response.getResponseStatus())) {
            UUID otaPackageId = new UUID(response.getOtaPackageIdMSB(), response.getOtaPackageIdLSB());
            LwM2MSoftwareUpdateStrategy strategy = (LwM2MSoftwareUpdateStrategy)((Object)info.getStrategy());
            switch (strategy) {
                case BINARY: {
                    this.startUpdateUsingBinary(client, LwM2mTransportUtil.convertObjectIdToVersionedId(SW_PACKAGE_ID, client.getRegistration()), otaPackageId);
                    break;
                }
                case TEMP_URL: {
                    this.startUpdateUsingUrl(client, SW_PACKAGE_URI_ID, info.getBaseUrl() + "/tbfw/" + otaPackageId.toString());
                    break;
                }
                default: {
                    this.sendStateUpdateToTelemetry(client, info, OtaPackageUpdateStatus.FAILED, "Unsupported strategy: " + strategy.name());
                    break;
                }
            }
        } else {
            this.sendStateUpdateToTelemetry(client, info, OtaPackageUpdateStatus.FAILED, "Failed to fetch OTA package: " + response.getResponseStatus());
        }
    }

    private void startUpdateUsingBinary(LwM2mClient client, String versionedId, UUID otaPackageId) {
        byte[] firmwareChunk = this.otaPackageDataCache.get(otaPackageId.toString(), 0, 0);
        TbLwM2MWriteReplaceRequest writeRequest = TbLwM2MWriteReplaceRequest.builder().versionedId(versionedId).value(firmwareChunk).contentFormat(ContentFormat.OPAQUE).timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendWriteReplaceRequest(client, writeRequest, new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, client, versionedId));
    }

    private TransportProtos.GetOtaPackageRequestMsg createOtaPackageRequestMsg(TransportProtos.SessionInfoProto sessionInfo, String nameFwSW) {
        return TransportProtos.GetOtaPackageRequestMsg.newBuilder().setDeviceIdMSB(sessionInfo.getDeviceIdMSB()).setDeviceIdLSB(sessionInfo.getDeviceIdLSB()).setTenantIdMSB(sessionInfo.getTenantIdMSB()).setTenantIdLSB(sessionInfo.getTenantIdLSB()).setType(nameFwSW).build();
    }

    private void executeFwUpdate(LwM2mClient client) {
        TbLwM2MExecuteRequest request = TbLwM2MExecuteRequest.builder().versionedId(FW_EXECUTE_ID).timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendExecuteRequest(client, request, new TbLwM2MExecuteCallback(this.logService, client, FW_EXECUTE_ID));
    }

    private void executeSwInstall(LwM2mClient client) {
        TbLwM2MExecuteRequest request = TbLwM2MExecuteRequest.builder().versionedId(SW_INSTALL_ID).timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendExecuteRequest(client, request, new TbLwM2MExecuteCallback(this.logService, client, SW_INSTALL_ID));
    }

    private void executeSwUninstallForUpdate(LwM2mClient client) {
        TbLwM2MExecuteRequest request = TbLwM2MExecuteRequest.builder().versionedId(SW_UN_INSTALL_ID).params("1").timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendExecuteRequest(client, request, new TbLwM2MExecuteCallback(this.logService, client, SW_INSTALL_ID));
    }

    private Optional<String> getAttributeValue(List<TransportProtos.TsKvProto> attrs, String keyName) {
        for (TransportProtos.TsKvProto attr : attrs) {
            if (!keyName.equals(attr.getKv().getKey())) continue;
            if (attr.getKv().getType().equals((Object)TransportProtos.KeyValueType.STRING_V)) {
                return Optional.of(attr.getKv().getStringV());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private LwM2MClientFwOtaInfo getOrInitFwInfo(LwM2mClient client) {
        return this.fwStates.computeIfAbsent(client.getEndpoint(), endpoint -> {
            LwM2MClientFwOtaInfo info = this.otaInfoStore.getFw((String)endpoint);
            if (info == null) {
                Lwm2mDeviceProfileTransportConfiguration profile = this.clientContext.getProfile(client.getProfileId());
                info = new LwM2MClientFwOtaInfo((String)endpoint, profile.getClientLwM2mSettings().getFwUpdateResource(), LwM2MFirmwareUpdateStrategy.fromStrategyFwByCode(profile.getClientLwM2mSettings().getFwUpdateStrategy()));
                this.update(info);
            }
            return info;
        });
    }

    private LwM2MClientSwOtaInfo getOrInitSwInfo(LwM2mClient client) {
        return this.swStates.computeIfAbsent(client.getEndpoint(), endpoint -> {
            LwM2MClientSwOtaInfo info = this.otaInfoStore.getSw((String)endpoint);
            if (info == null) {
                Lwm2mDeviceProfileTransportConfiguration profile = this.clientContext.getProfile(client.getProfileId());
                info = new LwM2MClientSwOtaInfo((String)endpoint, profile.getClientLwM2mSettings().getSwUpdateResource(), LwM2MSoftwareUpdateStrategy.fromStrategySwByCode(profile.getClientLwM2mSettings().getSwUpdateStrategy()));
                this.update(info);
            }
            return info;
        });
    }

    private void update(LwM2MClientFwOtaInfo info) {
        this.otaInfoStore.putFw(info);
    }

    private void update(LwM2MClientSwOtaInfo info) {
        this.otaInfoStore.putSw(info);
    }

    private void sendStateUpdateToTelemetry(LwM2mClient client, LwM2MClientOtaInfo<?, ?, ?> fwInfo, OtaPackageUpdateStatus status, String log) {
        ArrayList<TransportProtos.KeyValueProto> result = new ArrayList<TransportProtos.KeyValueProto>();
        TransportProtos.KeyValueProto.Builder kvProto = TransportProtos.KeyValueProto.newBuilder().setKey(OtaPackageUtil.getAttributeKey((OtaPackageType)fwInfo.getType(), (OtaPackageKey)OtaPackageKey.STATE));
        kvProto.setType(TransportProtos.KeyValueType.STRING_V).setStringV(status.name());
        result.add(kvProto.build());
        kvProto = TransportProtos.KeyValueProto.newBuilder().setKey("transportLog");
        kvProto.setType(TransportProtos.KeyValueType.STRING_V).setStringV(log);
        result.add(kvProto.build());
        this.helper.sendParametersOnThingsboardTelemetry(result, client.getSession(), client.getKeyTsLatestMap());
    }

    private static Optional<OtaPackageUpdateStatus> toOtaPackageUpdateStatus(FirmwareUpdateResult fwUpdateResult) {
        switch (fwUpdateResult) {
            case INITIAL: {
                return Optional.empty();
            }
            case UPDATE_SUCCESSFULLY: {
                return Optional.of(OtaPackageUpdateStatus.UPDATED);
            }
            case NOT_ENOUGH: 
            case OUT_OFF_MEMORY: 
            case CONNECTION_LOST: 
            case INTEGRITY_CHECK_FAILURE: 
            case UNSUPPORTED_TYPE: 
            case INVALID_URI: 
            case UPDATE_FAILED: 
            case UNSUPPORTED_PROTOCOL: {
                return Optional.of(OtaPackageUpdateStatus.FAILED);
            }
        }
        throw new CodecException("Invalid value stateFw %s for FirmwareUpdateStatus.", new Object[]{fwUpdateResult.name()});
    }

    private static Optional<OtaPackageUpdateStatus> toOtaPackageUpdateStatus(FirmwareUpdateState firmwareUpdateState) {
        switch (firmwareUpdateState) {
            case IDLE: {
                return Optional.empty();
            }
            case DOWNLOADING: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADING);
            }
            case DOWNLOADED: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADED);
            }
            case UPDATING: {
                return Optional.of(OtaPackageUpdateStatus.UPDATING);
            }
        }
        throw new CodecException("Invalid value stateFw %d for FirmwareUpdateStatus.", new Object[]{firmwareUpdateState});
    }

    private static Optional<OtaPackageUpdateStatus> toOtaPackageUpdateStatus(SoftwareUpdateState swUpdateState) {
        switch (swUpdateState) {
            case INITIAL: {
                return Optional.empty();
            }
            case DOWNLOAD_STARTED: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADING);
            }
            case DOWNLOADED: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADING);
            }
            case DELIVERED: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADED);
            }
            case INSTALLED: {
                return Optional.empty();
            }
        }
        throw new CodecException("Invalid value stateSw %d for SoftwareUpdateState.", new Object[]{swUpdateState});
    }

    public static Optional<OtaPackageUpdateStatus> toOtaPackageUpdateStatus(SoftwareUpdateResult softwareUpdateResult) {
        switch (softwareUpdateResult) {
            case INITIAL: {
                return Optional.empty();
            }
            case DOWNLOADING: {
                return Optional.of(OtaPackageUpdateStatus.DOWNLOADING);
            }
            case SUCCESSFULLY_INSTALLED: {
                return Optional.of(OtaPackageUpdateStatus.UPDATED);
            }
            case SUCCESSFULLY_DOWNLOADED_VERIFIED: {
                return Optional.of(OtaPackageUpdateStatus.VERIFIED);
            }
            case NOT_ENOUGH_STORAGE: 
            case OUT_OFF_MEMORY: 
            case CONNECTION_LOST: 
            case PACKAGE_CHECK_FAILURE: 
            case UNSUPPORTED_PACKAGE_TYPE: 
            case INVALID_URI: 
            case UPDATE_ERROR: 
            case INSTALL_FAILURE: 
            case UN_INSTALL_FAILURE: {
                return Optional.of(OtaPackageUpdateStatus.FAILED);
            }
        }
        throw new CodecException("Invalid value stateFw %s for FirmwareUpdateStatus.", new Object[]{softwareUpdateResult.name()});
    }

    @ConstructorProperties(value={"transportService", "clientContext", "config", "uplinkHandler", "downlinkHandler", "otaPackageDataCache", "logService", "helper", "otaInfoStore"})
    public DefaultLwM2MOtaUpdateService(TransportService transportService, LwM2mClientContext clientContext, LwM2MTransportServerConfig config, LwM2mUplinkMsgHandler uplinkHandler, LwM2mDownlinkMsgHandler downlinkHandler, OtaPackageDataCache otaPackageDataCache, LwM2MTelemetryLogService logService, LwM2mTransportServerHelper helper, TbLwM2MClientOtaInfoStore otaInfoStore) {
        this.transportService = transportService;
        this.clientContext = clientContext;
        this.config = config;
        this.uplinkHandler = uplinkHandler;
        this.downlinkHandler = downlinkHandler;
        this.otaPackageDataCache = otaPackageDataCache;
        this.logService = logService;
        this.helper = helper;
        this.otaInfoStore = otaInfoStore;
    }
}

