/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.log;

import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MTelemetryLogService
implements LwM2MTelemetryLogService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MTelemetryLogService.class);
    private final LwM2mTransportServerHelper helper;

    @Override
    public void log(LwM2mClient client, String logMsg) {
        if (logMsg != null && client != null && client.getSession() != null) {
            if (logMsg.length() > 1024) {
                logMsg = logMsg.substring(0, 1024);
            }
            this.helper.sendParametersOnThingsboardTelemetry(this.helper.getKvStringtoThingsboard("transportLog", logMsg), client.getSession(), client.getKeyTsLatestMap());
        }
    }

    @ConstructorProperties(value={"helper"})
    public DefaultLwM2MTelemetryLogService(LwM2mTransportServerHelper helper) {
        this.helper = helper;
    }
}

