/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink.composite;

import java.util.Arrays;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.thingsboard.server.transport.lwm2m.server.LwM2mOperationType;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasContentFormat;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.AbstractTbLwM2MTargetedDownlinkCompositeRequest;

public class TbLwM2MReadCompositeRequest
extends AbstractTbLwM2MTargetedDownlinkCompositeRequest<ReadCompositeResponse>
implements HasContentFormat {
    private final ContentFormat requestContentFormat;
    private final ContentFormat responseContentFormat;

    private TbLwM2MReadCompositeRequest(String[] versionedIds, long timeout, ContentFormat requestContentFormat, ContentFormat responseContentFormat) {
        super(versionedIds, timeout);
        this.requestContentFormat = requestContentFormat;
        this.responseContentFormat = responseContentFormat;
    }

    @Override
    public LwM2mOperationType getType() {
        return LwM2mOperationType.READ_COMPOSITE;
    }

    public static TbLwM2MReadCompositeRequestBuilder builder() {
        return new TbLwM2MReadCompositeRequestBuilder();
    }

    @Override
    public ContentFormat getRequestContentFormat() {
        return this.requestContentFormat;
    }

    @Override
    public ContentFormat getResponseContentFormat() {
        return this.responseContentFormat;
    }

    public static class TbLwM2MReadCompositeRequestBuilder {
        private String[] versionedIds;
        private long timeout;
        private ContentFormat requestContentFormat;
        private ContentFormat responseContentFormat;

        TbLwM2MReadCompositeRequestBuilder() {
        }

        public TbLwM2MReadCompositeRequestBuilder versionedIds(String[] versionedIds) {
            this.versionedIds = versionedIds;
            return this;
        }

        public TbLwM2MReadCompositeRequestBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public TbLwM2MReadCompositeRequestBuilder requestContentFormat(ContentFormat requestContentFormat) {
            this.requestContentFormat = requestContentFormat;
            return this;
        }

        public TbLwM2MReadCompositeRequestBuilder responseContentFormat(ContentFormat responseContentFormat) {
            this.responseContentFormat = responseContentFormat;
            return this;
        }

        public TbLwM2MReadCompositeRequest build() {
            return new TbLwM2MReadCompositeRequest(this.versionedIds, this.timeout, this.requestContentFormat, this.responseContentFormat);
        }

        public String toString() {
            return "TbLwM2MReadCompositeRequest.TbLwM2MReadCompositeRequestBuilder(versionedIds=" + Arrays.deepToString(this.versionedIds) + ", timeout=" + this.timeout + ", requestContentFormat=" + this.requestContentFormat + ", responseContentFormat=" + this.responseContentFormat + ")";
        }
    }
}

