/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.downlink.AbstractTbLwM2MRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;

public abstract class TbLwM2MTargetedCallback<R, T>
extends AbstractTbLwM2MRequestCallback<R, T> {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MTargetedCallback.class);
    protected final String versionedId;
    protected final String[] versionedIds;

    public TbLwM2MTargetedCallback(LwM2MTelemetryLogService logService, LwM2mClient client, String versionedId) {
        super(logService, client);
        this.versionedId = versionedId;
        this.versionedIds = null;
    }

    public TbLwM2MTargetedCallback(LwM2MTelemetryLogService logService, LwM2mClient client, String[] versionedIds) {
        super(logService, client);
        this.versionedId = null;
        this.versionedIds = versionedIds;
    }

    @Override
    public void onSuccess(R request, T response) {
        String requestName = request.getClass().getSimpleName();
        log.trace("[{}] {} [{}] successful: {}", new Object[]{this.client.getEndpoint(), requestName, this.versionedId != null ? this.versionedId : this.versionedIds, response});
        this.logService.log(this.client, String.format("[%s]: %s [%s] successful. Result: [%s]", "info", requestName, this.versionedId != null ? this.versionedId : Arrays.toString(this.versionedIds), response));
    }
}

