/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.downlink.AbstractTbLwM2MRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;

public class TbLwM2MCancelObserveCallback
extends AbstractTbLwM2MRequestCallback<TbLwM2MCancelObserveRequest, Integer> {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MCancelObserveCallback.class);
    private final String versionedId;

    public TbLwM2MCancelObserveCallback(LwM2MTelemetryLogService logService, LwM2mClient client, String versionedId) {
        super(logService, client);
        this.versionedId = versionedId;
    }

    @Override
    public void onSuccess(TbLwM2MCancelObserveRequest request, Integer canceledSubscriptionsCount) {
        log.trace("[{}] Cancel observation of [{}] successful: {}", new Object[]{this.client.getEndpoint(), this.versionedId, canceledSubscriptionsCount});
        this.logService.log(this.client, String.format("[%s]: Cancel Observe for [%s] successful. Result: [%s]", "info", this.versionedId, canceledSubscriptionsCount));
    }
}

