/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.attributes.Attribute;
import org.eclipse.leshan.core.attributes.AttributeSet;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.ObjectLink;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.request.CompositeDownlinkRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.SimpleDownlinkRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.ClientSleepingException;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.device.data.lwm2m.ObjectAttributes;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.common.LwM2MExecutorAwareService;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasContentFormat;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasVersionedId;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasVersionedIds;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDeleteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteUpdateRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.TbLwM2MReadCompositeRequest;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.rpc.composite.RpcWriteCompositeRequest;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2mDownlinkMsgHandler
extends LwM2MExecutorAwareService
implements LwM2mDownlinkMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2mDownlinkMsgHandler.class);
    public LwM2mValueConverterImpl converter;
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;
    private final LwM2MTelemetryLogService logService;
    private final LwM2mClientContext clientContext;

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.converter = LwM2mValueConverterImpl.getInstance();
    }

    @Override
    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    @Override
    protected int getExecutorSize() {
        return this.config.getDownlinkPoolSize();
    }

    @Override
    protected String getExecutorName() {
        return "LwM2M Downlink";
    }

    @Override
    public void sendReadRequest(LwM2mClient client, TbLwM2MReadRequest request, DownlinkRequestCallback<ReadRequest, ReadResponse> callback) {
        this.validateVersionedId(client, request);
        ReadRequest downlink = new ReadRequest(DefaultLwM2mDownlinkMsgHandler.getRequestContentFormat(client, request, this.config.getModelProvider()), request.getObjectId());
        this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
    }

    @Override
    public void sendReadCompositeRequest(LwM2mClient client, TbLwM2MReadCompositeRequest request, DownlinkRequestCallback<ReadCompositeRequest, ReadCompositeResponse> callback) {
        this.validateVersionedIds(client, request);
        ContentFormat requestContentFormat = ContentFormat.SENML_JSON;
        ContentFormat responseContentFormat = ContentFormat.SENML_JSON;
        ReadCompositeRequest downlink = new ReadCompositeRequest(requestContentFormat, responseContentFormat, request.getObjectIds());
        this.sendCompositeRequest(client, downlink, request.getTimeout(), callback);
    }

    @Override
    public void sendObserveRequest(LwM2mClient client, TbLwM2MObserveRequest request, DownlinkRequestCallback<ObserveRequest, ObserveResponse> callback) {
        this.validateVersionedId(client, request);
        LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
        Set observations = this.context.getServer().getObservationService().getObservations(client.getRegistration());
        if (observations.stream().noneMatch(observation -> observation.getPath().equals((Object)resultIds))) {
            ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.getRequestContentFormat(client, request, this.config.getModelProvider());
            ObserveRequest downlink = resultIds.isResource() ? new ObserveRequest(contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resultIds.getResourceId().intValue()) : (resultIds.isObjectInstance() ? new ObserveRequest(contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue()) : new ObserveRequest(contentFormat, resultIds.getObjectId().intValue()));
            log.info("[{}] Send observation: {}.", (Object)client.getEndpoint(), (Object)request.getVersionedId());
            this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
        } else {
            callback.onValidationError(resultIds.toString(), "Observation is already registered!");
        }
    }

    @Override
    public void sendObserveAllRequest(LwM2mClient client, TbLwM2MObserveAllRequest request, DownlinkRequestCallback<TbLwM2MObserveAllRequest, Set<String>> callback) {
        Set observations = this.context.getServer().getObservationService().getObservations(client.getRegistration());
        Set paths = observations.stream().map(observation -> observation.getPath().toString()).collect(Collectors.toUnmodifiableSet());
        callback.onSuccess(request, paths);
    }

    @Override
    public void sendDiscoverAllRequest(LwM2mClient client, TbLwM2MDiscoverAllRequest request, DownlinkRequestCallback<TbLwM2MDiscoverAllRequest, List<Link>> callback) {
        callback.onSuccess(request, Arrays.asList(client.getRegistration().getSortedObjectLinks()));
    }

    @Override
    public void sendExecuteRequest(LwM2mClient client, TbLwM2MExecuteRequest request, DownlinkRequestCallback<ExecuteRequest, ExecuteResponse> callback) {
        ResourceModel resourceModelExecute = client.getResourceModel(request.getVersionedId(), this.config.getModelProvider());
        if (resourceModelExecute != null) {
            ExecuteRequest downlink = request.getParams() != null && resourceModelExecute.multiple == false ? new ExecuteRequest(request.getVersionedId(), (String)this.converter.convertValue(request.getParams(), resourceModelExecute.type, ResourceModel.Type.STRING, new LwM2mPath(request.getObjectId()))) : new ExecuteRequest(request.getVersionedId());
            this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
        }
    }

    @Override
    public void sendDeleteRequest(LwM2mClient client, TbLwM2MDeleteRequest request, DownlinkRequestCallback<DeleteRequest, DeleteResponse> callback) {
        this.sendSimpleRequest(client, new DeleteRequest(request.getObjectId()), request.getTimeout(), callback);
    }

    @Override
    public void sendCancelObserveRequest(LwM2mClient client, TbLwM2MCancelObserveRequest request, DownlinkRequestCallback<TbLwM2MCancelObserveRequest, Integer> callback) {
        int observeCancelCnt = this.context.getServer().getObservationService().cancelObservations(client.getRegistration(), request.getObjectId());
        callback.onSuccess(request, observeCancelCnt);
    }

    @Override
    public void sendCancelAllRequest(LwM2mClient client, TbLwM2MCancelAllRequest request, DownlinkRequestCallback<TbLwM2MCancelAllRequest, Integer> callback) {
        int observeCancelCnt = this.context.getServer().getObservationService().cancelObservations(client.getRegistration());
        callback.onSuccess(request, observeCancelCnt);
    }

    @Override
    public void sendDiscoverRequest(LwM2mClient client, TbLwM2MDiscoverRequest request, DownlinkRequestCallback<DiscoverRequest, DiscoverResponse> callback) {
        this.validateVersionedId(client, request);
        this.sendSimpleRequest(client, new DiscoverRequest(request.getObjectId()), request.getTimeout(), callback);
    }

    @Override
    public void sendWriteAttributesRequest(LwM2mClient client, TbLwM2MWriteAttributesRequest request, DownlinkRequestCallback<WriteAttributesRequest, WriteAttributesResponse> callback) {
        this.validateVersionedId(client, request);
        if (request.getAttributes() == null) {
            throw new IllegalArgumentException("Attributes to write are not specified!");
        }
        ObjectAttributes params = request.getAttributes();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "pmax", params.getPmax());
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "pmin", params.getPmin());
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "gt", params.getGt());
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "lt", params.getLt());
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "st", params.getSt());
        AttributeSet attributeSet = new AttributeSet(attributes);
        this.sendSimpleRequest(client, new WriteAttributesRequest(request.getObjectId(), attributeSet), request.getTimeout(), callback);
    }

    @Override
    public void sendWriteReplaceRequest(LwM2mClient client, TbLwM2MWriteReplaceRequest request, DownlinkRequestCallback<WriteRequest, WriteResponse> callback) {
        ResourceModel resourceModelWrite = client.getResourceModel(request.getVersionedId(), this.config.getModelProvider());
        if (resourceModelWrite != null) {
            ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.convertResourceModelTypeToContentFormat(client, resourceModelWrite.type);
            try {
                LwM2mPath path = new LwM2mPath(request.getObjectId());
                WriteRequest downlink = this.getWriteRequestSingleResource(resourceModelWrite.type, contentFormat, path.getObjectId(), path.getObjectInstanceId(), path.getResourceId(), request.getValue());
                this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
            }
            catch (Exception e) {
                callback.onError(this.toString(request), e);
            }
        } else {
            callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + " is not configured in the device profile!");
        }
    }

    @Override
    public void sendWriteCompositeRequest(LwM2mClient client, RpcWriteCompositeRequest rpcWriteCompositeRequest, DownlinkRequestCallback<WriteCompositeRequest, WriteCompositeResponse> callback) {
        ContentFormat contentFormat = ContentFormat.SENML_JSON;
        try {
            WriteCompositeRequest downlink = new WriteCompositeRequest(contentFormat, rpcWriteCompositeRequest.getNodes());
            this.sendWriteCompositeRequest(client, downlink, this.config.getTimeout(), callback);
        }
        catch (Exception e) {
            callback.onError(this.toString(rpcWriteCompositeRequest), e);
        }
    }

    @Override
    public void sendWriteUpdateRequest(LwM2mClient client, TbLwM2MWriteUpdateRequest request, DownlinkRequestCallback<WriteRequest, WriteResponse> callback) {
        LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
        if (resultIds.isResource()) {
            Collection<LwM2mResource> resources = client.getNewResourceForInstance(request.getVersionedId(), request.getValue(), this.config.getModelProvider(), this.converter);
            ResourceModel resourceModelWrite = client.getResourceModel(request.getVersionedId(), this.config.getModelProvider());
            ContentFormat contentFormat = request.getObjectContentFormat() != null ? request.getObjectContentFormat() : DefaultLwM2mDownlinkMsgHandler.convertResourceModelTypeToContentFormat(client, resourceModelWrite.type);
            WriteRequest downlink = new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resources);
            this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
        } else if (resultIds.isObjectInstance()) {
            Collection<LwM2mResource> resources = client.getNewResourcesForInstance(request.getVersionedId(), request.getValue(), this.config.getModelProvider(), this.converter);
            if (resources.size() > 0) {
                ContentFormat contentFormat = request.getObjectContentFormat() != null ? request.getObjectContentFormat() : ContentFormat.DEFAULT;
                WriteRequest downlink = new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resources);
                this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
            } else {
                callback.onValidationError(this.toString(request), "No resources to update!");
            }
        } else {
            callback.onValidationError(this.toString(request), "Update of the root level object is not supported yet!");
        }
    }

    private <R extends SimpleDownlinkRequest<T>, T extends LwM2mResponse> void sendSimpleRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback) {
        this.sendRequest(client, request, timeoutInMs, callback, r -> request.getPath().toString());
    }

    private <R extends CompositeDownlinkRequest<T>, T extends LwM2mResponse> void sendCompositeRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback) {
        this.sendRequest(client, request, timeoutInMs, callback, r -> request.getPaths().toString());
    }

    private <R extends DownlinkRequest<T>, T extends LwM2mResponse> void sendRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback, Function<R, String> pathToStringFunction) {
        if (!this.clientContext.isDownlinkAllowed(client)) {
            log.trace("[{}] ignore downlink request cause client is sleeping.", (Object)client.getEndpoint());
            return;
        }
        Registration registration = client.getRegistration();
        try {
            this.logService.log(client, String.format("[%s][%s] Sending request: %s to %s", registration.getId(), registration.getSocketAddress(), request.getClass().getSimpleName(), pathToStringFunction.apply(request)));
            this.context.getServer().send(registration, request, timeoutInMs, response -> this.executor.submit(() -> {
                try {
                    callback.onSuccess(request, response);
                }
                catch (Exception e) {
                    log.error("[{}] failed to process successful response [{}] ", new Object[]{registration.getEndpoint(), response, e});
                }
                finally {
                    this.clientContext.awake(client);
                }
            }), e -> this.handleDownlinkError(client, request, callback, e));
            callback.onSent(request);
        }
        catch (Exception e2) {
            this.handleDownlinkError(client, request, callback, e2);
        }
    }

    private <R extends SimpleDownlinkRequest<T>, T extends LwM2mResponse> void sendWriteCompositeRequest(LwM2mClient client, WriteCompositeRequest request, long timeoutInMs, DownlinkRequestCallback<WriteCompositeRequest, WriteCompositeResponse> callback) {
        if (!this.clientContext.isDownlinkAllowed(client)) {
            log.trace("[{}] ignore downlink request cause client is sleeping.", (Object)client.getEndpoint());
            return;
        }
        Registration registration = client.getRegistration();
        try {
            this.logService.log(client, String.format("[%s][%s] Sending request: %s to %s", registration.getId(), registration.getSocketAddress(), request.getClass().getSimpleName(), request.getPaths()));
            this.context.getServer().send(registration, (DownlinkRequest)request, timeoutInMs, response -> this.executor.submit(() -> {
                try {
                    if (response.isSuccess()) {
                        callback.onSuccess(request, (WriteCompositeResponse)response);
                    } else {
                        callback.onValidationError(request.getNodes().values().toString(), response.getErrorMessage());
                    }
                }
                catch (Exception e) {
                    log.error("[{}] failed to process successful response [{}] ", new Object[]{registration.getEndpoint(), response, e});
                }
                finally {
                    this.clientContext.awake(client);
                }
            }), e -> this.handleDownlinkError(client, request, callback, e));
        }
        catch (Exception e2) {
            this.handleDownlinkError(client, request, callback, e2);
        }
    }

    private <R extends DownlinkRequest<T>, T extends LwM2mResponse> void handleDownlinkError(LwM2mClient client, R request, DownlinkRequestCallback<R, T> callback, Exception e) {
        log.trace("[{}] Received downlink error: {}.", (Object)client.getEndpoint(), (Object)e);
        this.executor.submit(() -> {
            if (e instanceof TimeoutException || e instanceof ClientSleepingException) {
                log.trace("[{}] Received {}, client is probably sleeping", (Object)client.getEndpoint(), (Object)e.getClass().getSimpleName());
                this.clientContext.asleep(client);
            } else {
                log.trace("[{}] Received {}", (Object)client.getEndpoint(), (Object)e.getClass().getSimpleName());
            }
            callback.onError(this.toString(request), e);
        });
    }

    private WriteRequest getWriteRequestSingleResource(ResourceModel.Type type, ContentFormat contentFormat, int objectId, int instanceId, int resourceId, Object value) {
        switch (type) {
            case STRING: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, value.toString());
            }
            case INTEGER: {
                long valueInt = Integer.toUnsignedLong(Integer.parseInt(value.toString()));
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, valueInt);
            }
            case OBJLNK: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, ObjectLink.fromPath((String)value.toString()));
            }
            case BOOLEAN: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, Boolean.parseBoolean(value.toString()));
            }
            case FLOAT: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, Double.parseDouble(value.toString()));
            }
            case TIME: {
                Date date = new Date(Long.decode(value.toString()));
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, date);
            }
            case OPAQUE: {
                byte[] valueRequest = value instanceof byte[] ? (byte[])value : Hex.decodeHex((char[])value.toString().toCharArray());
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, valueRequest);
            }
        }
        throw new IllegalArgumentException("Not supported type:" + type.name());
    }

    private void validateVersionedId(LwM2mClient client, HasVersionedId request) {
        client.isValidObjectVersion(request.getVersionedId());
        if (request.getObjectId() == null) {
            throw new IllegalArgumentException("Specified object id is null!");
        }
    }

    private void validateVersionedIds(LwM2mClient client, HasVersionedIds request) {
        for (String versionedId : request.getVersionedIds()) {
            client.isValidObjectVersion(versionedId);
        }
        for (String objectId : request.getObjectIds()) {
            if (objectId != null) continue;
            throw new IllegalArgumentException("Specified object id is null!");
        }
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value) {
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, attributeName, value, null, null);
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value, Function<T, ?> converter) {
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, attributeName, value, null, converter);
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value, Predicate<T> filter, Function<T, ?> converter) {
        if (value != null && (filter == null || filter.test(value))) {
            attributes.add(new Attribute(attributeName, converter != null ? converter.apply(value) : value));
        }
    }

    private static ContentFormat convertResourceModelTypeToContentFormat(LwM2mClient client, ResourceModel.Type type) {
        switch (type) {
            case STRING: 
            case INTEGER: 
            case BOOLEAN: 
            case FLOAT: 
            case TIME: {
                return client.getDefaultContentFormat();
            }
            case OPAQUE: {
                return ContentFormat.OPAQUE;
            }
            case OBJLNK: {
                return ContentFormat.LINK;
            }
        }
        throw new CodecException("Invalid ResourceModel_Type for %s ContentFormat.", new Object[]{type});
    }

    private static ContentFormat getRequestContentFormat(LwM2mClient client, HasContentFormat request, LwM2mModelProvider modelProvider) {
        if (request.getRequestContentFormat() != null) {
            return request.getRequestContentFormat();
        }
        String versionedId = null;
        if (request instanceof TbLwM2MReadRequest) {
            versionedId = ((TbLwM2MReadRequest)request).getVersionedId();
        } else if (request instanceof TbLwM2MObserveRequest) {
            versionedId = ((TbLwM2MObserveRequest)request).getVersionedId();
        }
        String id = LwM2mTransportUtil.fromVersionedIdToObjectId(versionedId);
        if (id != null && new LwM2mPath(id).isResource() && !client.isResourceMultiInstances(versionedId, modelProvider)) {
            return client.getDefaultContentFormat();
        }
        return ContentFormat.DEFAULT;
    }

    private <R> String toString(R request) {
        try {
            return JacksonUtil.toString(request);
        }
        catch (Exception e) {
            try {
                return request.toString();
            }
            catch (Exception e2) {
                log.warn("Failed to convert request to string", (Throwable)e2);
                return request != null ? request.getClass().getSimpleName() : "";
            }
        }
    }

    @ConstructorProperties(value={"context", "config", "logService", "clientContext"})
    public DefaultLwM2mDownlinkMsgHandler(LwM2mTransportContext context, LwM2MTransportServerConfig config, LwM2MTelemetryLogService logService, LwM2mClientContext clientContext) {
        this.context = context;
        this.config = config;
        this.logService = logService;
        this.clientContext = clientContext;
    }
}

