/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;

public abstract class AbstractTbLwM2MRequestCallback<R, T>
implements DownlinkRequestCallback<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTbLwM2MRequestCallback.class);
    protected final LwM2MTelemetryLogService logService;
    protected final LwM2mClient client;

    protected AbstractTbLwM2MRequestCallback(LwM2MTelemetryLogService logService, LwM2mClient client) {
        this.logService = logService;
        this.client = client;
    }

    @Override
    public void onValidationError(String params, String msg) {
        log.trace("[{}] Request [{}] validation failed. Reason: {}", new Object[]{this.client.getEndpoint(), params, msg});
        this.logService.log(this.client, String.format("[%s]: Request [%s] validation failed. Reason: %s", "warn", params, msg));
    }

    @Override
    public void onError(String params, Exception e) {
        log.trace("[{}] Request [{}] processing failed", new Object[]{this.client.getEndpoint(), params, e});
        this.logService.log(this.client, String.format("[%s]: Request [%s] processing failed. Reason: %s", "warn", params, e));
    }
}

