/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.client;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mResourceInstance;
import org.thingsboard.server.transport.lwm2m.server.client.TbLwM2MMultipleResource;
import org.thingsboard.server.transport.lwm2m.server.client.TbLwM2MResource;
import org.thingsboard.server.transport.lwm2m.server.client.TbLwM2MResourceInstance;
import org.thingsboard.server.transport.lwm2m.server.client.TbLwM2MSingleResource;
import org.thingsboard.server.transport.lwm2m.server.client.TbResourceModel;

public class ResourceValue
implements Serializable {
    private static final long serialVersionUID = -228268906779089402L;
    private TbLwM2MResource lwM2mResource;
    private TbResourceModel resourceModel;

    public ResourceValue(LwM2mResource lwM2mResource, ResourceModel resourceModel) {
        this.lwM2mResource = ResourceValue.toTbLwM2MResource(lwM2mResource);
        this.resourceModel = ResourceValue.toTbResourceModel(resourceModel);
    }

    public void setLwM2mResource(LwM2mResource lwM2mResource) {
        this.lwM2mResource = ResourceValue.toTbLwM2MResource(lwM2mResource);
    }

    public void setResourceModel(ResourceModel resourceModel) {
        this.resourceModel = ResourceValue.toTbResourceModel(resourceModel);
    }

    private static TbLwM2MResource toTbLwM2MResource(LwM2mResource lwM2mResource) {
        if (lwM2mResource.isMultiInstances()) {
            if (lwM2mResource.getInstances().values().size() > 0) {
                TbLwM2MResourceInstance[] instances = lwM2mResource.getInstances().values().stream().map(ResourceValue::toTbLwM2MResourceInstance).collect(Collectors.toSet()).toArray(new TbLwM2MResourceInstance[0]);
                return new TbLwM2MMultipleResource(lwM2mResource.getId(), lwM2mResource.getType(), instances);
            }
            return new TbLwM2MMultipleResource(lwM2mResource.getId(), lwM2mResource.getType(), new TbLwM2MResourceInstance[0]);
        }
        return new TbLwM2MSingleResource(lwM2mResource.getId(), lwM2mResource.getValue(), lwM2mResource.getType());
    }

    private static TbLwM2MResourceInstance toTbLwM2MResourceInstance(LwM2mResourceInstance instance) {
        return new TbLwM2MResourceInstance(instance.getId(), instance.getValue(), instance.getType());
    }

    private static TbResourceModel toTbResourceModel(ResourceModel resourceModel) {
        return new TbResourceModel(resourceModel.id, resourceModel.name, resourceModel.operations, resourceModel.multiple, resourceModel.mandatory, resourceModel.type, resourceModel.rangeEnumeration, resourceModel.units, resourceModel.description);
    }

    public TbLwM2MResource getLwM2mResource() {
        return this.lwM2mResource;
    }

    public TbResourceModel getResourceModel() {
        return this.resourceModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceValue)) {
            return false;
        }
        ResourceValue other = (ResourceValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TbLwM2MResource this$lwM2mResource = this.getLwM2mResource();
        TbLwM2MResource other$lwM2mResource = other.getLwM2mResource();
        if (this$lwM2mResource == null ? other$lwM2mResource != null : !this$lwM2mResource.equals(other$lwM2mResource)) {
            return false;
        }
        TbResourceModel this$resourceModel = this.getResourceModel();
        TbResourceModel other$resourceModel = other.getResourceModel();
        return !(this$resourceModel == null ? other$resourceModel != null : !this$resourceModel.equals(other$resourceModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbLwM2MResource $lwM2mResource = this.getLwM2mResource();
        result = result * 59 + ($lwM2mResource == null ? 43 : $lwM2mResource.hashCode());
        TbResourceModel $resourceModel = this.getResourceModel();
        result = result * 59 + ($resourceModel == null ? 43 : $resourceModel.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceValue(lwM2mResource=" + this.getLwM2mResource() + ", resourceModel=" + this.getResourceModel() + ")";
    }
}

