/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.client;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.device.data.lwm2m.OtherConfiguration;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.transport.TransportDeviceProfileCache;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2mVersion;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientState;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientStateException;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.session.LwM2MSessionManager;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbMainSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.DefaultLwM2MUplinkMsgHandler;

@Service
@TbLwM2mTransportComponent
public class LwM2mClientContextImpl
implements LwM2mClientContext {
    private static final Logger log = LoggerFactory.getLogger(LwM2mClientContextImpl.class);
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;
    private final TbMainSecurityStore securityStore;
    private final TbLwM2MClientStore clientStore;
    private final LwM2MSessionManager sessionManager;
    private final TransportDeviceProfileCache deviceProfileCache;
    @Autowired
    @Lazy
    private DefaultLwM2MUplinkMsgHandler defaultLwM2MUplinkMsgHandler;
    @Autowired
    @Lazy
    private LwM2MOtaUpdateService otaUpdateService;
    private final Map<String, LwM2mClient> lwM2mClientsByEndpoint = new ConcurrentHashMap<String, LwM2mClient>();
    private final Map<String, LwM2mClient> lwM2mClientsByRegistrationId = new ConcurrentHashMap<String, LwM2mClient>();
    private final Map<UUID, Lwm2mDeviceProfileTransportConfiguration> profiles = new ConcurrentHashMap<UUID, Lwm2mDeviceProfileTransportConfiguration>();

    @AfterStartUp
    public void init() {
        String nodeId = this.context.getNodeId();
        Set<LwM2mClient> fetchedClients = this.clientStore.getAll();
        log.debug("Fetched clients from store: {}", fetchedClients);
        fetchedClients.forEach(client -> {
            this.lwM2mClientsByEndpoint.put(client.getEndpoint(), (LwM2mClient)client);
            try {
                client.lock();
                this.updateFetchedClient(nodeId, (LwM2mClient)client);
            }
            finally {
                client.unlock();
            }
        });
    }

    @Override
    public LwM2mClient getClientByEndpoint(String endpoint) {
        return this.lwM2mClientsByEndpoint.computeIfAbsent(endpoint, ep -> {
            LwM2mClient client = this.clientStore.get((String)ep);
            String nodeId = this.context.getNodeId();
            if (client == null) {
                log.info("[{}] initialized new client.", (Object)endpoint);
                client = new LwM2mClient(nodeId, (String)ep);
            } else {
                log.debug("[{}] fetched client from store: {}", (Object)endpoint, (Object)client);
                this.updateFetchedClient(nodeId, client);
            }
            return client;
        });
    }

    private void updateFetchedClient(String nodeId, LwM2mClient client) {
        boolean updated = false;
        if (client.getRegistration() != null) {
            this.lwM2mClientsByRegistrationId.put(client.getRegistration().getId(), client);
        }
        if (client.getSession() != null) {
            client.refreshSessionId(nodeId);
            this.sessionManager.register(client.getSession());
            updated = true;
        }
        if (updated) {
            this.clientStore.put(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<TransportProtos.SessionInfoProto> register(LwM2mClient client, Registration registration) throws LwM2MClientStateException {
        client.lock();
        try {
            if (LwM2MClientState.UNREGISTERED.equals((Object)client.getState())) {
                throw new LwM2MClientStateException(client.getState(), "Client is in invalid state.");
            }
            TransportProtos.SessionInfoProto oldSession = client.getSession();
            TbLwM2MSecurityInfo securityInfo = this.securityStore.getTbLwM2MSecurityInfoByEndpoint(client.getEndpoint());
            if (securityInfo.getSecurityMode() == null) throw new RuntimeException(String.format("Registration failed: FORBIDDEN, endpointId: %s", client.getEndpoint()));
            if (SecurityMode.X509.equals((Object)securityInfo.getSecurityMode())) {
                this.securityStore.registerX509(registration.getEndpoint(), registration.getId());
            }
            if (securityInfo.getDeviceProfile() == null) throw new RuntimeException(String.format("Registration failed: device %s not found.", client.getEndpoint()));
            this.profileUpdate(securityInfo.getDeviceProfile());
            if (securityInfo.getSecurityInfo() != null) {
                client.init(securityInfo.getMsg(), UUID.randomUUID());
            } else {
                if (!SecurityMode.NO_SEC.equals((Object)securityInfo.getSecurityMode())) throw new RuntimeException(String.format("Registration failed: device %s not found.", client.getEndpoint()));
                client.init(securityInfo.getMsg(), UUID.randomUUID());
            }
            client.setRegistration(registration);
            this.lwM2mClientsByRegistrationId.put(registration.getId(), client);
            client.setState(LwM2MClientState.REGISTERED);
            this.onUplink(client);
            if (this.compareAndSetSleepFlag(client, false)) return Optional.ofNullable(oldSession);
            this.clientStore.put(client);
            return Optional.ofNullable(oldSession);
        }
        finally {
            client.unlock();
        }
    }

    @Override
    public boolean asleep(LwM2mClient client) {
        boolean changed = this.compareAndSetSleepFlag(client, true);
        if (changed) {
            log.debug("[{}] client is sleeping", (Object)client.getEndpoint());
            this.context.getTransportService().log(client.getSession(), "Info : Client is sleeping!");
        }
        return changed;
    }

    @Override
    public boolean awake(LwM2mClient client) {
        this.onUplink(client);
        boolean changed = this.compareAndSetSleepFlag(client, false);
        if (changed) {
            log.debug("[{}] client is awake", (Object)client.getEndpoint());
            this.context.getTransportService().log(client.getSession(), "Info : Client is awake!");
            this.sendMsgsAfterSleeping(client);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSetSleepFlag(LwM2mClient client, boolean sleeping) {
        if (sleeping == client.isAsleep()) {
            log.trace("[{}] Client is already at sleeping: {}, ignoring event: {}", new Object[]{client.getEndpoint(), client.isAsleep(), sleeping});
            return false;
        }
        client.lock();
        try {
            if (sleeping == client.isAsleep()) {
                log.trace("[{}] Client is already at sleeping: {}, ignoring event: {}", new Object[]{client.getEndpoint(), client.isAsleep(), sleeping});
                boolean bl = false;
                return bl;
            }
            PowerMode powerMode = this.getPowerMode(client);
            if (PowerMode.PSM.equals((Object)powerMode) || PowerMode.E_DRX.equals((Object)powerMode)) {
                log.trace("[{}] Switch sleeping from: {} to: {}", new Object[]{client.getEndpoint(), client.isAsleep(), sleeping});
                client.setAsleep(sleeping);
                this.update(client);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            client.unlock();
        }
    }

    @Override
    public void updateRegistration(LwM2mClient client, Registration registration) throws LwM2MClientStateException {
        client.lock();
        try {
            if (!LwM2MClientState.REGISTERED.equals((Object)client.getState())) {
                throw new LwM2MClientStateException(client.getState(), "Client is in invalid state.");
            }
            client.setRegistration(registration);
            this.onUplink(client);
            if (this.compareAndSetSleepFlag(client, false)) {
                this.sendMsgsAfterSleeping(client);
            } else {
                this.clientStore.put(client);
            }
        }
        finally {
            client.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(LwM2mClient client, Registration registration) throws LwM2MClientStateException {
        block6: {
            client.lock();
            try {
                if (!LwM2MClientState.REGISTERED.equals((Object)client.getState())) {
                    throw new LwM2MClientStateException(client.getState(), "Client is in invalid state.");
                }
                this.lwM2mClientsByRegistrationId.remove(registration.getId());
                Registration currentRegistration = client.getRegistration();
                if (currentRegistration.getId().equals(registration.getId())) {
                    Optional<LwM2mClient> otherClients;
                    client.setState(LwM2MClientState.UNREGISTERED);
                    this.lwM2mClientsByEndpoint.remove(client.getEndpoint());
                    this.clientStore.remove(client.getEndpoint());
                    UUID profileId = client.getProfileId();
                    if (profileId != null && (otherClients = this.lwM2mClientsByRegistrationId.values().stream().filter(e -> e.getProfileId().equals(profileId)).findFirst()).isEmpty()) {
                        this.profiles.remove(profileId);
                    }
                    break block6;
                }
                throw new LwM2MClientStateException(client.getState(), "Client has different registration.");
            }
            finally {
                client.unlock();
            }
        }
    }

    @Override
    public LwM2mClient getClientBySessionInfo(TransportProtos.SessionInfoProto sessionInfo) {
        LwM2mClient lwM2mClient = null;
        UUID sessionId = new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
        Predicate<LwM2mClient> isClientFilter = c -> sessionId.equals(new UUID(c.getSession().getSessionIdMSB(), c.getSession().getSessionIdLSB()));
        if (this.lwM2mClientsByEndpoint.size() > 0) {
            lwM2mClient = this.lwM2mClientsByEndpoint.values().stream().filter(isClientFilter).findAny().orElse(null);
        }
        if (lwM2mClient == null && this.lwM2mClientsByRegistrationId.size() > 0) {
            lwM2mClient = this.lwM2mClientsByRegistrationId.values().stream().filter(isClientFilter).findAny().orElse(null);
        }
        if (lwM2mClient == null) {
            log.error("[{}] Failed to lookup client by session id.", (Object)sessionId);
        }
        return lwM2mClient;
    }

    @Override
    public String getObjectIdByKeyNameFromProfile(LwM2mClient client, String keyName) {
        Lwm2mDeviceProfileTransportConfiguration profile = this.getProfile(client.getProfileId());
        return (String)profile.getObserveAttr().getKeyName().entrySet().stream().filter(e -> ((String)e.getValue()).equals(keyName) && this.validateResourceInModel(client, (String)e.getKey(), false)).findFirst().orElseThrow(() -> new IllegalArgumentException(keyName + " is not configured in the device profile!")).getKey();
    }

    public Registration getRegistration(String registrationId) {
        return this.lwM2mClientsByRegistrationId.get(registrationId).getRegistration();
    }

    @Override
    public void registerClient(Registration registration, ValidateDeviceCredentialsResponse credentials) {
        LwM2mClient client = this.getClientByEndpoint(registration.getEndpoint());
        client.init(credentials, UUID.randomUUID());
        this.lwM2mClientsByRegistrationId.put(registration.getId(), client);
        this.profileUpdate(credentials.getDeviceProfile());
    }

    @Override
    public void update(LwM2mClient client) {
        client.lock();
        try {
            if (client.getState().equals((Object)LwM2MClientState.REGISTERED)) {
                this.clientStore.put(client);
            } else {
                log.error("[{}] Client is in invalid state: {}!", (Object)client.getEndpoint(), (Object)client.getState());
            }
        }
        finally {
            client.unlock();
        }
    }

    @Override
    public void removeCredentials(TransportProtos.SessionInfoProto sessionInfo) {
    }

    @Override
    public void sendMsgsAfterSleeping(LwM2mClient lwM2MClient) {
        PowerMode powerMode;
        if (LwM2MClientState.REGISTERED.equals((Object)lwM2MClient.getState()) && (PowerMode.PSM.equals((Object)(powerMode = this.getPowerMode(lwM2MClient))) || PowerMode.E_DRX.equals((Object)powerMode))) {
            this.defaultLwM2MUplinkMsgHandler.initAttributes(lwM2MClient);
            TransportProtos.TransportToDeviceActorMsg persistentRpcRequestMsg = TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(lwM2MClient.getSession()).setSendPendingRPC(TransportProtos.SendPendingRPCMsg.newBuilder().build()).build();
            this.context.getTransportService().process(persistentRpcRequestMsg, TransportServiceCallback.EMPTY);
            this.otaUpdateService.init(lwM2MClient);
        }
    }

    private PowerMode getPowerMode(LwM2mClient lwM2MClient) {
        PowerMode powerMode = lwM2MClient.getPowerMode();
        if (powerMode == null) {
            Lwm2mDeviceProfileTransportConfiguration deviceProfile = this.getProfile(lwM2MClient.getProfileId());
            powerMode = deviceProfile.getClientLwM2mSettings().getPowerMode();
        }
        return powerMode;
    }

    @Override
    public Collection<LwM2mClient> getLwM2mClients() {
        return this.lwM2mClientsByEndpoint.values();
    }

    @Override
    public Lwm2mDeviceProfileTransportConfiguration getProfile(UUID profileId) {
        return this.doGetAndCache(profileId);
    }

    @Override
    public Lwm2mDeviceProfileTransportConfiguration getProfile(Registration registration) {
        UUID profileId = this.getClientByEndpoint(registration.getEndpoint()).getProfileId();
        return this.doGetAndCache(profileId);
    }

    private Lwm2mDeviceProfileTransportConfiguration doGetAndCache(UUID profileId) {
        Lwm2mDeviceProfileTransportConfiguration result = this.profiles.get(profileId);
        if (result == null) {
            log.debug("Fetching profile [{}]", (Object)profileId);
            DeviceProfile deviceProfile = this.deviceProfileCache.get(new DeviceProfileId(profileId));
            if (deviceProfile != null) {
                result = this.profileUpdate(deviceProfile);
            } else {
                log.info("Device profile was not found! Most probably device profile [{}] has been removed from the database.", (Object)profileId);
            }
        }
        return result;
    }

    @Override
    public Lwm2mDeviceProfileTransportConfiguration profileUpdate(DeviceProfile deviceProfile) {
        Lwm2mDeviceProfileTransportConfiguration clientProfile = LwM2mTransportUtil.toLwM2MClientProfile(deviceProfile);
        this.profiles.put(deviceProfile.getUuidId(), clientProfile);
        return clientProfile;
    }

    @Override
    public Set<String> getSupportedIdVerInClient(LwM2mClient client) {
        ConcurrentHashMap.KeySetView clientObjects = ConcurrentHashMap.newKeySet();
        Arrays.stream(client.getRegistration().getObjectLinks()).forEach(link -> {
            LwM2mPath pathIds = new LwM2mPath(link.getUrl());
            if (!pathIds.isRoot()) {
                clientObjects.add(LwM2mTransportUtil.convertObjectIdToVersionedId(link.getUrl(), client.getRegistration()));
            }
        });
        return clientObjects.size() > 0 ? clientObjects : null;
    }

    @Override
    public LwM2mClient getClientByDeviceId(UUID deviceId) {
        return this.lwM2mClientsByRegistrationId.values().stream().filter(e -> deviceId.equals(e.getDeviceId())).findFirst().orElse(null);
    }

    @Override
    public boolean isComposite(LwM2mClient client) {
        return LwM2mVersion.fromVersionStr(client.getRegistration().getLwM2mVersion()).isComposite() & this.getProfile(client.getProfileId()).getClientLwM2mSettings().isCompositeOperationsSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDownlinkAllowed(LwM2mClient client) {
        Lwm2mDeviceProfileTransportConfiguration clientProfile;
        PowerMode powerMode = client.getPowerMode();
        OtherConfiguration profileSettings = null;
        if (powerMode == null && (powerMode = (profileSettings = (clientProfile = this.getProfile(client.getProfileId())).getClientLwM2mSettings()).getPowerMode()) == null) {
            powerMode = PowerMode.DRX;
        }
        if (PowerMode.DRX.equals((Object)powerMode)) {
            return true;
        }
        client.lock();
        long timeSinceLastUplink = System.currentTimeMillis() - client.getLastUplinkTime();
        try {
            boolean allowed;
            if (PowerMode.PSM.equals((Object)powerMode)) {
                Long psmActivityTimer = client.getPsmActivityTimer();
                if (psmActivityTimer == null && profileSettings != null) {
                    psmActivityTimer = profileSettings.getPsmActivityTimer();
                }
                if (psmActivityTimer == null || psmActivityTimer == 0L) {
                    psmActivityTimer = this.config.getPsmActivityTimer();
                }
                boolean bl = timeSinceLastUplink <= psmActivityTimer;
                return bl;
            }
            Long pagingTransmissionWindow = client.getPagingTransmissionWindow();
            if (pagingTransmissionWindow == null && profileSettings != null) {
                pagingTransmissionWindow = profileSettings.getPagingTransmissionWindow();
            }
            if (pagingTransmissionWindow == null || pagingTransmissionWindow == 0L) {
                pagingTransmissionWindow = this.config.getPagingTransmissionWindow();
            }
            boolean bl = allowed = timeSinceLastUplink <= pagingTransmissionWindow;
            if (!allowed) {
                boolean bl2 = client.checkFirstDownlink();
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            client.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUplink(LwM2mClient client) {
        Lwm2mDeviceProfileTransportConfiguration clientProfile;
        PowerMode powerMode = client.getPowerMode();
        OtherConfiguration profileSettings = null;
        if (powerMode == null && (powerMode = (profileSettings = (clientProfile = this.getProfile(client.getProfileId())).getClientLwM2mSettings()).getPowerMode()) == null) {
            powerMode = PowerMode.DRX;
        }
        if (PowerMode.DRX.equals((Object)powerMode)) {
            client.updateLastUplinkTime();
            return;
        }
        client.lock();
        try {
            long timeout;
            long uplinkTime = client.updateLastUplinkTime();
            if (PowerMode.PSM.equals((Object)powerMode)) {
                Long psmActivityTimer = client.getPsmActivityTimer();
                if (psmActivityTimer == null && profileSettings != null) {
                    psmActivityTimer = profileSettings.getPsmActivityTimer();
                }
                if (psmActivityTimer == null || psmActivityTimer == 0L) {
                    psmActivityTimer = this.config.getPsmActivityTimer();
                }
                timeout = psmActivityTimer;
            } else {
                Long pagingTransmissionWindow = client.getPagingTransmissionWindow();
                if (pagingTransmissionWindow == null && profileSettings != null) {
                    pagingTransmissionWindow = profileSettings.getPagingTransmissionWindow();
                }
                if (pagingTransmissionWindow == null || pagingTransmissionWindow == 0L) {
                    pagingTransmissionWindow = this.config.getPagingTransmissionWindow();
                }
                timeout = pagingTransmissionWindow;
            }
            Future<Void> sleepTask = client.getSleepTask();
            if (sleepTask != null) {
                sleepTask.cancel(false);
            }
            ScheduledFuture task = this.context.getScheduler().schedule(() -> {
                if (uplinkTime == client.getLastUplinkTime()) {
                    this.asleep(client);
                }
                return null;
            }, timeout, TimeUnit.MILLISECONDS);
            client.setSleepTask(task);
        }
        finally {
            client.unlock();
        }
    }

    @Override
    public Long getRequestTimeout(LwM2mClient client) {
        Long timeout = null;
        if (PowerMode.E_DRX.equals((Object)client.getPowerMode()) && client.getEdrxCycle() != null) {
            timeout = client.getEdrxCycle();
        } else {
            Lwm2mDeviceProfileTransportConfiguration clientProfile = this.getProfile(client.getProfileId());
            OtherConfiguration clientLwM2mSettings = clientProfile.getClientLwM2mSettings();
            if (PowerMode.E_DRX.equals((Object)clientLwM2mSettings.getPowerMode())) {
                timeout = clientLwM2mSettings.getEdrxCycle();
            }
        }
        if (timeout == null || timeout == 0L) {
            timeout = this.config.getTimeout();
        }
        return timeout;
    }

    private boolean validateResourceInModel(LwM2mClient lwM2mClient, String pathIdVer, boolean isWritableNotOptional) {
        ResourceModel resourceModel = lwM2mClient.getResourceModel(pathIdVer, this.config.getModelProvider());
        Integer objectId = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathIdVer)).getObjectId();
        String objectVer = LwM2mTransportUtil.validateObjectVerFromKey(pathIdVer);
        return resourceModel != null && (isWritableNotOptional ? objectId != null && objectVer != null && objectVer.equals(lwM2mClient.getRegistration().getSupportedVersion(objectId)) && resourceModel.operations.isWritable() : objectId != null && objectVer != null && objectVer.equals(lwM2mClient.getRegistration().getSupportedVersion(objectId)));
    }

    @ConstructorProperties(value={"context", "config", "securityStore", "clientStore", "sessionManager", "deviceProfileCache"})
    public LwM2mClientContextImpl(LwM2mTransportContext context, LwM2MTransportServerConfig config, TbMainSecurityStore securityStore, TbLwM2MClientStore clientStore, LwM2MSessionManager sessionManager, TransportDeviceProfileCache deviceProfileCache) {
        this.context = context;
        this.config = config;
        this.securityStore = securityStore;
        this.clientStore = clientStore;
        this.sessionManager = sessionManager;
        this.deviceProfileCache = deviceProfileCache;
    }
}

