/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mSingleResource;
import org.eclipse.leshan.core.node.codec.LwM2mValueConverter;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.device.data.Lwm2mDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.lwm2m.config.LwM2mVersion;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientState;
import org.thingsboard.server.transport.lwm2m.server.client.ResourceValue;

public class LwM2mClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(LwM2mClient.class);
    private static final long serialVersionUID = 8793482946289222623L;
    private final String nodeId;
    private final String endpoint;
    private transient Lock lock;
    private final Map<String, ResourceValue> resources;
    private final Map<String, TransportProtos.TsKvProto> sharedAttributes;
    private final ConcurrentMap<String, AtomicLong> keyTsLatestMap;
    private TenantId tenantId;
    private UUID profileId;
    private UUID deviceId;
    private LwM2MClientState state;
    private TransportProtos.SessionInfoProto session;
    private PowerMode powerMode;
    private Long psmActivityTimer;
    private Long edrxCycle;
    private Long pagingTransmissionWindow;
    private Registration registration;
    private boolean asleep;
    private long lastUplinkTime;
    private transient Future<Void> sleepTask;
    private boolean firstEdrxDownlink = true;
    private final AtomicInteger retryAttempts;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public LwM2mClient(String nodeId, String endpoint) {
        this.nodeId = nodeId;
        this.endpoint = endpoint;
        this.sharedAttributes = new ConcurrentHashMap<String, TransportProtos.TsKvProto>();
        this.resources = new ConcurrentHashMap<String, ResourceValue>();
        this.keyTsLatestMap = new ConcurrentHashMap<String, AtomicLong>();
        this.state = LwM2MClientState.CREATED;
        this.lock = new ReentrantLock();
        this.retryAttempts = new AtomicInteger(0);
    }

    public void init(ValidateDeviceCredentialsResponse credentials, UUID sessionId) {
        this.session = this.createSession(this.nodeId, sessionId, credentials);
        this.tenantId = new TenantId(new UUID(this.session.getTenantIdMSB(), this.session.getTenantIdLSB()));
        this.deviceId = new UUID(this.session.getDeviceIdMSB(), this.session.getDeviceIdLSB());
        this.profileId = new UUID(this.session.getDeviceProfileIdMSB(), this.session.getDeviceProfileIdLSB());
        this.powerMode = credentials.getDeviceInfo().getPowerMode();
        this.edrxCycle = credentials.getDeviceInfo().getEdrxCycle();
        this.psmActivityTimer = credentials.getDeviceInfo().getPsmActivityTimer();
        this.pagingTransmissionWindow = credentials.getDeviceInfo().getPagingTransmissionWindow();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void onDeviceUpdate(Device device, Optional<DeviceProfile> deviceProfileOpt) {
        TransportProtos.SessionInfoProto.Builder builder = TransportProtos.SessionInfoProto.newBuilder().mergeFrom(this.session);
        this.deviceId = device.getUuidId();
        builder.setDeviceIdMSB(this.deviceId.getMostSignificantBits());
        builder.setDeviceIdLSB(this.deviceId.getLeastSignificantBits());
        builder.setDeviceName(device.getName());
        deviceProfileOpt.ifPresent(deviceProfile -> this.updateSession((DeviceProfile)deviceProfile, builder));
        this.session = builder.build();
        Lwm2mDeviceTransportConfiguration transportConfiguration = (Lwm2mDeviceTransportConfiguration)device.getDeviceData().getTransportConfiguration();
        this.powerMode = transportConfiguration.getPowerMode();
        this.edrxCycle = transportConfiguration.getEdrxCycle();
        this.psmActivityTimer = transportConfiguration.getPsmActivityTimer();
        this.pagingTransmissionWindow = transportConfiguration.getPagingTransmissionWindow();
    }

    public void onDeviceProfileUpdate(DeviceProfile deviceProfile) {
        TransportProtos.SessionInfoProto.Builder builder = TransportProtos.SessionInfoProto.newBuilder().mergeFrom(this.session);
        this.updateSession(deviceProfile, builder);
        this.session = builder.build();
    }

    private void updateSession(DeviceProfile deviceProfile, TransportProtos.SessionInfoProto.Builder builder) {
        this.profileId = deviceProfile.getUuidId();
        builder.setDeviceProfileIdMSB(this.profileId.getMostSignificantBits());
        builder.setDeviceProfileIdLSB(this.profileId.getLeastSignificantBits());
        builder.setDeviceType(deviceProfile.getName());
    }

    public void refreshSessionId(String nodeId) {
        UUID newId = UUID.randomUUID();
        TransportProtos.SessionInfoProto.Builder builder = TransportProtos.SessionInfoProto.newBuilder().mergeFrom(this.session);
        builder.setNodeId(nodeId);
        builder.setSessionIdMSB(newId.getMostSignificantBits());
        builder.setSessionIdLSB(newId.getLeastSignificantBits());
        this.session = builder.build();
    }

    private TransportProtos.SessionInfoProto createSession(String nodeId, UUID sessionId, ValidateDeviceCredentialsResponse msg) {
        return TransportProtos.SessionInfoProto.newBuilder().setNodeId(nodeId).setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceInfo().getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceInfo().getDeviceId().getId().getLeastSignificantBits()).setTenantIdMSB(msg.getDeviceInfo().getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getDeviceInfo().getTenantId().getId().getLeastSignificantBits()).setCustomerIdMSB(msg.getDeviceInfo().getCustomerId().getId().getMostSignificantBits()).setCustomerIdLSB(msg.getDeviceInfo().getCustomerId().getId().getLeastSignificantBits()).setDeviceName(msg.getDeviceInfo().getDeviceName()).setDeviceType(msg.getDeviceInfo().getDeviceType()).setDeviceProfileIdMSB(msg.getDeviceInfo().getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(msg.getDeviceInfo().getDeviceProfileId().getId().getLeastSignificantBits()).build();
    }

    public boolean saveResourceValue(String pathRezIdVer, LwM2mResource rez, LwM2mModelProvider modelProvider) {
        if (this.resources.get(pathRezIdVer) != null && this.resources.get(pathRezIdVer).getResourceModel() != null) {
            this.resources.get(pathRezIdVer).setLwM2mResource(rez);
            return true;
        }
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathRezIdVer));
        ResourceModel resourceModel = modelProvider.getObjectModel(this.registration).getResourceModel(pathIds.getObjectId().intValue(), pathIds.getResourceId().intValue());
        if (resourceModel != null) {
            this.resources.put(pathRezIdVer, new ResourceValue(rez, resourceModel));
            return true;
        }
        return false;
    }

    public Object getResourceValue(String pathRezIdVer, String pathRezId) {
        String pathRez;
        String string = pathRez = pathRezIdVer == null ? LwM2mTransportUtil.convertObjectIdToVersionedId(pathRezId, this.registration) : pathRezIdVer;
        if (this.resources.get(pathRez) != null) {
            return this.resources.get(pathRez).getLwM2mResource().getValue();
        }
        return null;
    }

    public Object getResourceNameByRezId(String pathRezIdVer, String pathRezId) {
        String pathRez;
        String string = pathRez = pathRezIdVer == null ? LwM2mTransportUtil.convertObjectIdToVersionedId(pathRezId, this.registration) : pathRezIdVer;
        if (this.resources.get(pathRez) != null) {
            return this.resources.get((Object)pathRez).getResourceModel().name;
        }
        return null;
    }

    public String getRezIdByResourceNameAndObjectInstanceId(String resourceName, String pathObjectInstanceIdVer, LwM2mModelProvider modelProvider) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathObjectInstanceIdVer));
        if (pathIds.isObjectInstance()) {
            Set rezIds = modelProvider.getObjectModel((Registration)this.registration).getObjectModel((int)pathIds.getObjectId().intValue()).resources.entrySet().stream().filter(map -> resourceName.equals(((ResourceModel)map.getValue()).name)).map(map -> (Integer)map.getKey()).collect(Collectors.toSet());
            return rezIds.size() > 0 ? String.valueOf(rezIds.stream().findFirst().get()) : null;
        }
        return null;
    }

    public ResourceModel getResourceModel(String pathIdVer, LwM2mModelProvider modelProvider) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathIdVer));
        String verSupportedObject = (String)this.registration.getSupportedObject().get(pathIds.getObjectId());
        String verRez = LwM2mTransportUtil.getVerFromPathIdVerOrId(pathIdVer);
        return verRez == null || verRez.equals(verSupportedObject) ? modelProvider.getObjectModel(this.registration).getResourceModel(pathIds.getObjectId().intValue(), pathIds.getResourceId().intValue()) : null;
    }

    public boolean isResourceMultiInstances(String pathIdVer, LwM2mModelProvider modelProvider) {
        ResourceModel resourceModel = this.getResourceModel(pathIdVer, modelProvider);
        if (resourceModel != null && resourceModel.multiple != null) {
            return resourceModel.multiple;
        }
        return false;
    }

    public ObjectModel getObjectModel(String pathIdVer, LwM2mModelProvider modelProvider) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathIdVer));
        String verSupportedObject = (String)this.registration.getSupportedObject().get(pathIds.getObjectId());
        String verRez = LwM2mTransportUtil.getVerFromPathIdVerOrId(pathIdVer);
        return verRez == null || verRez.equals(verSupportedObject) ? modelProvider.getObjectModel(this.registration).getObjectModel(pathIds.getObjectId().intValue()) : null;
    }

    public Collection<LwM2mResource> getNewResourceForInstance(String pathRezIdVer, Object params, LwM2mModelProvider modelProvider, LwM2mValueConverter converter) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathRezIdVer));
        ConcurrentHashMap.KeySetView resources = ConcurrentHashMap.newKeySet();
        Map resourceModels = modelProvider.getObjectModel((Registration)this.registration).getObjectModel((int)pathIds.getObjectId().intValue()).resources;
        resourceModels.forEach((resId, resourceModel) -> {
            if (resId.equals(pathIds.getResourceId())) {
                resources.add(LwM2mSingleResource.newResource((int)resId, (Object)converter.convertValue(params, LwM2mTransportUtil.equalsResourceTypeGetSimpleName(params), resourceModel.type, pathIds), (ResourceModel.Type)resourceModel.type));
            }
        });
        return resources;
    }

    public Collection<LwM2mResource> getNewResourcesForInstance(String pathRezIdVer, Object params, LwM2mModelProvider modelProvider, LwM2mValueConverter converter) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathRezIdVer));
        ConcurrentHashMap.KeySetView resources = ConcurrentHashMap.newKeySet();
        Map resourceModels = modelProvider.getObjectModel((Registration)this.registration).getObjectModel((int)pathIds.getObjectId().intValue()).resources;
        resourceModels.forEach((resId, resourceModel) -> {
            if (((Map)params).containsKey(String.valueOf(resId))) {
                Object value = ((Map)params).get(String.valueOf(resId));
                resources.add(LwM2mSingleResource.newResource((int)resId, (Object)converter.convertValue(value, LwM2mTransportUtil.equalsResourceTypeGetSimpleName(value), resourceModel.type, pathIds), (ResourceModel.Type)resourceModel.type));
            }
        });
        return resources;
    }

    public void isValidObjectVersion(String path) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(path));
        String verSupportedObject = (String)this.registration.getSupportedObject().get(pathIds.getObjectId());
        String verRez = LwM2mTransportUtil.getVerFromPathIdVerOrId(path);
        if (verRez != null && !verRez.equals(verSupportedObject) || verRez == null && !"1.0".equals(verSupportedObject)) {
            throw new IllegalArgumentException(String.format("Specified resource id %s is not valid version! Must be version: %s", path, verSupportedObject));
        }
    }

    public void deleteResources(String pathIdVer, LwM2mModelProvider modelProvider) {
        Set<String> key = this.getKeysEqualsIdVer(pathIdVer);
        key.forEach(pathRez -> {
            LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathRez));
            ResourceModel resourceModel = modelProvider.getObjectModel(this.registration).getResourceModel(pathIds.getObjectId().intValue(), pathIds.getResourceId().intValue());
            if (resourceModel != null) {
                this.resources.get(pathRez).setResourceModel(resourceModel);
            } else {
                this.resources.remove(pathRez);
            }
        });
    }

    public void updateResourceModel(String idVer, LwM2mModelProvider modelProvider) {
        Set<String> key = this.getKeysEqualsIdVer(idVer);
        key.forEach(k -> this.saveResourceModel((String)k, modelProvider));
    }

    private void saveResourceModel(String pathRez, LwM2mModelProvider modelProvider) {
        LwM2mPath pathIds = new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathRez));
        ResourceModel resourceModel = modelProvider.getObjectModel(this.registration).getResourceModel(pathIds.getObjectId().intValue(), pathIds.getResourceId().intValue());
        this.resources.get(pathRez).setResourceModel(resourceModel);
    }

    private Set<String> getKeysEqualsIdVer(String idVer) {
        return this.resources.keySet().stream().filter(e -> idVer.equals(e.split("/")[1])).collect(Collectors.toSet());
    }

    public ContentFormat getDefaultContentFormat() {
        if (this.registration == null) {
            return ContentFormat.DEFAULT;
        }
        return LwM2mVersion.fromVersionStr(this.registration.getLwM2mVersion()).getContentFormat();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantLock();
    }

    public long updateLastUplinkTime() {
        this.lastUplinkTime = System.currentTimeMillis();
        this.firstEdrxDownlink = true;
        return this.lastUplinkTime;
    }

    public boolean checkFirstDownlink() {
        boolean result = this.firstEdrxDownlink;
        this.firstEdrxDownlink = false;
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2mClient)) {
            return false;
        }
        LwM2mClient other = (LwM2mClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2mClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        return result;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, ResourceValue> getResources() {
        return this.resources;
    }

    public Map<String, TransportProtos.TsKvProto> getSharedAttributes() {
        return this.sharedAttributes;
    }

    public ConcurrentMap<String, AtomicLong> getKeyTsLatestMap() {
        return this.keyTsLatestMap;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public UUID getProfileId() {
        return this.profileId;
    }

    public UUID getDeviceId() {
        return this.deviceId;
    }

    public LwM2MClientState getState() {
        return this.state;
    }

    public void setState(LwM2MClientState state) {
        this.state = state;
    }

    public TransportProtos.SessionInfoProto getSession() {
        return this.session;
    }

    public PowerMode getPowerMode() {
        return this.powerMode;
    }

    public Long getPsmActivityTimer() {
        return this.psmActivityTimer;
    }

    public Long getEdrxCycle() {
        return this.edrxCycle;
    }

    public Long getPagingTransmissionWindow() {
        return this.pagingTransmissionWindow;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public boolean isAsleep() {
        return this.asleep;
    }

    public void setAsleep(boolean asleep) {
        this.asleep = asleep;
    }

    public long getLastUplinkTime() {
        return this.lastUplinkTime;
    }

    public Future<Void> getSleepTask() {
        return this.sleepTask;
    }

    public void setSleepTask(Future<Void> sleepTask) {
        this.sleepTask = sleepTask;
    }

    public AtomicInteger getRetryAttempts() {
        return this.retryAttempts;
    }
}

