/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.attributes;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.attributes.LwM2MAttributesService;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.ota.DefaultLwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MAttributesService
implements LwM2MAttributesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MAttributesService.class);
    private final AtomicInteger reqIdSeq = new AtomicInteger();
    private final Map<Integer, SettableFuture<List<TransportProtos.TsKvProto>>> futures;
    private final TransportService transportService;
    private final LwM2mTransportServerHelper helper;
    private final LwM2mClientContext clientContext;
    private final LwM2MTransportServerConfig config;
    private final LwM2mUplinkMsgHandler uplinkHandler;
    private final LwM2mDownlinkMsgHandler downlinkHandler;
    private final LwM2MTelemetryLogService logService;
    private final LwM2MOtaUpdateService otaUpdateService;

    @Override
    public ListenableFuture<List<TransportProtos.TsKvProto>> getSharedAttributes(LwM2mClient client, Collection<String> keys) {
        SettableFuture future = SettableFuture.create();
        final int requestId = this.reqIdSeq.incrementAndGet();
        this.futures.put(requestId, (SettableFuture<List<TransportProtos.TsKvProto>>)future);
        this.transportService.process(client.getSession(), TransportProtos.GetAttributeRequestMsg.newBuilder().setRequestId(requestId).addAllSharedAttributeNames(keys).build(), (TransportServiceCallback)new TransportServiceCallback<Void>(){

            public void onSuccess(Void msg) {
            }

            public void onError(Throwable e) {
                SettableFuture<List<TransportProtos.TsKvProto>> callback = DefaultLwM2MAttributesService.this.futures.remove(requestId);
                if (callback != null) {
                    callback.setException(e);
                }
            }
        });
        return future;
    }

    @Override
    public void onGetAttributesResponse(TransportProtos.GetAttributeResponseMsg getAttributesResponse, TransportProtos.SessionInfoProto sessionInfo) {
        SettableFuture<List<TransportProtos.TsKvProto>> callback = this.futures.remove(getAttributesResponse.getRequestId());
        if (callback != null) {
            callback.set((Object)getAttributesResponse.getSharedAttributeListList());
        }
    }

    @Override
    public void onAttributesUpdate(TransportProtos.AttributeUpdateNotificationMsg msg, TransportProtos.SessionInfoProto sessionInfo) {
        LwM2mClient lwM2MClient = this.clientContext.getClientBySessionInfo(sessionInfo);
        if (msg.getSharedUpdatedCount() > 0 && lwM2MClient != null) {
            String newFirmwareTitle = null;
            String newFirmwareVersion = null;
            String newFirmwareTag = null;
            String newFirmwareUrl = null;
            String newSoftwareTitle = null;
            String newSoftwareVersion = null;
            String newSoftwareTag = null;
            String newSoftwareUrl = null;
            ArrayList<TransportProtos.TsKvProto> otherAttributes = new ArrayList<TransportProtos.TsKvProto>();
            for (TransportProtos.TsKvProto tsKvProto : msg.getSharedUpdatedList()) {
                String attrName = tsKvProto.getKv().getKey();
                if (DefaultLwM2MOtaUpdateService.FIRMWARE_TITLE.equals(attrName)) {
                    newFirmwareTitle = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.FIRMWARE_VERSION.equals(attrName)) {
                    newFirmwareVersion = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.FIRMWARE_TAG.equals(attrName)) {
                    newFirmwareTag = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.FIRMWARE_URL.equals(attrName)) {
                    newFirmwareUrl = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.SOFTWARE_TITLE.equals(attrName)) {
                    newSoftwareTitle = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.SOFTWARE_VERSION.equals(attrName)) {
                    newSoftwareVersion = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.SOFTWARE_TAG.equals(attrName)) {
                    newSoftwareTag = this.getStrValue(tsKvProto);
                    continue;
                }
                if (DefaultLwM2MOtaUpdateService.SOFTWARE_URL.equals(attrName)) {
                    newSoftwareUrl = this.getStrValue(tsKvProto);
                    continue;
                }
                otherAttributes.add(tsKvProto);
            }
            if (newFirmwareTitle != null || newFirmwareVersion != null) {
                this.otaUpdateService.onTargetFirmwareUpdate(lwM2MClient, newFirmwareTitle, newFirmwareVersion, Optional.ofNullable(newFirmwareUrl), Optional.ofNullable(newFirmwareTag));
            }
            if (newSoftwareTitle != null || newSoftwareVersion != null) {
                this.otaUpdateService.onTargetSoftwareUpdate(lwM2MClient, newSoftwareTitle, newSoftwareVersion, Optional.ofNullable(newSoftwareUrl), Optional.ofNullable(newSoftwareTag));
            }
            if (!otherAttributes.isEmpty()) {
                this.onAttributesUpdate(lwM2MClient, otherAttributes);
            }
        } else if (lwM2MClient == null) {
            log.error("OnAttributeUpdate, lwM2MClient is null");
        }
    }

    @Override
    public void onAttributesUpdate(LwM2mClient lwM2MClient, List<TransportProtos.TsKvProto> tsKvProtos) {
        log.trace("[{}] onAttributesUpdate [{}]", (Object)lwM2MClient.getEndpoint(), tsKvProtos);
        tsKvProtos.forEach(tsKvProto -> {
            String pathIdVer = this.clientContext.getObjectIdByKeyNameFromProfile(lwM2MClient, tsKvProto.getKv().getKey());
            if (pathIdVer != null) {
                if (lwM2MClient.getSharedAttributes().containsKey(pathIdVer)) {
                    if (tsKvProto.getTs() > lwM2MClient.getSharedAttributes().get(pathIdVer).getTs()) {
                        lwM2MClient.getSharedAttributes().put(pathIdVer, (TransportProtos.TsKvProto)tsKvProto);
                    }
                } else {
                    lwM2MClient.getSharedAttributes().put(pathIdVer, (TransportProtos.TsKvProto)tsKvProto);
                }
            }
        });
        this.clientContext.update(lwM2MClient);
        lwM2MClient.getSharedAttributes().forEach((pathIdVer, tsKvProto) -> this.pushUpdateToClientIfNeeded(lwM2MClient, this.getResourceValueFormatKv(lwM2MClient, (String)pathIdVer), LwM2mTransportServerHelper.getValueFromKvProto(tsKvProto.getKv()), (String)pathIdVer));
    }

    private void pushUpdateToClientIfNeeded(LwM2mClient lwM2MClient, Object valueOld, Object newValue, String versionedId) {
        if (!(newValue == null || valueOld != null && newValue.toString().equals(valueOld.toString()))) {
            TbLwM2MWriteReplaceRequest request = TbLwM2MWriteReplaceRequest.builder().versionedId(versionedId).value(newValue).timeout(this.clientContext.getRequestTimeout(lwM2MClient)).build();
            this.downlinkHandler.sendWriteReplaceRequest(lwM2MClient, request, new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, lwM2MClient, versionedId));
        } else {
            log.error("Failed update resource [{}] [{}]", (Object)versionedId, newValue);
            String logMsg = String.format("%s: Failed update resource versionedId - %s value - %s. Value is not changed or bad", "error", versionedId, newValue);
            this.logService.log(lwM2MClient, logMsg);
            log.info("Failed update resource [{}] [{}]", (Object)versionedId, newValue);
        }
    }

    private Object getResourceValueFormatKv(LwM2mClient lwM2MClient, String pathIdVer) {
        LwM2mResource resourceValue = LwM2mTransportUtil.getResourceValueFromLwM2MClient(lwM2MClient, pathIdVer);
        if (resourceValue != null) {
            ResourceModel.Type currentType = resourceValue.getType();
            ResourceModel.Type expectedType = LwM2mTransportServerHelper.getResourceModelTypeEqualsKvProtoValueType(currentType, pathIdVer);
            return LwM2mValueConverterImpl.getInstance().convertValue(resourceValue.getValue(), currentType, expectedType, new LwM2mPath(LwM2mTransportUtil.fromVersionedIdToObjectId(pathIdVer)));
        }
        return null;
    }

    private String getStrValue(TransportProtos.TsKvProto tsKvProto) {
        return tsKvProto.getKv().getStringV();
    }

    @ConstructorProperties(value={"futures", "transportService", "helper", "clientContext", "config", "uplinkHandler", "downlinkHandler", "logService", "otaUpdateService"})
    public DefaultLwM2MAttributesService(Map<Integer, SettableFuture<List<TransportProtos.TsKvProto>>> futures, TransportService transportService, LwM2mTransportServerHelper helper, LwM2mClientContext clientContext, LwM2MTransportServerConfig config, LwM2mUplinkMsgHandler uplinkHandler, LwM2mDownlinkMsgHandler downlinkHandler, LwM2MTelemetryLogService logService, LwM2MOtaUpdateService otaUpdateService) {
        this.futures = futures;
        this.transportService = transportService;
        this.helper = helper;
        this.clientContext = clientContext;
        this.config = config;
        this.uplinkHandler = uplinkHandler;
        this.downlinkHandler = downlinkHandler;
        this.logService = logService;
        this.otaUpdateService = otaUpdateService;
    }
}

