/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.leshan.core.model.DefaultDDFFileValidator;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;

public class LwM2mVersionedModelProvider
implements LwM2mModelProvider {
    private static final Logger log = LoggerFactory.getLogger(LwM2mVersionedModelProvider.class);
    private final LwM2mClientContext lwM2mClientContext;
    private final LwM2mTransportServerHelper helper;
    private final LwM2mTransportContext context;

    private String getKeyIdVer(Integer objectId, String version) {
        return objectId != null ? objectId + "_" + (version == null || version.isEmpty() ? "1.0" : version) : null;
    }

    public LwM2mModel getObjectModel(Registration registration) {
        return new DynamicModel(registration);
    }

    @ConstructorProperties(value={"lwM2mClientContext", "helper", "context"})
    public LwM2mVersionedModelProvider(LwM2mClientContext lwM2mClientContext, LwM2mTransportServerHelper helper, LwM2mTransportContext context) {
        this.lwM2mClientContext = lwM2mClientContext;
        this.helper = helper;
        this.context = context;
    }

    private class DynamicModel
    implements LwM2mModel {
        private final Registration registration;
        private final TenantId tenantId;

        public DynamicModel(Registration registration) {
            this.registration = registration;
            this.tenantId = LwM2mVersionedModelProvider.this.lwM2mClientContext.getClientByEndpoint(registration.getEndpoint()).getTenantId();
        }

        public ResourceModel getResourceModel(int objectId, int resourceId) {
            try {
                ObjectModel objectModel = this.getObjectModel(objectId);
                if (objectModel != null) {
                    return (ResourceModel)objectModel.resources.get(resourceId);
                }
                log.trace("TbResources (Object model) with id [{}/0/{}] not found on the server", (Object)objectId, (Object)resourceId);
                return null;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return null;
            }
        }

        public ObjectModel getObjectModel(int objectId) {
            String version = this.registration.getSupportedVersion(Integer.valueOf(objectId));
            if (version != null) {
                return this.getObjectModelDynamic(objectId, version);
            }
            return null;
        }

        public Collection<ObjectModel> getObjectModels() {
            Map supportedObjects = this.registration.getSupportedObject();
            ArrayList<ObjectModel> result = new ArrayList<ObjectModel>(supportedObjects.size());
            for (Map.Entry supportedObject : supportedObjects.entrySet()) {
                ObjectModel objectModel = this.getObjectModelDynamic((Integer)supportedObject.getKey(), (String)supportedObject.getValue());
                if (objectModel == null) continue;
                result.add(objectModel);
            }
            return result;
        }

        private ObjectModel getObjectModelDynamic(Integer objectId, String version) {
            String key = LwM2mVersionedModelProvider.this.getKeyIdVer(objectId, version);
            Optional tbResource = LwM2mVersionedModelProvider.this.context.getTransportResourceCache().get(this.tenantId, ResourceType.LWM2M_MODEL, key);
            return tbResource.map(resource -> LwM2mVersionedModelProvider.this.helper.parseFromXmlToObjectModel(Base64.getDecoder().decode(resource.getData()), key + ".xml", new DefaultDDFFileValidator())).orElse(null);
        }
    }
}

