/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.transport.lwm2m.server.AbstractLwM2mTransportResource;

public class LwM2mTransportCoapResource
extends AbstractLwM2mTransportResource {
    private static final Logger log = LoggerFactory.getLogger(LwM2mTransportCoapResource.class);
    private final ConcurrentMap<String, ObserveRelation> tokenToObserveRelationMap = new ConcurrentHashMap<String, ObserveRelation>();
    private final ConcurrentMap<String, AtomicInteger> tokenToObserveNotificationSeqMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final OtaPackageDataCache otaPackageDataCache;

    public LwM2mTransportCoapResource(OtaPackageDataCache otaPackageDataCache, String name) {
        super(name);
        this.otaPackageDataCache = otaPackageDataCache;
        this.setObservable(true);
        this.addObserver(new CoapResourceObserver());
    }

    public void checkObserveRelation(Exchange exchange, Response response) {
        String token = this.getTokenFromRequest(exchange.getRequest());
        ObserveRelation relation = exchange.getRelation();
        if (relation == null || relation.isCanceled()) {
            return;
        }
        if (CoAP.ResponseCode.isSuccess((CoAP.ResponseCode)response.getCode())) {
            if (!relation.isEstablished()) {
                relation.setEstablished();
                this.addObserveRelation(relation);
            }
            AtomicInteger notificationCounter = this.tokenToObserveNotificationSeqMap.computeIfAbsent(token, s -> new AtomicInteger(0));
            response.getOptions().setObserve(notificationCounter.getAndIncrement());
        }
    }

    @Override
    protected void processHandleGet(CoapExchange exchange) {
        log.debug("processHandleGet [{}]", (Object)exchange);
        List uriPath = exchange.getRequestOptions().getUriPath();
        if (uriPath.size() >= 2 && ("tbfw".equals(uriPath.get(uriPath.size() - 2)) || "tbsw".equals(uriPath.get(uriPath.size() - 2)))) {
            this.sendOtaData(exchange);
        }
    }

    @Override
    protected void processHandlePost(CoapExchange exchange) {
        log.debug("processHandlePost [{}]", (Object)exchange);
    }

    public Resource getChild(String name) {
        return this;
    }

    private String getTokenFromRequest(Request request) {
        return (request.getSourceContext() != null ? request.getSourceContext().getPeerAddress().getAddress().getHostAddress() : "null") + ":" + (request.getSourceContext() != null ? request.getSourceContext().getPeerAddress().getPort() : -1) + ":" + request.getTokenString();
    }

    private void sendOtaData(CoapExchange exchange) {
        String idStr = (String)exchange.getRequestOptions().getUriPath().get(exchange.getRequestOptions().getUriPath().size() - 1);
        UUID currentId = UUID.fromString(idStr);
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        byte[] otaData = this.getOtaData(currentId);
        log.debug("Read ota data (length): [{}]", (Object)otaData.length);
        if (otaData.length > 0) {
            response.setPayload(otaData);
            if (exchange.getRequestOptions().getBlock2() != null) {
                int chunkSize = exchange.getRequestOptions().getBlock2().getSzx();
                boolean lastFlag = otaData.length <= chunkSize;
                response.getOptions().setBlock2(chunkSize, lastFlag, 0);
                log.trace("With block2 Send currentId: [{}], length: [{}], chunkSize [{}], moreFlag [{}]", new Object[]{currentId.toString(), otaData.length, chunkSize, lastFlag});
            } else {
                log.trace("With block1 Send currentId: [{}], length: [{}], ", (Object)currentId.toString(), (Object)otaData.length);
            }
            exchange.respond(response);
        }
    }

    private byte[] getOtaData(UUID currentId) {
        return this.otaPackageDataCache.get(currentId.toString());
    }

    public class CoapResourceObserver
    implements ResourceObserver {
        public void changedName(String old) {
        }

        public void changedPath(String old) {
        }

        public void addedChild(Resource child) {
        }

        public void removedChild(Resource child) {
        }

        public void addedObserveRelation(ObserveRelation relation) {
        }

        public void removedObserveRelation(ObserveRelation relation) {
        }
    }
}

