/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.util.Collection;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.server.observation.ObservationListener;
import org.eclipse.leshan.server.queue.PresenceListener;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationListener;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;

public class LwM2mServerListener {
    private static final Logger log = LoggerFactory.getLogger(LwM2mServerListener.class);
    private final LwM2mUplinkMsgHandler service;
    public final RegistrationListener registrationListener = new RegistrationListener(){

        public void registered(Registration registration, Registration previousReg, Collection<Observation> previousObservations) {
            LwM2mServerListener.this.service.onRegistered(registration, previousObservations);
        }

        public void updated(RegistrationUpdate update, Registration updatedRegistration, Registration previousRegistration) {
            LwM2mServerListener.this.service.updatedReg(updatedRegistration);
        }

        public void unregistered(Registration registration, Collection<Observation> observations, boolean expired, Registration newReg) {
            LwM2mServerListener.this.service.unReg(registration, observations);
        }
    };
    public final PresenceListener presenceListener = new PresenceListener(){

        public void onSleeping(Registration registration) {
            log.info("[{}] onSleeping", (Object)registration.getEndpoint());
            LwM2mServerListener.this.service.onSleepingDev(registration);
        }

        public void onAwake(Registration registration) {
            log.info("[{}] onAwake", (Object)registration.getEndpoint());
            LwM2mServerListener.this.service.onAwakeDev(registration);
        }
    };
    public final ObservationListener observationListener = new ObservationListener(){

        public void cancelled(Observation observation) {
            log.trace("Canceled Observation {}.", (Object)observation.getPath());
        }

        public void onResponse(Observation observation, Registration registration, ObserveResponse response) {
            if (registration != null) {
                LwM2mServerListener.this.service.onUpdateValueAfterReadResponse(registration, LwM2mTransportUtil.convertObjectIdToVersionedId(observation.getPath().toString(), registration), (ReadResponse)response);
            }
        }

        public void onError(Observation observation, Registration registration, Exception error) {
            log.error("Unable to handle notification of [{}:{}]", new Object[]{observation.getRegistrationId(), observation.getPath(), error});
        }

        public void newObservation(Observation observation, Registration registration) {
            log.trace("Successful start newObservation {}.", (Object)observation.getPath());
        }
    };

    public LwM2mServerListener(LwM2mUplinkMsgHandler service) {
        this.service = service;
    }
}

