/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

public enum LwM2mOperationType {
    READ(0, "Read", true),
    READ_COMPOSITE(1, "ReadComposite", false, true),
    DISCOVER(2, "Discover", true),
    DISCOVER_ALL(3, "DiscoverAll", false),
    OBSERVE_READ_ALL(4, "ObserveReadAll", false),
    OBSERVE(5, "Observe", true),
    OBSERVE_COMPOSITE(6, "ObserveComposite", false, true),
    OBSERVE_CANCEL(7, "ObserveCancel", true),
    OBSERVE_COMPOSITE_CANCEL(8, "ObserveCompositeCancel", false, true),
    OBSERVE_CANCEL_ALL(9, "ObserveCancelAll", false),
    EXECUTE(10, "Execute", true),
    WRITE_REPLACE(11, "WriteReplace", true),
    WRITE_UPDATE(12, "WriteUpdate", true),
    WRITE_COMPOSITE(14, "WriteComposite", false, true),
    WRITE_ATTRIBUTES(15, "WriteAttributes", true),
    DELETE(16, "Delete", true),
    FW_UPDATE(17, "FirmwareUpdate", false);

    private final int code;
    private final String type;
    private final boolean hasObjectId;
    private final boolean composite;

    private LwM2mOperationType(int code, String type, boolean hasObjectId) {
        this(code, type, hasObjectId, false);
    }

    private LwM2mOperationType(int code, String type, boolean hasObjectId, boolean composite) {
        this.code = code;
        this.type = type;
        this.hasObjectId = hasObjectId;
        this.composite = composite;
        if (hasObjectId && composite) {
            throw new IllegalArgumentException("Can't set both Composite and hasObjectId for the same operation!");
        }
    }

    public static LwM2mOperationType fromType(String type) {
        for (LwM2mOperationType to : LwM2mOperationType.values()) {
            if (!to.type.equals(type)) continue;
            return to;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public boolean isHasObjectId() {
        return this.hasObjectId;
    }

    public boolean isComposite() {
        return this.composite;
    }
}

