/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mValueConverter;
import org.eclipse.leshan.server.californium.LeshanServer;
import org.eclipse.leshan.server.californium.LeshanServerBuilder;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MAuthorizer;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MDtlsCertificateVerifier;
import org.thingsboard.server.transport.lwm2m.server.LwM2MTransportService;
import org.thingsboard.server.transport.lwm2m.server.LwM2mNetworkConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mServerListener;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportCoapResource;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.LwM2mVersionedModelProvider;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.store.TbSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.DefaultLwM2MUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Component
@TbLwM2mTransportComponent
public class DefaultLwM2mTransportService
implements LwM2MTransportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2mTransportService.class);
    public static final CipherSuite[] RPK_OR_X509_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256};
    public static final CipherSuite[] PSK_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256};
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;
    private final LwM2mTransportServerHelper helper;
    private final OtaPackageDataCache otaPackageDataCache;
    private final DefaultLwM2MUplinkMsgHandler handler;
    private final CaliforniumRegistrationStore registrationStore;
    private final TbSecurityStore securityStore;
    private final LwM2mClientContext lwM2mClientContext;
    private final TbLwM2MDtlsCertificateVerifier certificateVerifier;
    private final TbLwM2MAuthorizer authorizer;
    private LeshanServer server;

    @PostConstruct
    public void init() {
        this.server = this.getLhServer();
        LwM2mTransportCoapResource otaCoapResource = new LwM2mTransportCoapResource(this.otaPackageDataCache, "tbfw");
        this.server.coap().getServer().add(new Resource[]{otaCoapResource});
        this.startLhServer();
        this.context.setServer(this.server);
    }

    private void startLhServer() {
        log.info("Starting LwM2M transport server...");
        this.server.start();
        LwM2mServerListener lhServerCertListener = new LwM2mServerListener(this.handler);
        this.server.getRegistrationService().addListener(lhServerCertListener.registrationListener);
        this.server.getPresenceService().addListener(lhServerCertListener.presenceListener);
        this.server.getObservationService().addListener(lhServerCertListener.observationListener);
        log.info("Started LwM2M transport server.");
    }

    @PreDestroy
    public void shutdown() {
        log.info("Stopping LwM2M transport server!");
        this.server.destroy();
        log.info("LwM2M transport server stopped!");
    }

    private LeshanServer getLhServer() {
        LeshanServerBuilder builder = new LeshanServerBuilder();
        builder.setLocalAddress(this.config.getHost(), this.config.getPort().intValue());
        builder.setLocalSecureAddress(this.config.getSecureHost(), this.config.getSecurePort().intValue());
        builder.setDecoder((LwM2mNodeDecoder)new DefaultLwM2mNodeDecoder());
        builder.setEncoder((LwM2mNodeEncoder)new DefaultLwM2mNodeEncoder((LwM2mValueConverter)LwM2mValueConverterImpl.getInstance()));
        builder.setCoapConfig(LwM2mNetworkConfig.getCoapConfig(this.config.getPort(), this.config.getSecurePort(), this.config));
        LwM2mVersionedModelProvider modelProvider = new LwM2mVersionedModelProvider(this.lwM2mClientContext, this.helper, this.context);
        this.config.setModelProvider(modelProvider);
        builder.setObjectModelProvider((LwM2mModelProvider)modelProvider);
        builder.setSecurityStore((SecurityStore)this.securityStore);
        builder.setRegistrationStore(this.registrationStore);
        DtlsConnectorConfig.Builder dtlsConfig = new DtlsConnectorConfig.Builder();
        dtlsConfig.setServerOnly(true);
        dtlsConfig.setRecommendedSupportedGroupsOnly(this.config.isRecommendedSupportedGroups());
        dtlsConfig.setRecommendedCipherSuitesOnly(this.config.isRecommendedCiphers());
        this.setServerWithCredentials(builder, dtlsConfig);
        builder.setDtlsConfig(dtlsConfig);
        return builder.build();
    }

    private void setServerWithCredentials(LeshanServerBuilder builder, DtlsConnectorConfig.Builder dtlsConfig) {
        if (this.config.getKeyStoreValue() != null && this.setBuilderX509(builder)) {
            dtlsConfig.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)this.certificateVerifier);
            builder.setAuthorizer((Authorizer)this.authorizer);
            dtlsConfig.setSupportedCipherSuites(RPK_OR_X509_CIPHER_SUITES);
        } else {
            builder.setTrustedCertificates((Certificate[])new X509Certificate[0]);
            log.info("Unable to load X509 files for LWM2MServer");
            dtlsConfig.setSupportedCipherSuites(PSK_CIPHER_SUITES);
        }
    }

    private boolean setBuilderX509(LeshanServerBuilder builder) {
        try {
            X509Certificate[] certificateChain = SslContextUtil.asX509Certificates((Certificate[])this.config.getKeyStoreValue().getCertificateChain(this.config.getCertificateAlias()));
            X509Certificate serverCertificate = certificateChain[0];
            PrivateKey privateKey = (PrivateKey)this.config.getKeyStoreValue().getKey(this.config.getCertificateAlias(), this.config.getCertificatePassword() == null ? null : this.config.getCertificatePassword().toCharArray());
            PublicKey publicKey = serverCertificate.getPublicKey();
            if (privateKey != null && privateKey.getEncoded().length > 0 && publicKey != null && publicKey.getEncoded().length > 0) {
                builder.setPublicKey(serverCertificate.getPublicKey());
                builder.setPrivateKey(privateKey);
                builder.setCertificateChain(certificateChain);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            log.error("[{}] Unable to load KeyStore  files server", (Object)ex.getMessage());
            return false;
        }
    }

    public String getName() {
        return "LWM2M";
    }

    @ConstructorProperties(value={"context", "config", "helper", "otaPackageDataCache", "handler", "registrationStore", "securityStore", "lwM2mClientContext", "certificateVerifier", "authorizer"})
    public DefaultLwM2mTransportService(LwM2mTransportContext context, LwM2MTransportServerConfig config, LwM2mTransportServerHelper helper, OtaPackageDataCache otaPackageDataCache, DefaultLwM2MUplinkMsgHandler handler, CaliforniumRegistrationStore registrationStore, TbSecurityStore securityStore, LwM2mClientContext lwM2mClientContext, TbLwM2MDtlsCertificateVerifier certificateVerifier, TbLwM2MAuthorizer authorizer) {
        this.context = context;
        this.config = config;
        this.helper = helper;
        this.otaPackageDataCache = otaPackageDataCache;
        this.handler = handler;
        this.registrationStore = registrationStore;
        this.securityStore = securityStore;
        this.lwM2mClientContext = lwM2mClientContext;
        this.certificateVerifier = certificateVerifier;
        this.authorizer = authorizer;
    }
}

