/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.secure;

import java.beans.ConstructorProperties;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.SecurityChecker;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.secure.TbX509DtlsSessionInfo;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbSecurityStore;

@Component
@TbLwM2mTransportComponent
public class TbLwM2MAuthorizer
implements Authorizer {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MAuthorizer.class);
    private final TbLwM2MDtlsSessionStore sessionStorage;
    private final TbSecurityStore securityStore;
    private final SecurityChecker securityChecker = new SecurityChecker();
    private final LwM2mClientContext clientContext;

    public Registration isAuthorized(UplinkRequest<?> request, Registration registration, Identity senderIdentity) {
        TbX509DtlsSessionInfo sessionInfo;
        if (senderIdentity.isX509() && (sessionInfo = this.sessionStorage.get(registration.getEndpoint())) != null) {
            if (sessionInfo.getX509CommonName().endsWith(senderIdentity.getX509CommonName())) {
                this.clientContext.registerClient(registration, sessionInfo.getCredentials());
                return registration;
            }
            return null;
        }
        SecurityInfo expectedSecurityInfo = null;
        if (this.securityStore != null) {
            try {
                expectedSecurityInfo = this.securityStore.getByEndpoint(registration.getEndpoint());
            }
            catch (LwM2MAuthException e) {
                log.info("Registration failed: FORBIDDEN, endpointId: [{}]", (Object)registration.getEndpoint());
                return null;
            }
        }
        if (this.securityChecker.checkSecurityInfo(registration.getEndpoint(), senderIdentity, expectedSecurityInfo)) {
            return registration;
        }
        return null;
    }

    @ConstructorProperties(value={"sessionStorage", "securityStore", "clientContext"})
    public TbLwM2MAuthorizer(TbLwM2MDtlsSessionStore sessionStorage, TbSecurityStore securityStore, LwM2mClientContext clientContext) {
        this.sessionStorage = sessionStorage;
        this.securityStore = securityStore;
        this.clientContext = clientContext;
    }
}

