/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.secure;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.List;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mRPkCredentials {
    private static final Logger log = LoggerFactory.getLogger(LwM2mRPkCredentials.class);
    private PublicKey serverPublicKey;
    private PrivateKey serverPrivateKey;
    private X509Certificate certificate;
    private List<Certificate> trustStore;

    public LwM2mRPkCredentials(String publX, String publY, String privS) {
        this.generatePublicKeyRPK(publX, publY, privS);
    }

    private void generatePublicKeyRPK(String publX, String publY, String privS) {
        try {
            AlgorithmParameters algoParameters = AlgorithmParameters.getInstance("EC");
            algoParameters.init(new ECGenParameterSpec("secp256r1"));
            ECParameterSpec parameterSpec = algoParameters.getParameterSpec(ECParameterSpec.class);
            if (publX != null && !publX.isEmpty() && publY != null && !publY.isEmpty()) {
                byte[] publicX = Hex.decodeHex((char[])publX.toCharArray());
                byte[] publicY = Hex.decodeHex((char[])publY.toCharArray());
                ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(publicX), new BigInteger(publicY)), parameterSpec);
                this.serverPublicKey = KeyFactory.getInstance("EC").generatePublic(publicKeySpec);
            }
            if (privS != null && !privS.isEmpty()) {
                byte[] privateS = Hex.decodeHex((char[])privS.toCharArray());
                ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(privateS), parameterSpec);
                this.serverPrivateKey = KeyFactory.getInstance("EC").generatePrivate(privateKeySpec);
            }
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            log.error("[{}] Failed generate Server KeyRPK", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public PublicKey getServerPublicKey() {
        return this.serverPublicKey;
    }

    public PrivateKey getServerPrivateKey() {
        return this.serverPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public List<Certificate> getTrustStore() {
        return this.trustStore;
    }

    public void setServerPublicKey(PublicKey serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public void setServerPrivateKey(PrivateKey serverPrivateKey) {
        this.serverPrivateKey = serverPrivateKey;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setTrustStore(List<Certificate> trustStore) {
        this.trustStore = trustStore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2mRPkCredentials)) {
            return false;
        }
        LwM2mRPkCredentials other = (LwM2mRPkCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublicKey this$serverPublicKey = this.getServerPublicKey();
        PublicKey other$serverPublicKey = other.getServerPublicKey();
        if (this$serverPublicKey == null ? other$serverPublicKey != null : !this$serverPublicKey.equals(other$serverPublicKey)) {
            return false;
        }
        PrivateKey this$serverPrivateKey = this.getServerPrivateKey();
        PrivateKey other$serverPrivateKey = other.getServerPrivateKey();
        if (this$serverPrivateKey == null ? other$serverPrivateKey != null : !this$serverPrivateKey.equals(other$serverPrivateKey)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        List<Certificate> this$trustStore = this.getTrustStore();
        List<Certificate> other$trustStore = other.getTrustStore();
        return !(this$trustStore == null ? other$trustStore != null : !((Object)this$trustStore).equals(other$trustStore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2mRPkCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKey $serverPublicKey = this.getServerPublicKey();
        result = result * 59 + ($serverPublicKey == null ? 43 : $serverPublicKey.hashCode());
        PrivateKey $serverPrivateKey = this.getServerPrivateKey();
        result = result * 59 + ($serverPrivateKey == null ? 43 : $serverPrivateKey.hashCode());
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        List<Certificate> $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : ((Object)$trustStore).hashCode());
        return result;
    }

    public String toString() {
        return "LwM2mRPkCredentials(serverPublicKey=" + this.getServerPublicKey() + ", serverPrivateKey=" + this.getServerPrivateKey() + ", certificate=" + this.getCertificate() + ", trustStore=" + this.getTrustStore() + ")";
    }
}

