/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.secure;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.util.SecurityUtil;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MClientCredentials;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MSecurityMode;
import org.thingsboard.server.common.data.device.credentials.lwm2m.PSKClientCredentials;
import org.thingsboard.server.common.data.device.credentials.lwm2m.RPKClientCredentials;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.secure.credentials.LwM2MCredentials;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MAuthException;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

@Component
@TbLwM2mTransportComponent
public class LwM2mCredentialsSecurityInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(LwM2mCredentialsSecurityInfoValidator.class);
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;

    public TbLwM2MSecurityInfo getEndpointSecurityInfoByCredentialsId(final String credentialsId, final LwM2mTypeServer keyValue) {
        final CountDownLatch latch = new CountDownLatch(1);
        final TbLwM2MSecurityInfo[] resultSecurityStore = new TbLwM2MSecurityInfo[1];
        log.trace("Validating credentials [{}]", (Object)credentialsId);
        this.context.getTransportService().process(TransportProtos.ValidateDeviceLwM2MCredentialsRequestMsg.newBuilder().setCredentialsId(credentialsId).build(), (TransportServiceCallback)new TransportServiceCallback<ValidateDeviceCredentialsResponse>(){

            public void onSuccess(ValidateDeviceCredentialsResponse msg) {
                log.trace("Validated credentials: [{}] [{}]", (Object)credentialsId, (Object)msg);
                String credentialsBody = msg.getCredentials();
                resultSecurityStore[0] = LwM2mCredentialsSecurityInfoValidator.this.createSecurityInfo(credentialsId, credentialsBody, keyValue);
                resultSecurityStore[0].setMsg(msg);
                resultSecurityStore[0].setDeviceProfile(msg.getDeviceProfile());
                latch.countDown();
            }

            public void onError(Throwable e) {
                log.trace("[{}] [{}] Failed to process credentials ", (Object)credentialsId, (Object)e);
                resultSecurityStore[0] = LwM2mCredentialsSecurityInfoValidator.this.createSecurityInfo(credentialsId, null, null);
                latch.countDown();
            }
        });
        try {
            latch.await(this.config.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("Failed to await credentials!", (Throwable)e);
        }
        TbLwM2MSecurityInfo securityInfo = resultSecurityStore[0];
        if (securityInfo.getSecurityMode() == null) {
            throw new LwM2MAuthException();
        }
        return securityInfo;
    }

    private TbLwM2MSecurityInfo createSecurityInfo(String endpoint, String jsonStr, LwM2mTypeServer keyValue) {
        TbLwM2MSecurityInfo result = new TbLwM2MSecurityInfo();
        LwM2MCredentials credentials = (LwM2MCredentials)JacksonUtil.fromString((String)jsonStr, LwM2MCredentials.class);
        if (credentials != null) {
            if (keyValue.equals((Object)LwM2mTypeServer.BOOTSTRAP)) {
                result.setBootstrapCredentialConfig(credentials.getBootstrap());
                if (LwM2MSecurityMode.PSK.equals((Object)credentials.getClient().getSecurityConfigClientMode())) {
                    PSKClientCredentials pskClientConfig = (PSKClientCredentials)credentials.getClient();
                    endpoint = StringUtils.isNotEmpty((String)pskClientConfig.getEndpoint()) ? pskClientConfig.getEndpoint() : endpoint;
                }
                result.setEndpoint(endpoint);
                result.setSecurityMode(credentials.getBootstrap().getBootstrapServer().getSecurityMode());
            } else {
                result.setEndpoint(credentials.getClient().getEndpoint());
                switch (credentials.getClient().getSecurityConfigClientMode()) {
                    case NO_SEC: {
                        this.createClientSecurityInfoNoSec(result);
                        break;
                    }
                    case PSK: {
                        this.createClientSecurityInfoPSK(result, endpoint, credentials.getClient());
                        break;
                    }
                    case RPK: {
                        this.createClientSecurityInfoRPK(result, endpoint, credentials.getClient());
                        break;
                    }
                    case X509: {
                        this.createClientSecurityInfoX509(result, endpoint, credentials.getClient());
                        break;
                    }
                }
            }
        }
        return result;
    }

    private void createClientSecurityInfoNoSec(TbLwM2MSecurityInfo result) {
        result.setSecurityInfo(null);
        result.setSecurityMode(SecurityMode.NO_SEC);
    }

    private void createClientSecurityInfoPSK(TbLwM2MSecurityInfo result, String endpoint, LwM2MClientCredentials clientCredentialsConfig) {
        block5: {
            PSKClientCredentials pskConfig = (PSKClientCredentials)clientCredentialsConfig;
            if (StringUtils.isNotEmpty((String)pskConfig.getIdentity())) {
                try {
                    if (pskConfig.getDecodedKey() == null || pskConfig.getDecodedKey().length <= 0) break block5;
                    String string = endpoint = StringUtils.isNotEmpty((String)pskConfig.getEndpoint()) ? pskConfig.getEndpoint() : endpoint;
                    if (endpoint != null && !endpoint.isEmpty()) {
                        result.setSecurityInfo(SecurityInfo.newPreSharedKeyInfo((String)endpoint, (String)pskConfig.getIdentity(), (byte[])pskConfig.getDecodedKey()));
                        result.setSecurityMode(SecurityMode.PSK);
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error("Missing PSK key: " + e.getMessage());
                }
            } else {
                log.error("Missing PSK identity");
            }
        }
    }

    private void createClientSecurityInfoRPK(TbLwM2MSecurityInfo result, String endpoint, LwM2MClientCredentials clientCredentialsConfig) {
        RPKClientCredentials rpkConfig = (RPKClientCredentials)clientCredentialsConfig;
        try {
            if (rpkConfig.getDecodedKey() != null) {
                PublicKey key = (PublicKey)SecurityUtil.publicKey.decode(rpkConfig.getDecodedKey());
                result.setSecurityInfo(SecurityInfo.newRawPublicKeyInfo((String)endpoint, (PublicKey)key));
                result.setSecurityMode(SecurityMode.RPK);
            } else {
                log.error("Missing RPK key");
            }
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            log.error("RPK: Invalid security info content: " + e.getMessage());
        }
    }

    private void createClientSecurityInfoX509(TbLwM2MSecurityInfo result, String endpoint, LwM2MClientCredentials clientCredentialsConfig) {
        result.setSecurityInfo(SecurityInfo.newX509CertInfo((String)endpoint));
        result.setSecurityMode(SecurityMode.X509);
    }

    @ConstructorProperties(value={"context", "config"})
    public LwM2mCredentialsSecurityInfoValidator(LwM2mTransportContext context, LwM2MTransportServerConfig config) {
        this.context = context;
        this.config = config;
    }
}

