/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.request.ContentFormat;

public enum LwM2mVersion {
    VERSION_1_0(0, LwM2m.Version.V1_0, ContentFormat.TLV, false),
    VERSION_1_1(1, LwM2m.Version.V1_1, ContentFormat.TEXT, true);

    private final int code;
    private final LwM2m.Version version;
    private final ContentFormat contentFormat;
    private final boolean composite;

    private LwM2mVersion(int code, LwM2m.Version version, ContentFormat contentFormat, boolean composite) {
        this.code = code;
        this.version = version;
        this.contentFormat = contentFormat;
        this.composite = composite;
    }

    public static LwM2mVersion fromVersion(LwM2m.Version version) {
        for (LwM2mVersion to : LwM2mVersion.values()) {
            if (!to.version.equals((Object)version)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported typeLwM2mVersion type : %s", version));
    }

    public static LwM2mVersion fromVersionStr(String versionStr) {
        for (LwM2mVersion to : LwM2mVersion.values()) {
            if (!to.version.toString().equals(versionStr)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported contentFormatLwM2mVersion version : %s", versionStr));
    }

    public static LwM2mVersion fromCode(int code) {
        for (LwM2mVersion to : LwM2mVersion.values()) {
            if (to.code != code) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported codeLwM2mVersion code : %d", code));
    }

    public int getCode() {
        return this.code;
    }

    public LwM2m.Version getVersion() {
        return this.version;
    }

    public ContentFormat getContentFormat() {
        return this.contentFormat;
    }

    public boolean isComposite() {
        return this.composite;
    }
}

