/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import java.io.InputStream;
import java.security.KeyStore;
import javax.annotation.PostConstruct;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ResourceUtils;
import org.thingsboard.server.transport.lwm2m.config.LwM2MSecureServerConfig;

@Component
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' && '${transport.lwm2m.enabled:false}'=='true') || '${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core'")
public class LwM2MTransportServerConfig
implements LwM2MSecureServerConfig {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportServerConfig.class);
    private LwM2mModelProvider modelProvider;
    @Value(value="${transport.lwm2m.timeout:}")
    private Long timeout;
    @Value(value="${transport.sessions.report_timeout}")
    private long sessionReportTimeout;
    @Value(value="${transport.lwm2m.security.recommended_ciphers:}")
    private boolean recommendedCiphers;
    @Value(value="${transport.lwm2m.security.recommended_supported_groups:}")
    private boolean recommendedSupportedGroups;
    @Value(value="${transport.lwm2m.downlink_pool_size:}")
    private int downlinkPoolSize;
    @Value(value="${transport.lwm2m.uplink_pool_size:}")
    private int uplinkPoolSize;
    @Value(value="${transport.lwm2m.ota_pool_size:}")
    private int otaPoolSize;
    @Value(value="${transport.lwm2m.clean_period_in_sec:}")
    private int cleanPeriodInSec;
    @Value(value="${transport.lwm2m.security.key_store_type:}")
    private String keyStoreType;
    @Value(value="${transport.lwm2m.security.key_store:}")
    private String keyStoreFilePath;
    private KeyStore keyStoreValue;
    @Value(value="${transport.lwm2m.security.key_store_password:}")
    private String keyStorePassword;
    @Value(value="${transport.lwm2m.security.root_alias:}")
    private String rootCertificateAlias;
    @Value(value="${transport.lwm2m.server.id:}")
    private Integer id;
    @Value(value="${transport.lwm2m.server.bind_address:}")
    private String host;
    @Value(value="${transport.lwm2m.server.bind_port:}")
    private Integer port;
    @Value(value="${transport.lwm2m.server.security.bind_address:}")
    private String secureHost;
    @Value(value="${transport.lwm2m.server.security.bind_port:}")
    private Integer securePort;
    @Value(value="${transport.lwm2m.server.security.key_alias:}")
    private String certificateAlias;
    @Value(value="${transport.lwm2m.server.security.key_password:}")
    private String certificatePassword;
    @Value(value="${transport.lwm2m.log_max_length:}")
    private int logMaxLength;
    @Value(value="${transport.lwm2m.psm_activity_timer:10000}")
    private long psmActivityTimer;
    @Value(value="${transport.lwm2m.paging_transmission_window:10000}")
    private long pagingTransmissionWindow;

    @PostConstruct
    public void init() {
        try {
            InputStream keyStoreInputStream = ResourceUtils.getInputStream((Object)this, (String)this.keyStoreFilePath);
            this.keyStoreValue = KeyStore.getInstance(this.keyStoreType);
            this.keyStoreValue.load(keyStoreInputStream, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            log.info("Unable to lookup LwM2M keystore. Reason: {}, {}", (Object)this.keyStoreFilePath, (Object)e.getMessage());
        }
    }

    public LwM2mModelProvider getModelProvider() {
        return this.modelProvider;
    }

    public void setModelProvider(LwM2mModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public long getSessionReportTimeout() {
        return this.sessionReportTimeout;
    }

    public boolean isRecommendedCiphers() {
        return this.recommendedCiphers;
    }

    public boolean isRecommendedSupportedGroups() {
        return this.recommendedSupportedGroups;
    }

    public int getDownlinkPoolSize() {
        return this.downlinkPoolSize;
    }

    public int getUplinkPoolSize() {
        return this.uplinkPoolSize;
    }

    public int getOtaPoolSize() {
        return this.otaPoolSize;
    }

    public int getCleanPeriodInSec() {
        return this.cleanPeriodInSec;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public KeyStore getKeyStoreValue() {
        return this.keyStoreValue;
    }

    public void setKeyStoreValue(KeyStore keyStoreValue) {
        this.keyStoreValue = keyStoreValue;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getRootCertificateAlias() {
        return this.rootCertificateAlias;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getSecureHost() {
        return this.secureHost;
    }

    @Override
    public Integer getSecurePort() {
        return this.securePort;
    }

    @Override
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public int getLogMaxLength() {
        return this.logMaxLength;
    }

    public long getPsmActivityTimer() {
        return this.psmActivityTimer;
    }

    public long getPagingTransmissionWindow() {
        return this.pagingTransmissionWindow;
    }
}

