/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.transport.lwm2m.config.LwM2MSecureServerConfig;

@Component
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' && '${transport.lwm2m.enabled:false}'=='true') || '${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core'")
public class LwM2MTransportBootstrapConfig
implements LwM2MSecureServerConfig {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportBootstrapConfig.class);
    @Value(value="${transport.lwm2m.bootstrap.id:}")
    private Integer id;
    @Value(value="${transport.lwm2m.bootstrap.bind_address:}")
    private String host;
    @Value(value="${transport.lwm2m.bootstrap.bind_port:}")
    private Integer port;
    @Value(value="${transport.lwm2m.bootstrap.security.bind_address:}")
    private String secureHost;
    @Value(value="${transport.lwm2m.bootstrap.security.bind_port:}")
    private Integer securePort;
    @Value(value="${transport.lwm2m.bootstrap.security.key_alias:}")
    private String certificateAlias;
    @Value(value="${transport.lwm2m.bootstrap.security.key_password:}")
    private String certificatePassword;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getSecureHost() {
        return this.secureHost;
    }

    @Override
    public Integer getSecurePort() {
        return this.securePort;
    }

    @Override
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    public String getCertificatePassword() {
        return this.certificatePassword;
    }
}

