/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSession;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSessionManager;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityChecker;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mDefaultBootstrapSessionManager
extends DefaultBootstrapSessionManager {
    private static final Logger log = LoggerFactory.getLogger(LwM2mDefaultBootstrapSessionManager.class);
    private BootstrapSecurityStore bsSecurityStore;
    private SecurityChecker securityChecker;

    public LwM2mDefaultBootstrapSessionManager(BootstrapSecurityStore bsSecurityStore) {
        this(bsSecurityStore, new SecurityChecker());
    }

    public LwM2mDefaultBootstrapSessionManager(BootstrapSecurityStore bsSecurityStore, SecurityChecker securityChecker) {
        super(bsSecurityStore);
        this.bsSecurityStore = bsSecurityStore;
        this.securityChecker = securityChecker;
    }

    public BootstrapSession begin(BootstrapRequest request, Identity clientIdentity) {
        boolean authorized;
        if (this.bsSecurityStore != null) {
            Iterator<SecurityInfo> securityInfos = clientIdentity.getPskIdentity() != null && !clientIdentity.getPskIdentity().isEmpty() ? Collections.singletonList(this.bsSecurityStore.getByIdentity(clientIdentity.getPskIdentity())).iterator() : this.bsSecurityStore.getAllByEndpoint(request.getEndpointName());
            log.info("Bootstrap session started securityInfos: [{}]", (Object)securityInfos);
            authorized = this.securityChecker.checkSecurityInfos(request.getEndpointName(), clientIdentity, securityInfos);
        } else {
            authorized = true;
        }
        DefaultBootstrapSession session = new DefaultBootstrapSession(request, clientIdentity, authorized);
        log.info("Bootstrap session started : {}", (Object)session);
        return session;
    }
}

