/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import org.eclipse.leshan.core.SecurityMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2MServerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(LwM2MServerBootstrap.class);
    String clientPublicKeyOrId = "";
    String clientSecretKey = "";
    String serverPublicKey = "";
    Integer clientHoldOffTime = 1;
    Integer bootstrapServerAccountTimeout = 0;
    String host = "0.0.0.0";
    Integer port = 0;
    String securityHost = "0.0.0.0";
    Integer securityPort = 0;
    SecurityMode securityMode = SecurityMode.NO_SEC;
    Integer serverId = 123;
    boolean bootstrapServerIs = false;

    public LwM2MServerBootstrap() {
    }

    public LwM2MServerBootstrap(LwM2MServerBootstrap bootstrapFromCredential, LwM2MServerBootstrap profileServerBootstrap) {
        this.clientPublicKeyOrId = bootstrapFromCredential.getClientPublicKeyOrId();
        this.clientSecretKey = bootstrapFromCredential.getClientSecretKey();
        this.serverPublicKey = profileServerBootstrap.getServerPublicKey();
        this.clientHoldOffTime = profileServerBootstrap.getClientHoldOffTime();
        this.bootstrapServerAccountTimeout = profileServerBootstrap.getBootstrapServerAccountTimeout();
        this.host = profileServerBootstrap.getHost().equals("0.0.0.0") ? "localhost" : profileServerBootstrap.getHost();
        this.port = profileServerBootstrap.getPort();
        this.securityHost = profileServerBootstrap.getSecurityHost().equals("0.0.0.0") ? "localhost" : profileServerBootstrap.getSecurityHost();
        this.securityPort = profileServerBootstrap.getSecurityPort();
        this.securityMode = profileServerBootstrap.getSecurityMode();
        this.serverId = profileServerBootstrap.getServerId();
        this.bootstrapServerIs = profileServerBootstrap.bootstrapServerIs;
    }

    public String getClientPublicKeyOrId() {
        return this.clientPublicKeyOrId;
    }

    public String getClientSecretKey() {
        return this.clientSecretKey;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public Integer getClientHoldOffTime() {
        return this.clientHoldOffTime;
    }

    public Integer getBootstrapServerAccountTimeout() {
        return this.bootstrapServerAccountTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getSecurityHost() {
        return this.securityHost;
    }

    public Integer getSecurityPort() {
        return this.securityPort;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public Integer getServerId() {
        return this.serverId;
    }

    public boolean isBootstrapServerIs() {
        return this.bootstrapServerIs;
    }

    public void setClientPublicKeyOrId(String clientPublicKeyOrId) {
        this.clientPublicKeyOrId = clientPublicKeyOrId;
    }

    public void setClientSecretKey(String clientSecretKey) {
        this.clientSecretKey = clientSecretKey;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public void setClientHoldOffTime(Integer clientHoldOffTime) {
        this.clientHoldOffTime = clientHoldOffTime;
    }

    public void setBootstrapServerAccountTimeout(Integer bootstrapServerAccountTimeout) {
        this.bootstrapServerAccountTimeout = bootstrapServerAccountTimeout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setSecurityHost(String securityHost) {
        this.securityHost = securityHost;
    }

    public void setSecurityPort(Integer securityPort) {
        this.securityPort = securityPort;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public void setServerId(Integer serverId) {
        this.serverId = serverId;
    }

    public void setBootstrapServerIs(boolean bootstrapServerIs) {
        this.bootstrapServerIs = bootstrapServerIs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MServerBootstrap)) {
            return false;
        }
        LwM2MServerBootstrap other = (LwM2MServerBootstrap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBootstrapServerIs() != other.isBootstrapServerIs()) {
            return false;
        }
        Integer this$clientHoldOffTime = this.getClientHoldOffTime();
        Integer other$clientHoldOffTime = other.getClientHoldOffTime();
        if (this$clientHoldOffTime == null ? other$clientHoldOffTime != null : !((Object)this$clientHoldOffTime).equals(other$clientHoldOffTime)) {
            return false;
        }
        Integer this$bootstrapServerAccountTimeout = this.getBootstrapServerAccountTimeout();
        Integer other$bootstrapServerAccountTimeout = other.getBootstrapServerAccountTimeout();
        if (this$bootstrapServerAccountTimeout == null ? other$bootstrapServerAccountTimeout != null : !((Object)this$bootstrapServerAccountTimeout).equals(other$bootstrapServerAccountTimeout)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$securityPort = this.getSecurityPort();
        Integer other$securityPort = other.getSecurityPort();
        if (this$securityPort == null ? other$securityPort != null : !((Object)this$securityPort).equals(other$securityPort)) {
            return false;
        }
        Integer this$serverId = this.getServerId();
        Integer other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !((Object)this$serverId).equals(other$serverId)) {
            return false;
        }
        String this$clientPublicKeyOrId = this.getClientPublicKeyOrId();
        String other$clientPublicKeyOrId = other.getClientPublicKeyOrId();
        if (this$clientPublicKeyOrId == null ? other$clientPublicKeyOrId != null : !this$clientPublicKeyOrId.equals(other$clientPublicKeyOrId)) {
            return false;
        }
        String this$clientSecretKey = this.getClientSecretKey();
        String other$clientSecretKey = other.getClientSecretKey();
        if (this$clientSecretKey == null ? other$clientSecretKey != null : !this$clientSecretKey.equals(other$clientSecretKey)) {
            return false;
        }
        String this$serverPublicKey = this.getServerPublicKey();
        String other$serverPublicKey = other.getServerPublicKey();
        if (this$serverPublicKey == null ? other$serverPublicKey != null : !this$serverPublicKey.equals(other$serverPublicKey)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$securityHost = this.getSecurityHost();
        String other$securityHost = other.getSecurityHost();
        if (this$securityHost == null ? other$securityHost != null : !this$securityHost.equals(other$securityHost)) {
            return false;
        }
        SecurityMode this$securityMode = this.getSecurityMode();
        SecurityMode other$securityMode = other.getSecurityMode();
        return !(this$securityMode == null ? other$securityMode != null : !this$securityMode.equals(other$securityMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MServerBootstrap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBootstrapServerIs() ? 79 : 97);
        Integer $clientHoldOffTime = this.getClientHoldOffTime();
        result = result * 59 + ($clientHoldOffTime == null ? 43 : ((Object)$clientHoldOffTime).hashCode());
        Integer $bootstrapServerAccountTimeout = this.getBootstrapServerAccountTimeout();
        result = result * 59 + ($bootstrapServerAccountTimeout == null ? 43 : ((Object)$bootstrapServerAccountTimeout).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $securityPort = this.getSecurityPort();
        result = result * 59 + ($securityPort == null ? 43 : ((Object)$securityPort).hashCode());
        Integer $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : ((Object)$serverId).hashCode());
        String $clientPublicKeyOrId = this.getClientPublicKeyOrId();
        result = result * 59 + ($clientPublicKeyOrId == null ? 43 : $clientPublicKeyOrId.hashCode());
        String $clientSecretKey = this.getClientSecretKey();
        result = result * 59 + ($clientSecretKey == null ? 43 : $clientSecretKey.hashCode());
        String $serverPublicKey = this.getServerPublicKey();
        result = result * 59 + ($serverPublicKey == null ? 43 : $serverPublicKey.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $securityHost = this.getSecurityHost();
        result = result * 59 + ($securityHost == null ? 43 : $securityHost.hashCode());
        SecurityMode $securityMode = this.getSecurityMode();
        result = result * 59 + ($securityMode == null ? 43 : $securityMode.hashCode());
        return result;
    }

    public String toString() {
        return "LwM2MServerBootstrap(clientPublicKeyOrId=" + this.getClientPublicKeyOrId() + ", clientSecretKey=" + this.getClientSecretKey() + ", serverPublicKey=" + this.getServerPublicKey() + ", clientHoldOffTime=" + this.getClientHoldOffTime() + ", bootstrapServerAccountTimeout=" + this.getBootstrapServerAccountTimeout() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", securityHost=" + this.getSecurityHost() + ", securityPort=" + this.getSecurityPort() + ", securityMode=" + this.getSecurityMode() + ", serverId=" + this.getServerId() + ", bootstrapServerIs=" + this.isBootstrapServerIs() + ")";
    }
}

