/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.InMemoryBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component(value="LwM2MInMemoryBootstrapConfigStore")
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' && '${transport.lwm2m.enabled:false}'=='true' && '${transport.lwm2m.bootstrap.enable:false}'=='true') || ('${service.type:null}'=='monolith' && '${transport.lwm2m.enabled}'=='true'&& '${transport.lwm2m.bootstrap.enable}'=='true')")
public class LwM2MInMemoryBootstrapConfigStore
extends InMemoryBootstrapConfigStore {
    private static final Logger log = LoggerFactory.getLogger(LwM2MInMemoryBootstrapConfigStore.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public Map<String, BootstrapConfig> getAll() {
        this.readLock.lock();
        try {
            Map map = super.getAll();
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void add(String endpoint, BootstrapConfig config) throws InvalidConfigurationException {
        this.writeLock.lock();
        try {
            this.addToStore(endpoint, config);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public BootstrapConfig remove(String enpoint) {
        this.writeLock.lock();
        try {
            BootstrapConfig bootstrapConfig = super.remove(enpoint);
            return bootstrapConfig;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addToStore(String endpoint, BootstrapConfig config) throws InvalidConfigurationException {
        super.add(endpoint, config);
    }
}

