/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.core.util.SecurityUtil;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.eclipse.leshan.server.bootstrap.EditableBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.InvalidConfigurationException;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.device.data.lwm2m.BootstrapConfiguration;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapServers;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MServerBootstrap;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.secure.TbLwM2MSecurityInfo;
import org.thingsboard.server.transport.lwm2m.server.LwM2mSessionMsgListener;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportUtil;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mTypeServer;

@Service(value="LwM2MBootstrapSecurityStore")
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' && '${transport.lwm2m.enabled:false}'=='true' && '${transport.lwm2m.bootstrap.enable:false}'=='true') || ('${service.type:null}'=='monolith' && '${transport.lwm2m.enabled}'=='true' && '${transport.lwm2m.bootstrap.enable}'=='true')")
public class LwM2MBootstrapSecurityStore
implements BootstrapSecurityStore {
    private static final Logger log = LoggerFactory.getLogger(LwM2MBootstrapSecurityStore.class);
    private final EditableBootstrapConfigStore bootstrapConfigStore;
    private final LwM2mCredentialsSecurityInfoValidator lwM2MCredentialsSecurityInfoValidator;
    private final LwM2mTransportContext context;
    private final LwM2mTransportServerHelper helper;

    public LwM2MBootstrapSecurityStore(EditableBootstrapConfigStore bootstrapConfigStore, LwM2mCredentialsSecurityInfoValidator lwM2MCredentialsSecurityInfoValidator, LwM2mTransportContext context, LwM2mTransportServerHelper helper) {
        this.bootstrapConfigStore = bootstrapConfigStore;
        this.lwM2MCredentialsSecurityInfoValidator = lwM2MCredentialsSecurityInfoValidator;
        this.context = context;
        this.helper = helper;
    }

    public Iterator<SecurityInfo> getAllByEndpoint(String endPoint) {
        TbLwM2MSecurityInfo store = this.lwM2MCredentialsSecurityInfoValidator.getEndpointSecurityInfoByCredentialsId(endPoint, LwM2mTypeServer.BOOTSTRAP);
        if (store.getBootstrapCredentialConfig() != null && store.getSecurityMode() != null) {
            this.setBootstrapConfigScurityInfo(store);
            BootstrapConfig bsConfigNew = store.getBootstrapConfig();
            if (bsConfigNew != null) {
                try {
                    for (String config : this.bootstrapConfigStore.getAll().keySet()) {
                        if (!config.equals(endPoint)) continue;
                        this.bootstrapConfigStore.remove(config);
                    }
                    this.bootstrapConfigStore.add(endPoint, bsConfigNew);
                }
                catch (InvalidConfigurationException e) {
                    log.error("", (Throwable)e);
                }
                return store.getSecurityInfo() == null ? null : Collections.singletonList(store.getSecurityInfo()).iterator();
            }
        }
        return null;
    }

    public SecurityInfo getByIdentity(String identity) {
        TbLwM2MSecurityInfo store = this.lwM2MCredentialsSecurityInfoValidator.getEndpointSecurityInfoByCredentialsId(identity, LwM2mTypeServer.BOOTSTRAP);
        if (store.getBootstrapCredentialConfig() != null && store.getSecurityMode() != null) {
            this.setBootstrapConfigScurityInfo(store);
            BootstrapConfig bsConfig = store.getBootstrapConfig();
            if (bsConfig.security != null) {
                try {
                    this.bootstrapConfigStore.add(store.getEndpoint(), bsConfig);
                }
                catch (InvalidConfigurationException e) {
                    log.error("", (Throwable)e);
                }
                return store.getSecurityInfo();
            }
        }
        return null;
    }

    private void setBootstrapConfigScurityInfo(TbLwM2MSecurityInfo store) {
        LwM2MBootstrapConfig lwM2MBootstrapConfig = this.getParametersBootstrap(store);
        if (lwM2MBootstrapConfig != null) {
            switch (lwM2MBootstrapConfig.getBootstrapServer().getSecurityMode()) {
                case PSK: {
                    store.setSecurityInfo(SecurityInfo.newPreSharedKeyInfo((String)store.getEndpoint(), (String)lwM2MBootstrapConfig.getBootstrapServer().getClientPublicKeyOrId(), (byte[])Hex.decodeHex((char[])lwM2MBootstrapConfig.getBootstrapServer().getClientSecretKey().toCharArray())));
                    store.setSecurityMode(SecurityMode.PSK);
                    break;
                }
                case RPK: {
                    try {
                        store.setSecurityInfo(SecurityInfo.newRawPublicKeyInfo((String)store.getEndpoint(), (PublicKey)((PublicKey)SecurityUtil.publicKey.decode(Hex.decodeHex((char[])lwM2MBootstrapConfig.getBootstrapServer().getClientPublicKeyOrId().toCharArray())))));
                        store.setSecurityMode(SecurityMode.RPK);
                        break;
                    }
                    catch (IOException | GeneralSecurityException e) {
                        log.error("Unable to decode Client public key for [{}]  [{}]", (Object)store.getEndpoint(), (Object)e.getMessage());
                    }
                }
                case X509: {
                    store.setSecurityInfo(SecurityInfo.newX509CertInfo((String)store.getEndpoint()));
                    store.setSecurityMode(SecurityMode.X509);
                    break;
                }
                case NO_SEC: {
                    store.setSecurityMode(SecurityMode.NO_SEC);
                    store.setSecurityInfo(null);
                    break;
                }
            }
            BootstrapConfig bootstrapConfig = lwM2MBootstrapConfig.getLwM2MBootstrapConfig();
            store.setBootstrapConfig(bootstrapConfig);
        }
    }

    private LwM2MBootstrapConfig getParametersBootstrap(TbLwM2MSecurityInfo store) {
        LwM2MBootstrapConfig lwM2MBootstrapConfig = store.getBootstrapCredentialConfig();
        if (lwM2MBootstrapConfig != null) {
            BootstrapConfiguration bootstrapObject = LwM2mTransportUtil.getBootstrapParametersFromThingsboard(store.getDeviceProfile());
            lwM2MBootstrapConfig.servers = (LwM2MBootstrapServers)JacksonUtil.fromString((String)JacksonUtil.toString((Object)bootstrapObject.getServers()), LwM2MBootstrapServers.class);
            LwM2MServerBootstrap profileServerBootstrap = (LwM2MServerBootstrap)JacksonUtil.fromString((String)JacksonUtil.toString((Object)bootstrapObject.getBootstrapServer()), LwM2MServerBootstrap.class);
            LwM2MServerBootstrap profileLwm2mServer = (LwM2MServerBootstrap)JacksonUtil.fromString((String)JacksonUtil.toString((Object)bootstrapObject.getLwm2mServer()), LwM2MServerBootstrap.class);
            UUID sessionUUiD = UUID.randomUUID();
            TransportProtos.SessionInfoProto sessionInfo = this.helper.getValidateSessionInfo(store.getMsg(), sessionUUiD.getMostSignificantBits(), sessionUUiD.getLeastSignificantBits());
            this.context.getTransportService().registerAsyncSession(sessionInfo, (SessionMsgListener)new LwM2mSessionMsgListener(null, null, null, sessionInfo, this.context.getTransportService()));
            if (this.getValidatedSecurityMode(lwM2MBootstrapConfig.bootstrapServer, profileServerBootstrap, lwM2MBootstrapConfig.lwm2mServer, profileLwm2mServer)) {
                lwM2MBootstrapConfig.bootstrapServer = new LwM2MServerBootstrap(lwM2MBootstrapConfig.bootstrapServer, profileServerBootstrap);
                lwM2MBootstrapConfig.lwm2mServer = new LwM2MServerBootstrap(lwM2MBootstrapConfig.lwm2mServer, profileLwm2mServer);
                String logMsg = String.format("%s: getParametersBootstrap: %s Access connect client with bootstrap server.", "info", store.getEndpoint());
                this.helper.sendParametersOnThingsboardTelemetry(this.helper.getKvStringtoThingsboard("transportLog", logMsg), sessionInfo);
                return lwM2MBootstrapConfig;
            }
            log.error(" [{}] Different values SecurityMode between of client and profile.", (Object)store.getEndpoint());
            log.error("{} getParametersBootstrap: [{}] Different values SecurityMode between of client and profile.", (Object)"error", (Object)store.getEndpoint());
            String logMsg = String.format("%s: getParametersBootstrap: %s Different values SecurityMode between of client and profile.", "error", store.getEndpoint());
            this.helper.sendParametersOnThingsboardTelemetry(this.helper.getKvStringtoThingsboard("transportLog", logMsg), sessionInfo);
            return null;
        }
        log.error("Unable to decode Json or Certificate for [{}]", (Object)store.getEndpoint());
        return null;
    }

    private boolean getValidatedSecurityMode(LwM2MServerBootstrap bootstrapFromCredential, LwM2MServerBootstrap profileServerBootstrap, LwM2MServerBootstrap lwm2mFromCredential, LwM2MServerBootstrap profileLwm2mServer) {
        return bootstrapFromCredential.getSecurityMode().equals((Object)profileServerBootstrap.getSecurityMode()) && lwm2mFromCredential.getSecurityMode().equals((Object)profileLwm2mServer.getSecurityMode());
    }
}

