/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap.secure;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.bootstrap.BootstrapConfig;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapServers;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MServerBootstrap;

public class LwM2MBootstrapConfig
implements Serializable {
    LwM2MBootstrapServers servers;
    LwM2MServerBootstrap bootstrapServer;
    LwM2MServerBootstrap lwm2mServer;

    public BootstrapConfig getLwM2MBootstrapConfig() {
        BootstrapConfig configBs = new BootstrapConfig();
        configBs.toDelete.add("/0");
        configBs.toDelete.add("/1");
        BootstrapConfig.ServerConfig server0 = new BootstrapConfig.ServerConfig();
        server0.shortId = this.servers.getShortId();
        server0.lifetime = this.servers.getLifetime();
        server0.defaultMinPeriod = this.servers.getDefaultMinPeriod();
        server0.notifIfDisabled = this.servers.isNotifIfDisabled();
        server0.binding = BindingMode.parse((String)this.servers.getBinding());
        configBs.servers.put(0, server0);
        this.bootstrapServer.setBootstrapServerIs(true);
        configBs.security.put(0, this.setServerSecurity(this.lwm2mServer.getHost(), this.lwm2mServer.getPort(), this.lwm2mServer.getSecurityHost(), this.lwm2mServer.getSecurityPort(), this.bootstrapServer.isBootstrapServerIs(), this.bootstrapServer.getSecurityMode(), this.bootstrapServer.getClientPublicKeyOrId(), this.bootstrapServer.getServerPublicKey(), this.bootstrapServer.getClientSecretKey(), this.bootstrapServer.getServerId()));
        configBs.security.put(1, this.setServerSecurity(this.lwm2mServer.getHost(), this.lwm2mServer.getPort(), this.lwm2mServer.getSecurityHost(), this.lwm2mServer.getSecurityPort(), this.lwm2mServer.isBootstrapServerIs(), this.lwm2mServer.getSecurityMode(), this.lwm2mServer.getClientPublicKeyOrId(), this.lwm2mServer.getServerPublicKey(), this.lwm2mServer.getClientSecretKey(), this.lwm2mServer.getServerId()));
        return configBs;
    }

    private BootstrapConfig.ServerSecurity setServerSecurity(String host, Integer port, String securityHost, Integer securityPort, boolean bootstrapServer, SecurityMode securityMode, String clientPublicKey, String serverPublicKey, String secretKey, int serverId) {
        BootstrapConfig.ServerSecurity serverSecurity = new BootstrapConfig.ServerSecurity();
        serverSecurity.uri = securityMode.equals((Object)SecurityMode.NO_SEC) ? "coap://" + host + ":" + Integer.toString(port) : "coaps://" + securityHost + ":" + Integer.toString(securityPort);
        serverSecurity.bootstrapServer = bootstrapServer;
        serverSecurity.securityMode = securityMode;
        serverSecurity.publicKeyOrId = this.setPublicKeyOrId(clientPublicKey, securityMode);
        serverSecurity.serverPublicKey = serverPublicKey != null && !serverPublicKey.isEmpty() ? Hex.decodeHex((char[])serverPublicKey.toCharArray()) : new byte[]{};
        serverSecurity.secretKey = secretKey != null && !secretKey.isEmpty() ? Hex.decodeHex((char[])secretKey.toCharArray()) : new byte[]{};
        serverSecurity.serverId = serverId;
        return serverSecurity;
    }

    private byte[] setPublicKeyOrId(String publicKeyOrIdStr, SecurityMode securityMode) {
        return publicKeyOrIdStr == null || publicKeyOrIdStr.isEmpty() ? new byte[]{} : (SecurityMode.PSK.equals((Object)securityMode) ? publicKeyOrIdStr.getBytes(StandardCharsets.UTF_8) : Hex.decodeHex((char[])publicKeyOrIdStr.toCharArray()));
    }

    public LwM2MBootstrapServers getServers() {
        return this.servers;
    }

    public LwM2MServerBootstrap getBootstrapServer() {
        return this.bootstrapServer;
    }

    public LwM2MServerBootstrap getLwm2mServer() {
        return this.lwm2mServer;
    }

    public void setServers(LwM2MBootstrapServers servers) {
        this.servers = servers;
    }

    public void setBootstrapServer(LwM2MServerBootstrap bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    public void setLwm2mServer(LwM2MServerBootstrap lwm2mServer) {
        this.lwm2mServer = lwm2mServer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MBootstrapConfig)) {
            return false;
        }
        LwM2MBootstrapConfig other = (LwM2MBootstrapConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LwM2MBootstrapServers this$servers = this.getServers();
        LwM2MBootstrapServers other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        LwM2MServerBootstrap this$bootstrapServer = this.getBootstrapServer();
        LwM2MServerBootstrap other$bootstrapServer = other.getBootstrapServer();
        if (this$bootstrapServer == null ? other$bootstrapServer != null : !((Object)this$bootstrapServer).equals(other$bootstrapServer)) {
            return false;
        }
        LwM2MServerBootstrap this$lwm2mServer = this.getLwm2mServer();
        LwM2MServerBootstrap other$lwm2mServer = other.getLwm2mServer();
        return !(this$lwm2mServer == null ? other$lwm2mServer != null : !((Object)this$lwm2mServer).equals(other$lwm2mServer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MBootstrapConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LwM2MBootstrapServers $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        LwM2MServerBootstrap $bootstrapServer = this.getBootstrapServer();
        result = result * 59 + ($bootstrapServer == null ? 43 : ((Object)$bootstrapServer).hashCode());
        LwM2MServerBootstrap $lwm2mServer = this.getLwm2mServer();
        result = result * 59 + ($lwm2mServer == null ? 43 : ((Object)$lwm2mServer).hashCode());
        return result;
    }

    public String toString() {
        return "LwM2MBootstrapConfig(servers=" + this.getServers() + ", bootstrapServer=" + this.getBootstrapServer() + ", lwm2mServer=" + this.getLwm2mServer() + ")";
    }
}

