/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.bootstrap;

import java.beans.ConstructorProperties;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectLoader;
import org.eclipse.leshan.core.model.StaticModel;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigurationStore;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServerBuilder;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MBootstrapSecurityStore;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MInMemoryBootstrapConfigStore;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2MInMemoryBootstrapConfigurationAdapter;
import org.thingsboard.server.transport.lwm2m.bootstrap.secure.LwM2mDefaultBootstrapSessionManager;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportBootstrapConfig;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.DefaultLwM2mTransportService;
import org.thingsboard.server.transport.lwm2m.server.LwM2mNetworkConfig;

@Component
@ConditionalOnExpression(value="('${service.type:null}'=='tb-transport' && '${transport.lwm2m.enabled:false}'=='true' && '${transport.lwm2m.bootstrap.enable:false}'=='true') || ('${service.type:null}'=='monolith' && '${transport.lwm2m.enabled:false}'=='true'&& '${transport.lwm2m.bootstrap.enable:false}'=='true')")
public class LwM2MTransportBootstrapService {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportBootstrapService.class);
    private boolean pskMode = false;
    private final LwM2MTransportServerConfig serverConfig;
    private final LwM2MTransportBootstrapConfig bootstrapConfig;
    private final LwM2MBootstrapSecurityStore lwM2MBootstrapSecurityStore;
    private final LwM2MInMemoryBootstrapConfigStore lwM2MInMemoryBootstrapConfigStore;
    private LeshanBootstrapServer server;

    @PostConstruct
    public void init() {
        log.info("Starting LwM2M transport bootstrap server...");
        this.server = this.getLhBootstrapServer();
        this.server.start();
        log.info("Started LwM2M transport bootstrap server.");
    }

    @PreDestroy
    public void shutdown() {
        log.info("Stopping LwM2M transport bootstrap server!");
        this.server.destroy();
        log.info("LwM2M transport bootstrap server stopped!");
    }

    public LeshanBootstrapServer getLhBootstrapServer() {
        LeshanBootstrapServerBuilder builder = new LeshanBootstrapServerBuilder();
        builder.setLocalAddress(this.bootstrapConfig.getHost(), this.bootstrapConfig.getPort().intValue());
        builder.setLocalSecureAddress(this.bootstrapConfig.getSecureHost(), this.bootstrapConfig.getSecurePort().intValue());
        builder.setCoapConfig(LwM2mNetworkConfig.getCoapConfig(this.bootstrapConfig.getPort(), this.bootstrapConfig.getSecurePort(), this.serverConfig));
        List models = ObjectLoader.loadDefault();
        builder.setModel((LwM2mModel)new StaticModel((Collection)models));
        this.setServerWithCredentials(builder);
        builder.setConfigStore((BootstrapConfigurationStore)new LwM2MInMemoryBootstrapConfigurationAdapter((BootstrapConfigStore)this.lwM2MInMemoryBootstrapConfigStore));
        builder.setSecurityStore((BootstrapSecurityStore)this.lwM2MBootstrapSecurityStore);
        DtlsConnectorConfig.Builder dtlsConfig = new DtlsConnectorConfig.Builder();
        dtlsConfig.setRecommendedSupportedGroupsOnly(this.serverConfig.isRecommendedSupportedGroups());
        dtlsConfig.setRecommendedCipherSuitesOnly(this.serverConfig.isRecommendedCiphers());
        dtlsConfig.setSupportedCipherSuites(this.pskMode ? DefaultLwM2mTransportService.PSK_CIPHER_SUITES : DefaultLwM2mTransportService.RPK_OR_X509_CIPHER_SUITES);
        builder.setDtlsConfig(dtlsConfig);
        LwM2mDefaultBootstrapSessionManager sessionManager = new LwM2mDefaultBootstrapSessionManager(this.lwM2MBootstrapSecurityStore);
        builder.setSessionManager((BootstrapSessionManager)sessionManager);
        return builder.build();
    }

    private void setServerWithCredentials(LeshanBootstrapServerBuilder builder) {
        try {
            if (this.serverConfig.getKeyStoreValue() != null) {
                KeyStore keyStoreServer = this.serverConfig.getKeyStoreValue();
                if (this.setBuilderX509(builder)) {
                    X509Certificate rootCAX509Cert = (X509Certificate)keyStoreServer.getCertificate(this.serverConfig.getRootCertificateAlias());
                    if (rootCAX509Cert != null) {
                        Certificate[] trustedCertificates = new X509Certificate[]{rootCAX509Cert};
                        builder.setTrustedCertificates(trustedCertificates);
                    } else {
                        builder.setTrustedCertificates((Certificate[])new X509Certificate[0]);
                    }
                }
            } else {
                builder.setTrustedCertificates((Certificate[])new X509Certificate[0]);
                log.info("Unable to load X509 files for BootStrapServer");
                this.pskMode = true;
            }
        }
        catch (KeyStoreException ex) {
            log.error("[{}] Unable to load X509 files server", (Object)ex.getMessage());
        }
    }

    private boolean setBuilderX509(LeshanBootstrapServerBuilder builder) {
        try {
            X509Certificate[] certificateChain = SslContextUtil.asX509Certificates((Certificate[])this.serverConfig.getKeyStoreValue().getCertificateChain(this.bootstrapConfig.getCertificateAlias()));
            X509Certificate serverCertificate = certificateChain[0];
            PrivateKey privateKey = (PrivateKey)this.serverConfig.getKeyStoreValue().getKey(this.bootstrapConfig.getCertificateAlias(), this.serverConfig.getCertificatePassword() == null ? null : this.serverConfig.getCertificatePassword().toCharArray());
            PublicKey publicKey = serverCertificate.getPublicKey();
            if (privateKey != null && privateKey.getEncoded().length > 0 && publicKey != null && publicKey.getEncoded().length > 0) {
                builder.setPublicKey(serverCertificate.getPublicKey());
                builder.setPrivateKey(privateKey);
                builder.setCertificateChain(certificateChain);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            log.error("[{}] Unable to load KeyStore  files server", (Object)ex.getMessage());
            return false;
        }
    }

    @ConstructorProperties(value={"serverConfig", "bootstrapConfig", "lwM2MBootstrapSecurityStore", "lwM2MInMemoryBootstrapConfigStore"})
    public LwM2MTransportBootstrapService(LwM2MTransportServerConfig serverConfig, LwM2MTransportBootstrapConfig bootstrapConfig, LwM2MBootstrapSecurityStore lwM2MBootstrapSecurityStore, LwM2MInMemoryBootstrapConfigStore lwM2MInMemoryBootstrapConfigStore) {
        this.serverConfig = serverConfig;
        this.bootstrapConfig = bootstrapConfig;
        this.lwM2MBootstrapSecurityStore = lwM2MBootstrapSecurityStore;
        this.lwM2MInMemoryBootstrapConfigStore = lwM2MInMemoryBootstrapConfigStore;
    }
}

