/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.http.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.msg.tools.MaxPayloadSizeExceededException;

public class PayloadSizeFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(PayloadSizeFilter.class);
    private final Map<String, Long> limits = new LinkedHashMap<String, Long>();
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public PayloadSizeFilter(String limitsConfiguration) {
        for (String limit : limitsConfiguration.split(";")) {
            try {
                String urlPathPattern = limit.split("=")[0];
                long maxPayloadSize = Long.parseLong(limit.split("=")[1]);
                this.limits.put(urlPathPattern, maxPayloadSize);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse size limits configuration: " + limitsConfiguration);
            }
        }
        log.info("Initialized payload size filter with configuration: {}", (Object)limitsConfiguration);
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        for (String url : this.limits.keySet()) {
            if (!this.pathMatcher.match(url, request.getRequestURI())) continue;
            if (!this.checkMaxPayloadSizeExceeded(request, response, this.limits.get(url))) break;
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean checkMaxPayloadSizeExceeded(HttpServletRequest request, HttpServletResponse response, long maxPayloadSize) throws IOException {
        if ((long)request.getContentLength() > maxPayloadSize) {
            log.info("[{}] [{}] Payload size {} exceeds the limit of {} bytes", new Object[]{request.getRemoteAddr(), request.getRequestURL(), request.getContentLength(), maxPayloadSize});
            this.handleMaxPayloadSizeExceededException(response, new MaxPayloadSizeExceededException(maxPayloadSize));
            return true;
        }
        return false;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    private void handleMaxPayloadSizeExceededException(HttpServletResponse response, MaxPayloadSizeExceededException exception) throws IOException {
        response.setStatus(HttpStatus.PAYLOAD_TOO_LARGE.value());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)exception.getMessage());
    }

    public PayloadSizeFilter() {
    }
}

