/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.http;

import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11NioProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.TransportContext;

@ConditionalOnExpression(value="'${service.type:null}'=='tb-transport' || ('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true' && '${transport.http.enabled}'=='true')")
@Component
public class HttpTransportContext
extends TransportContext {
    private static final Logger log = LoggerFactory.getLogger(HttpTransportContext.class);
    @Value(value="${transport.http.request_timeout}")
    private long defaultTimeout;
    @Value(value="${transport.http.max_request_timeout}")
    private long maxRequestTimeout;

    @Bean
    public TomcatConnectorCustomizer tomcatAsyncTimeoutConnectorCustomizer() {
        return connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof Http11NioProtocol) {
                log.trace("Setting async max request timeout {}", (Object)this.maxRequestTimeout);
                connector.setAsyncTimeout(this.maxRequestTimeout);
            }
        };
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public long getMaxRequestTimeout() {
        return this.maxRequestTimeout;
    }
}

